/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;

public class CPJavaProject {
    private final IJavaProject fJavaProject;
    private final List fCPListElements;
    private IPath fDefaultOutputLocation;

    public static CPJavaProject createFromExisting(IJavaProject javaProject) throws CoreException {
        List classpathEntries = ClasspathModifier.getExistingEntries(javaProject);
        return new CPJavaProject(javaProject, classpathEntries, javaProject.getOutputLocation());
    }

    public CPJavaProject(IJavaProject javaProject, List cpListElements, IPath defaultOutputLocation) {
        this.fJavaProject = javaProject;
        this.fCPListElements = cpListElements;
        this.fDefaultOutputLocation = defaultOutputLocation;
    }

    public CPJavaProject createWorkingCopy() {
        ArrayList<CPListElement> newList = new ArrayList<CPListElement>(this.fCPListElements.size());
        Iterator iterator = this.fCPListElements.iterator();
        while (iterator.hasNext()) {
            CPListElement element = (CPListElement)iterator.next();
            newList.add(element.copy());
        }
        return new CPJavaProject(this.fJavaProject, newList, this.fDefaultOutputLocation);
    }

    public CPListElement get(int index) {
        return (CPListElement)this.fCPListElements.get(index);
    }

    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] result = new IClasspathEntry[this.fCPListElements.size()];
        int i = 0;
        Iterator iterator = this.fCPListElements.iterator();
        while (iterator.hasNext()) {
            CPListElement element = (CPListElement)iterator.next();
            result[i] = element.getClasspathEntry();
            ++i;
        }
        return result;
    }

    public CPListElement getCPElement(CPListElement element) {
        return ClasspathModifier.getClasspathEntry(this.fCPListElements, element);
    }

    public List getCPListElements() {
        return this.fCPListElements;
    }

    public IPath getDefaultOutputLocation() {
        return this.fDefaultOutputLocation;
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public int indexOf(CPListElement element) {
        return this.fCPListElements.indexOf(element);
    }

    public void setDefaultOutputLocation(IPath path) {
        this.fDefaultOutputLocation = path;
    }
}

