/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.render.Pie;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

public final class PieRenderer {
    static final int UNKNOWN = 0;
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    private static final int LOWER = 1;
    private static final int UPPER = 2;
    private static final double LEADER_TICK_MIN_SIZE = 10.0;
    private static final int LESS = -1;
    private static final int MORE = 1;
    private static final int EQUAL = 0;
    private final Position lpDataPoint;
    private final Position lpSeriesTitle;
    private transient double dLeaderLength;
    private final LeaderLineStyle lls;
    private final transient double dThickness;
    private transient double dExplosion = 0.0;
    private transient String sExplosionExpression = null;
    private final Pie pie;
    private final PieSeries ps;
    private final List<PieSlice> pieSliceList = new ArrayList<PieSlice>();
    private final List backCurvedPlanes = new ArrayList();
    private final List frontCurvedPlanes = new ArrayList();
    private final List flatPlanes = new ArrayList();
    private final Palette pa;
    private final Label laSeriesTitle;
    private final LineAttributes liaLL;
    private final LineAttributes liaEdges;
    private transient IDisplayServer xs = null;
    private transient IDeviceRenderer idr = null;
    private transient Bounds boTitleContainer = null;
    private transient Bounds boSeriesNoTitle = null;
    private transient Insets insCA = null;
    private transient Bounds boSetDuringComputation = null;
    private final boolean bPaletteByCategory;
    private transient boolean bBoundsAdjustedForInsets = false;
    private transient boolean bMinSliceDefined = false;
    private transient double dMinSlice = 0.0;
    private transient double dAbsoluteMinSlice = 0.0;
    private transient boolean bPercentageMinSlice = false;
    private transient boolean bMinSliceApplied = false;
    private transient int orginalSliceCount = 0;
    private transient double ratio = 0.0;
    private transient double rotation = 0.0;
    private final IChartComputation cComp;
    private final double MIN_DOUBLE = 1.0E-10;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");

    PieRenderer(ChartWithoutAxes cwoa, Pie pie, DataPointHints[] dpha, double[] da, Palette pa) throws ChartException {
        this.pa = pa;
        this.pie = pie;
        this.cComp = (IChartComputation)pie.getRunTimeContext().getState(RunTimeContext.StateKey.CHART_COMPUTATION_KEY);
        this.ps = (PieSeries)pie.getSeries();
        this.sExplosionExpression = this.ps.getExplosionExpression();
        this.dExplosion = (double)this.ps.getExplosion() * pie.getDeviceScale();
        this.dThickness = (cwoa.getDimension() == ChartDimension.TWO_DIMENSIONAL_LITERAL ? 0.0 : cwoa.getSeriesThickness()) * pie.getDeviceScale();
        this.ratio = this.ps.isSetRatio() ? this.ps.getRatio() : 1.0;
        this.rotation = this.ps.isSetRotation() ? this.ps.getRotation() : 0.0;
        this.liaLL = this.ps.getLeaderLineAttributes();
        this.dLeaderLength = this.ps.getLeaderLineAttributes().isVisible() ? this.ps.getLeaderLineLength() * pie.getDeviceScale() : 0.0;
        this.liaEdges = goFactory.createLineAttributes(goFactory.BLACK(), LineStyle.SOLID_LITERAL, 1);
        this.bPaletteByCategory = cwoa.getLegend().getItemType() == LegendItemType.CATEGORIES_LITERAL;
        this.lpDataPoint = this.ps.getLabelPosition();
        this.lpSeriesTitle = this.ps.getTitlePosition();
        this.laSeriesTitle = goFactory.copyOf(this.ps.getTitle());
        this.laSeriesTitle.getCaption().setValue(pie.getRunTimeContext().externalizedMessage(String.valueOf(this.ps.getSeriesIdentifier())));
        this.laSeriesTitle.getCaption().getFont().setAlignment(pie.switchTextAlignment(this.laSeriesTitle.getCaption().getFont().getAlignment()));
        AbstractScriptHandler sh = pie.getRunTimeContext().getScriptHandler();
        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawSeriesTitle", (Object)this.ps, (Object)this.laSeriesTitle, (Object)pie.getRunTimeContext().getScriptContext());
        pie.getRunTimeContext().notifyStructureChange("beforeDrawSeriesTitle", (Object)this.laSeriesTitle);
        this.lls = this.ps.getLeaderLineStyle();
        this.bMinSliceDefined = cwoa.isSetMinSlice();
        this.dMinSlice = cwoa.getMinSlice();
        this.bPercentageMinSlice = cwoa.isMinSlicePercent();
        double dTotal = 0.0;
        this.orginalSliceCount = da.length;
        int i = 0;
        while (i < da.length) {
            if (da[i] < 0.0) {
                dTotal -= da[i];
            } else if (!Double.isNaN(da[i])) {
                dTotal += da[i];
            }
            ++i;
        }
        if (this.bMinSliceDefined) {
            this.dAbsoluteMinSlice = this.bPercentageMinSlice ? this.dMinSlice * dTotal / 100.0 : this.dMinSlice;
            double residualPos = 0.0;
            double residualNeg = 0.0;
            DataPointHints dphPos = null;
            DataPointHints dphNeg = null;
            int i2 = 0;
            while (i2 < da.length) {
                if (!Double.isNaN(da[i2])) {
                    if (Math.abs(da[i2]) >= Math.abs(this.dAbsoluteMinSlice)) {
                        this.pieSliceList.add(new PieSlice(da[i2], dpha[i2], i2));
                    } else if (da[i2] >= 0.0) {
                        residualPos += da[i2];
                        if (dphPos == null) {
                            dphPos = dpha[i2].getVirtualCopy();
                        } else {
                            dphPos.accumulate(dpha[i2].getBaseValue(), dpha[i2].getOrthogonalValue(), dpha[i2].getSeriesValue(), dpha[i2].getPercentileOrthogonalValue());
                        }
                    } else {
                        residualNeg += da[i2];
                        if (dphNeg == null) {
                            dphNeg = dpha[i2].getVirtualCopy();
                        } else {
                            dphNeg.accumulate(dpha[i2].getBaseValue(), dpha[i2].getOrthogonalValue(), dpha[i2].getSeriesValue(), dpha[i2].getPercentileOrthogonalValue());
                        }
                    }
                }
                ++i2;
            }
            String extSliceLabel = pie.getRunTimeContext().externalizedMessage(cwoa.getMinSliceLabel());
            if (dphPos != null) {
                dphPos.setBaseValue((Object)extSliceLabel);
                dphPos.setIndex(this.orginalSliceCount);
                this.pieSliceList.add(new PieSlice(residualPos, dphPos, this.orginalSliceCount));
                this.bMinSliceApplied = true;
            }
            if (dphNeg != null) {
                dphNeg.setBaseValue((Object)extSliceLabel);
                dphNeg.setIndex(this.orginalSliceCount);
                this.pieSliceList.add(new PieSlice(residualNeg, dphNeg, this.orginalSliceCount));
                this.bMinSliceApplied = true;
            }
        } else {
            i = 0;
            while (i < da.length) {
                if (!Double.isNaN(da[i])) {
                    this.pieSliceList.add(new PieSlice(da[i], dpha[i], i));
                }
                ++i;
            }
        }
        double startAngle = this.rotation;
        double originalStartAngle = this.rotation;
        if (dTotal == 0.0) {
            dTotal = 1.0;
        }
        if (this.ps.isClockwise()) {
            Collections.reverse(this.pieSliceList);
        }
        PieSlice slice2 = null;
        double totalAngle = 0.0;
        for (PieSlice slice2 : this.pieSliceList) {
            double length = Math.abs(slice2.getPrimitiveValue()) / dTotal * 360.0;
            double percentage = slice2.getPrimitiveValue() / dTotal * 100.0;
            slice2.setStartAngle(startAngle);
            slice2.setOriginalStartAngle(originalStartAngle);
            slice2.setSliceLength(length);
            slice2.setPercentage(percentage);
            startAngle += length + 1.0E-10;
            originalStartAngle += length;
            startAngle = this.wrapAngle(startAngle);
            originalStartAngle = this.wrapAngle(originalStartAngle);
            totalAngle += length;
        }
        if (totalAngle > 0.0 && 360.0 - totalAngle > 0.001) {
            slice2.setSliceLength(360.0 - slice2.getStartAngle());
        }
        this.initExploded();
    }

    private double wrapAngle(double angle) {
        return angle > 360.0 ? angle - 360.0 : angle;
    }

    private final void renderDataPoints(IDeviceRenderer idr) throws ChartException {
        AbstractScriptHandler sh = this.pie.getRunTimeContext().getScriptHandler();
        int iTextRenderType = 3;
        if (this.lpDataPoint.getValue() == 5) {
            for (PieSlice slice : this.pieSliceList) {
                if (slice.getLabel().getShadowColor() == null) continue;
                slice.renderLabel(idr, 1);
            }
            iTextRenderType = 2;
        }
        for (PieSlice slice : this.pieSliceList) {
            if (slice.getLabel().isVisible()) {
                slice.renderLabel(idr, iTextRenderType);
            }
            ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)slice.getDataPointHints(), (Object)slice.getLabel(), (Object)this.pie.getRunTimeContext().getScriptContext());
            this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)slice.getLabel());
        }
    }

    private final void computeLabelBounds(Bounds bo, boolean isOutside) throws ChartException {
        for (PieSlice slice : this.pieSliceList) {
            slice.setBounds(bo);
            if (isOutside) {
                slice.computeLabelBoundOutside(this.lls, this.dLeaderLength, null);
                continue;
            }
            slice.computeLabelBoundInside();
        }
    }

    private void resolveOverlap() {
        new LabelOverlapResover(this.lls, this.pieSliceList, this.boSeriesNoTitle, this.dLeaderLength).resolve();
    }

    private final Insets adjust(Bounds bo, Bounds boAdjusted, Insets ins) throws ChartException {
        this.computeLabelBounds(boAdjusted, true);
        ins.set(0.0, 0.0, 0.0, 0.0);
        double dDelta = 0.0;
        for (PieSlice slice : this.pieSliceList) {
            BoundingBox bb = slice.getLabelBounding();
            if (bb.getLeft() < bo.getLeft()) {
                dDelta = bo.getLeft() - bb.getLeft();
                if (ins.getLeft() < dDelta) {
                    ins.setLeft(dDelta);
                }
            }
            if (bb.getTop() < bo.getTop()) {
                dDelta = bo.getTop() - bb.getTop();
                if (ins.getTop() < dDelta) {
                    ins.setTop(dDelta);
                }
            }
            if (bb.getLeft() + bb.getWidth() > bo.getLeft() + bo.getWidth()) {
                dDelta = bb.getLeft() + bb.getWidth() - bo.getLeft() - bo.getWidth();
                if (ins.getRight() < dDelta) {
                    ins.setRight(dDelta);
                }
            }
            if (!(bb.getTop() + bb.getHeight() > bo.getTop() + bo.getHeight())) continue;
            dDelta = bb.getTop() + bb.getHeight() - bo.getTop() - bo.getHeight();
            if (!(ins.getBottom() < dDelta)) continue;
            ins.setBottom(dDelta);
        }
        return ins;
    }

    final void computeInsets(Bounds bo) throws ChartException {
        this.boSetDuringComputation = goFactory.copyOf(bo);
        this.xs = this.pie.getXServer();
        this.boTitleContainer = null;
        if (this.laSeriesTitle.isVisible()) {
            if (this.lpSeriesTitle == null) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 13, "exception.unspecified.visible.series.title", Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()));
            }
            BoundingBox bb = this.cComp.computeBox(this.xs, 8, this.laSeriesTitle, 0.0, 0.0);
            this.boTitleContainer = goFactory.createBounds(0.0, 0.0, 0.0, 0.0);
            switch (this.lpSeriesTitle.getValue()) {
                case 1: {
                    bo.setHeight(bo.getHeight() - bb.getHeight());
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop() + bo.getHeight(), bo.getWidth(), bb.getHeight());
                    break;
                }
                case 0: {
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop(), bo.getWidth(), bb.getHeight());
                    bo.setTop(bo.getTop() + bb.getHeight());
                    bo.setHeight(bo.getHeight() - bb.getHeight());
                    break;
                }
                case 2: {
                    bo.setWidth(bo.getWidth() - bb.getWidth());
                    this.boTitleContainer.set(bo.getLeft(), bo.getTop(), bb.getWidth(), bo.getHeight());
                    bo.setLeft(bo.getLeft() + bb.getWidth());
                    break;
                }
                case 3: {
                    bo.setWidth(bo.getWidth() - bb.getWidth());
                    this.boTitleContainer.set(bo.getLeft() + bo.getWidth(), bo.getTop(), bb.getWidth(), bo.getHeight());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Messages.getString("exception.illegal.pie.series.title.position", new Object[]{this.lpSeriesTitle}, this.pie.getRunTimeContext().getULocale()));
                }
            }
        }
        this.boSeriesNoTitle = goFactory.copyOf(bo);
        ChartWithoutAxes cwa = (ChartWithoutAxes)this.pie.getModel();
        if (cwa.isSetCoverage()) {
            double rate = cwa.getCoverage();
            double ww = 0.5 * (1.0 - rate) * bo.getWidth();
            double hh = 0.5 * (1.0 - rate) * bo.getHeight();
            this.insCA = goFactory.createInsets(hh, ww, hh, ww);
        } else {
            if (this.lpDataPoint == Position.OUTSIDE_LITERAL) {
                if (this.ps.getLabel().isVisible()) {
                    Bounds boAdjusted = goFactory.copyOf(bo);
                    Insets insTrim = goFactory.createInsets(0.0, 0.0, 0.0, 0.0);
                    do {
                        this.adjust(bo, boAdjusted, insTrim);
                        boAdjusted.adjust(insTrim);
                    } while (!insTrim.areLessThan(0.5) && boAdjusted.getWidth() > 0.0 && boAdjusted.getHeight() > 0.0);
                    bo = boAdjusted;
                }
            } else if (this.lpDataPoint == Position.INSIDE_LITERAL) {
                if (this.ps.getLabel().isVisible()) {
                    this.computeLabelBounds(bo, false);
                }
            } else {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.pie.getRunTimeContext().getULocale()).getString("exception.invalid.datapoint.position.pie"), this.lpDataPoint));
            }
            this.insCA = goFactory.createInsets(bo.getTop() - this.boSetDuringComputation.getTop(), bo.getLeft() - this.boSetDuringComputation.getLeft(), this.boSetDuringComputation.getTop() + this.boSetDuringComputation.getHeight() - (bo.getTop() + bo.getHeight()), this.boSetDuringComputation.getLeft() + this.boSetDuringComputation.getWidth() - (bo.getLeft() + bo.getWidth()));
        }
        this.bBoundsAdjustedForInsets = false;
    }

    final Insets getFittingInsets() {
        return this.insCA;
    }

    final void setFittingInsets(Insets insCA) throws ChartException {
        this.insCA = insCA;
        if (!this.bBoundsAdjustedForInsets) {
            this.bBoundsAdjustedForInsets = true;
            this.boSetDuringComputation.adjust(insCA);
        }
        if (this.lpDataPoint == Position.OUTSIDE_LITERAL) {
            if (this.ps.getLabel().isVisible()) {
                this.computeLabelBounds(this.boSetDuringComputation, true);
            }
        } else if (this.lpDataPoint == Position.INSIDE_LITERAL && this.ps.getLabel().isVisible()) {
            this.computeLabelBounds(this.boSetDuringComputation, false);
        }
    }

    public final void render(IDeviceRenderer idr, Bounds bo) throws ChartException {
        bo.adjust(this.insCA);
        this.xs = idr.getDisplayServer();
        this.idr = idr;
        AbstractScriptHandler sh = this.pie.getRunTimeContext().getScriptHandler();
        double w = bo.getWidth() / 2.0 - this.dExplosion;
        double h = bo.getHeight() / 2.0 - this.dExplosion - this.dThickness / 2.0;
        double xc = bo.getLeft() + bo.getWidth() / 2.0;
        double yc = bo.getTop() + bo.getHeight() / 2.0;
        if (this.ratio > 0.0 && w > 0.0) {
            if (h / w > this.ratio) {
                h = w * this.ratio;
            } else if (h / w < this.ratio) {
                w = h / this.ratio;
            }
        }
        if (w > 0.0 && h > 0.0) {
            Fill fPaletteEntry;
            if (this.dThickness > 0.0) {
                for (PieSlice slice : this.pieSliceList) {
                    fPaletteEntry = null;
                    fPaletteEntry = this.bPaletteByCategory ? this.getPaletteColor(slice.getCategoryIndex(), slice.getDataPointHints()) : this.getPaletteColor(this.pie.getSeriesDefinition().getRunTimeSeries().indexOf(this.ps), slice.getDataPointHints());
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawElement", (Object)slice.getDataPointHints(), (Object)fPaletteEntry);
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)slice.getDataPointHints(), (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                    this.pie.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)slice.getDataPointHints());
                    this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)slice.getDataPointHints());
                    slice.render(PieRenderer.goFactory.createLocation(xc, yc), PieRenderer.goFactory.createLocation(0.0, this.dThickness), SizeImpl.create((double)w, (double)h), fPaletteEntry, 1);
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawElement", (Object)slice.getDataPointHints(), (Object)fPaletteEntry);
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPoint", (Object)slice.getDataPointHints(), (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                    this.pie.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)slice.getDataPointHints());
                    this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)slice.getDataPointHints());
                }
                this.sortAndRenderPlanes();
            }
            for (PieSlice slice : this.pieSliceList) {
                fPaletteEntry = null;
                fPaletteEntry = this.bPaletteByCategory ? this.getPaletteColor(slice.getCategoryIndex(), slice.getDataPointHints()) : this.getPaletteColor(this.pie.getSeriesDefinition().getRunTimeSeries().indexOf(this.ps), slice.getDataPointHints());
                ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)slice.getDataPointHints(), (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)slice.getDataPointHints());
                slice.render(PieRenderer.goFactory.createLocation(xc, yc), PieRenderer.goFactory.createLocation(0.0, this.dThickness), SizeImpl.create((double)w, (double)h), fPaletteEntry, 2);
                ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPoint", (Object)slice.getDataPointHints(), (Object)fPaletteEntry, (Object)this.pie.getRunTimeContext().getScriptContext());
                this.pie.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)slice.getDataPointHints());
            }
        }
        if (this.laSeriesTitle.isVisible()) {
            TextRenderEvent tre = (TextRenderEvent)((EventObjectCache)idr).getEventObject((Object)WrappedStructureSource.createSeriesTitle((Series)this.ps, (Label)this.laSeriesTitle), TextRenderEvent.class);
            tre.setLabel(this.laSeriesTitle);
            tre.setBlockBounds(this.boTitleContainer);
            tre.setBlockAlignment(null);
            tre.setAction(3);
            idr.drawText(tre);
        }
        ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawSeriesTitle", (Object)this.ps, (Object)this.laSeriesTitle, (Object)this.pie.getRunTimeContext().getScriptContext());
        this.pie.getRunTimeContext().notifyStructureChange("afterDrawSeriesTitle", (Object)this.laSeriesTitle);
        if (this.ps.getLabel().isVisible()) {
            try {
                if (this.ps.getLabel().getCaption().getFont().getRotation() == 0.0 && this.lpDataPoint == Position.OUTSIDE_LITERAL) {
                    this.resolveOverlap();
                }
                this.renderDataPoints(idr);
            }
            catch (ChartException rex) {
                logger.log((Exception)((Object)rex));
                throw rex;
            }
        }
    }

    private final void deferCurvedPlane(List list, double angle, AreaRenderEvent areBentOrTwistedCurve, double dX1, double dX2) {
        double newAngle = this.convertAngleForRenderingOrder(angle);
        list.add(new CurvedPlane(newAngle, areBentOrTwistedCurve));
    }

    private final void deferCurvedOutline(List list, double angle, AreaRenderEvent areBentOrTwistedCurve) {
        double newAngle = this.convertAngleForRenderingOrder(angle);
        list.add(new CurvedPlane(newAngle, areBentOrTwistedCurve));
    }

    private final void deferFlatPlane(List planesList, double angle, double[] daXPoints, double[] daYPoints, Fill cd, DataPointHints dph) {
        double newAngle = this.convertAngleForRenderingOrder(angle);
        planesList.add(new FlatPlane(newAngle, daXPoints, daYPoints, cd, dph));
    }

    private double convertAngleForRenderingOrder(double angle) {
        double newAngle = angle;
        newAngle = (newAngle = this.wrapAngle(newAngle)) < 180.0 ? Math.abs(newAngle - 90.0) : 90.0 - Math.abs(newAngle - 270.0) + 180.0;
        return newAngle;
    }

    private final void sortAndRenderPlanes() throws ChartException {
        this.renderPlanes(this.backCurvedPlanes);
        this.backCurvedPlanes.clear();
        this.renderPlanes(this.flatPlanes);
        this.flatPlanes.clear();
        this.renderPlanes(this.frontCurvedPlanes);
        this.frontCurvedPlanes.clear();
    }

    private void renderPlanes(List planesList) throws ChartException {
        Object[] planes = planesList.toArray();
        Arrays.sort(planes, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                double angleA = 0.0;
                double angleB = 0.0;
                if (arg0 instanceof FlatPlane) {
                    angleA = ((FlatPlane)arg0).getAngle();
                } else if (arg0 instanceof CurvedPlane) {
                    angleA = ((CurvedPlane)arg0).getAngle();
                }
                if (arg1 instanceof FlatPlane) {
                    angleB = ((FlatPlane)arg1).getAngle();
                } else if (arg0 instanceof CurvedPlane) {
                    angleB = ((CurvedPlane)arg1).getAngle();
                }
                return Double.compare(angleA, angleB);
            }
        });
        int i = 0;
        while (i < planes.length) {
            IDrawable id = (IDrawable)planes[i];
            id.draw();
            ++i;
        }
    }

    private final ColorDefinition getSliceOutline(Fill f) {
        if (this.ps.getSliceOutline() == null) {
            if (f instanceof ColorDefinition) {
                return goFactory.darker((ColorDefinition)f);
            }
            return goFactory.TRANSPARENT();
        }
        return goFactory.copyOf(this.ps.getSliceOutline());
    }

    private void initExploded() {
        if (this.sExplosionExpression == null) {
            return;
        }
        for (PieSlice slice : this.pieSliceList) {
            try {
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("categoryData", slice.getDataPointHints().getBaseValue());
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("valueData", slice.getDataPointHints().getOrthogonalValue());
                this.pie.getRunTimeContext().getScriptHandler().registerVariable("valueSeriesName", slice.getDataPointHints().getSeriesValue());
                Object obj = this.pie.getRunTimeContext().getScriptHandler().evaluate(this.sExplosionExpression);
                if (obj instanceof Boolean) {
                    slice.setExploded((Boolean)obj);
                }
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("categoryData");
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("valueData");
                this.pie.getRunTimeContext().getScriptHandler().unregisterVariable("valueSeriesName");
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
            }
        }
    }

    protected Gradient getDepthGradient(Fill cd) {
        if (cd instanceof Gradient) {
            return goFactory.createGradient(goFactory.darker(((Gradient)cd).getStartColor()), goFactory.darker(((Gradient)cd).getEndColor()), ((Gradient)cd).getDirection(), ((Gradient)cd).isCyclic());
        }
        return goFactory.createGradient(cd instanceof ColorDefinition ? goFactory.darker((ColorDefinition)cd) : goFactory.GREY(), goFactory.BLACK(), 0.0, true);
    }

    protected Gradient getDepthGradient(Fill cd, double startAngle, double endAngle) {
        if (cd instanceof Gradient) {
            return goFactory.createGradient(goFactory.darker(((Gradient)cd).getStartColor()), goFactory.darker(((Gradient)cd).getEndColor()), ((Gradient)cd).getDirection(), ((Gradient)cd).isCyclic());
        }
        ColorDefinition standCD = cd instanceof ColorDefinition ? goFactory.darker((ColorDefinition)cd) : goFactory.GREY();
        float[] hsbvals = Color.RGBtoHSB(standCD.getRed(), standCD.getGreen(), standCD.getBlue(), null);
        float[] startHSB = new float[]{hsbvals[0], hsbvals[1], hsbvals[2]};
        float[] endHSB = new float[]{hsbvals[0], hsbvals[1], hsbvals[2]};
        float brightAlpha = 0.0055555557f;
        startHSB[2] = startAngle < 180.0 ? (float)(startAngle * (double)brightAlpha) : (float)(1.0 - (startAngle - 180.0) * (double)brightAlpha);
        endHSB[2] = endAngle < 180.0 ? (float)(endAngle * (double)brightAlpha) : (float)(1.0 - (endAngle - 180.0) * (double)brightAlpha);
        Color startColor = new Color(Color.HSBtoRGB(startHSB[0], startHSB[1], startHSB[2]));
        Color endColor = new Color(Color.HSBtoRGB(endHSB[0], endHSB[1], endHSB[2]));
        ColorDefinition startCD = goFactory.copyOf(standCD);
        startCD.set(startColor.getRed(), startColor.getGreen(), startColor.getBlue());
        ColorDefinition endCD = goFactory.copyOf(standCD);
        endCD.set(endColor.getRed(), endColor.getGreen(), endColor.getBlue());
        if (endAngle <= 180.0) {
            return goFactory.createGradient(endCD, startCD, 0.0, true);
        }
        return goFactory.createGradient(startCD, endCD, 0.0, true);
    }

    private final void registerCurvedSurface(Bounds topBound, Bounds bottomBound, double dStartAngle, double dAngleExtent, LineRenderEvent lreStartB2T, LineRenderEvent lreEndB2T, Fill cd, DataPointHints dph, Location loC, Location loCTop, Size sz) {
        double[] anglePoints = new double[4];
        double endAngle = dStartAngle + dAngleExtent;
        int i = 0;
        anglePoints[i++] = dStartAngle;
        if (endAngle > 180.0 && dStartAngle < 180.0) {
            anglePoints[i++] = 180.0;
        }
        if (endAngle > 360.0 && dStartAngle < 360.0) {
            anglePoints[i++] = 360.0;
            if (endAngle > 540.0) {
                anglePoints[i++] = 540.0;
            }
        }
        anglePoints[i] = endAngle;
        if (i == 1) {
            ArcRenderEvent arcRE1 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            ArcRenderEvent arcRE2 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            arcRE1.setBounds(topBound);
            arcRE1.setStartAngle(dStartAngle);
            arcRE1.setAngleExtent(dAngleExtent);
            arcRE1.setStyle(1);
            arcRE2.setBounds(bottomBound);
            arcRE2.setStartAngle(dStartAngle + dAngleExtent);
            arcRE2.setAngleExtent(-dAngleExtent);
            arcRE2.setStyle(1);
            AreaRenderEvent areRE = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            areRE.add((PrimitiveRenderEvent)lreStartB2T);
            areRE.add((PrimitiveRenderEvent)arcRE1);
            areRE.add((PrimitiveRenderEvent)lreEndB2T);
            areRE.add((PrimitiveRenderEvent)arcRE2);
            areRE.setOutline(goFactory.createLineAttributes(this.getSliceOutline(cd), LineStyle.SOLID_LITERAL, 1));
            areRE.setBackground((Fill)this.getDepthGradient(cd, dStartAngle, dStartAngle + dAngleExtent));
            this.deferCurvedPlane(this.selectPlanesList(dStartAngle), dStartAngle, areRE, lreStartB2T.getStart().getX(), lreEndB2T.getStart().getX());
        } else {
            Stack<ArcRenderEvent> lineStack = new Stack<ArcRenderEvent>();
            AreaRenderEvent areLine = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
            areLine.setOutline(goFactory.createLineAttributes(this.getSliceOutline(cd), LineStyle.SOLID_LITERAL, 1));
            areLine.setBackground(null);
            int j = 0;
            while (j < i) {
                double startAngle = anglePoints[j] + 1.0E-10;
                double angleExtent = anglePoints[j + 1] - anglePoints[j];
                startAngle = this.wrapAngle(startAngle);
                Object[] edgeLines = this.getEdgeLines(startAngle, angleExtent, loC, loCTop, sz, dph);
                ArcRenderEvent arcRE1 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
                ArcRenderEvent arcRE2 = new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
                arcRE1.setBounds(topBound);
                arcRE1.setStartAngle(startAngle);
                arcRE1.setAngleExtent(angleExtent);
                arcRE1.setStyle(1);
                arcRE2.setBounds(bottomBound);
                arcRE2.setStartAngle(this.wrapAngle(anglePoints[j + 1]));
                arcRE2.setAngleExtent(-angleExtent);
                arcRE2.setStyle(1);
                AreaRenderEvent are = new AreaRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
                are.add((PrimitiveRenderEvent)((LineRenderEvent)edgeLines[0]));
                are.add((PrimitiveRenderEvent)arcRE1);
                are.add((PrimitiveRenderEvent)((LineRenderEvent)edgeLines[1]));
                are.add((PrimitiveRenderEvent)arcRE2);
                are.setOutline(null);
                are.setBackground((Fill)this.getDepthGradient(cd, this.wrapAngle(anglePoints[j]), this.wrapAngle(anglePoints[j + 1])));
                this.deferCurvedPlane(this.selectPlanesList(startAngle), startAngle, are, ((LineRenderEvent)edgeLines[0]).getStart().getX(), ((LineRenderEvent)edgeLines[1]).getStart().getX());
                if (j == 0) {
                    areLine.add((PrimitiveRenderEvent)((LineRenderEvent)edgeLines[0]));
                    areLine.add((PrimitiveRenderEvent)arcRE1);
                    lineStack.push(arcRE2);
                } else if (j == i - 1) {
                    areLine.add((PrimitiveRenderEvent)arcRE1);
                    areLine.add((PrimitiveRenderEvent)((LineRenderEvent)edgeLines[1]));
                    areLine.add((PrimitiveRenderEvent)arcRE2);
                } else {
                    areLine.add((PrimitiveRenderEvent)arcRE1);
                    lineStack.push(arcRE2);
                }
                ++j;
            }
            while (!lineStack.empty()) {
                areLine.add((PrimitiveRenderEvent)lineStack.pop());
            }
            double mid = dStartAngle + dAngleExtent / 2.0;
            mid = this.wrapAngle(mid);
            this.deferCurvedOutline(this.selectPlanesList(mid), dStartAngle, areLine);
        }
    }

    private List selectPlanesList(double startAngle) {
        if (startAngle < 180.0) {
            return this.backCurvedPlanes;
        }
        return this.frontCurvedPlanes;
    }

    private final Object[] getEdgeLines(double startAngle, double extentAngle, Location loC, Location loCTop, Size sz, DataPointHints dph) {
        double dAngleInRadians = Math.toRadians(startAngle);
        double dSineThetaStart = Math.sin(dAngleInRadians);
        double dCosThetaStart = Math.cos(dAngleInRadians);
        dAngleInRadians = Math.toRadians(startAngle + extentAngle);
        double dSineThetaEnd = Math.sin(dAngleInRadians);
        double dCosThetaEnd = Math.cos(dAngleInRadians);
        double xE = sz.getWidth() * dCosThetaEnd;
        double yE = sz.getHeight() * dSineThetaEnd;
        double xS = sz.getWidth() * dCosThetaStart;
        double yS = sz.getHeight() * dSineThetaStart;
        LineRenderEvent lreStartB2T = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
        lreStartB2T.setStart(goFactory.createLocation(loC.getX() + xS, loC.getY() - yS));
        lreStartB2T.setEnd(goFactory.createLocation(loCTop.getX() + xS, loCTop.getY() - yS));
        LineRenderEvent lreEndT2B = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.ps, (DataPointHints)dph));
        lreEndT2B.setStart(goFactory.createLocation(loCTop.getX() + xE, loCTop.getY() - yE));
        lreEndT2B.setEnd(goFactory.createLocation(loC.getX() + xE, loC.getY() - yE));
        return new Object[]{lreStartB2T, lreEndT2B};
    }

    private final Fill getPaletteColor(int iIndex, DataPointHints dph) {
        Fill fiClone = FillUtil.getPaletteFill((EList)this.pa.getEntries(), (int)iIndex);
        this.pie.updateTranslucency(fiClone, (Series)this.ps);
        if (dph != null && dph.getOrthogonalValue() instanceof Double) {
            fiClone = FillUtil.convertFill((Fill)fiClone, (double)((Double)dph.getOrthogonalValue()), null);
        }
        return fiClone;
    }

    private final class CurvedPlane
    implements Comparable,
    IDrawable {
        private final AreaRenderEvent _are;
        private final Bounds _bo;
        private final double _angle;

        CurvedPlane(double angle, AreaRenderEvent are) {
            this._are = are;
            this._bo = are.getBounds();
            this._angle = angle;
        }

        public final Bounds getBounds() {
            return this._bo;
        }

        public final int compareTo(Object o) {
            CurvedPlane cp1 = this;
            if (o instanceof CurvedPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                CurvedPlane cp2 = (CurvedPlane)o;
                double dMinY1 = cp1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = cp2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : (dDiff > 0.0 ? 1 : 0);
                }
                double dMaxY1 = cp1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = cp2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = cp1.getMinX();
                dDiff = dMinX1 - (dMinX2 = cp2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = cp1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = cp2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            if (o instanceof FlatPlane) {
                FlatPlane pi2 = (FlatPlane)o;
                return pi2.compareTo(cp1) * -1;
            }
            return 0;
        }

        public final void draw() throws ChartException {
            PieRenderer.this.idr.fillArea(this._are);
            PieRenderer.this.idr.drawArea(this._are);
        }

        private final double getMinY() {
            return this._bo.getTop();
        }

        private final double getMinX() {
            return this._bo.getLeft();
        }

        private final double getMaxX() {
            return this._bo.getLeft() + this._bo.getWidth();
        }

        private final double getMaxY() {
            return this._bo.getTop() + this._bo.getHeight();
        }

        public double getAngle() {
            return this._angle;
        }
    }

    private final class FlatPlane
    implements Comparable,
    IDrawable {
        private final double[] _daXPoints;
        private final double[] _daYPoints;
        private final Fill _cd;
        private final Bounds _bo;
        private final DataPointHints _dph;
        private final double _angle;

        FlatPlane(double angle, double[] daXPoints, double[] daYPoints, Fill cd, DataPointHints dph) {
            this._angle = angle;
            this._daXPoints = daXPoints;
            this._daYPoints = daYPoints;
            this._dph = dph;
            int n = this._daXPoints.length;
            double dMinX = 0.0;
            double dMinY = 0.0;
            double dMaxX = 0.0;
            double dMaxY = 0.0;
            int i = 0;
            while (i < n) {
                if (i == 0) {
                    dMinX = this._daXPoints[i];
                    dMinY = this._daYPoints[i];
                    dMaxX = dMinX;
                    dMaxY = dMinY;
                } else {
                    if (dMinX > this._daXPoints[i]) {
                        dMinX = this._daXPoints[i];
                    }
                    if (dMinY > this._daYPoints[i]) {
                        dMinY = this._daYPoints[i];
                    }
                    if (dMaxX < this._daXPoints[i]) {
                        dMaxX = this._daXPoints[i];
                    }
                    if (dMaxY < this._daYPoints[i]) {
                        dMaxY = this._daYPoints[i];
                    }
                }
                ++i;
            }
            this._bo = goFactory.createBounds(dMinX, dMinY, dMaxX - dMinX, dMaxY - dMinY);
            this._cd = cd;
            int nPoints = this._daXPoints.length;
            int[] iaX = new int[nPoints];
            int[] iaY = new int[nPoints];
            int i2 = 0;
            while (i2 < nPoints) {
                iaX[i2] = (int)daXPoints[i2];
                iaY[i2] = (int)daYPoints[i2];
                ++i2;
            }
        }

        public Bounds getBounds() {
            return this._bo;
        }

        public final void draw() throws ChartException {
            PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)PieRenderer.this.idr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this._dph), PolygonRenderEvent.class);
            pre.setPoints(this.toLocationArray());
            PieRenderer.this.liaEdges.setColor(PieRenderer.this.getSliceOutline(this._cd));
            pre.setOutline(PieRenderer.this.liaEdges);
            pre.setBackground((Fill)PieRenderer.this.getDepthGradient(this._cd));
            PieRenderer.this.idr.fillPolygon(pre);
            PieRenderer.this.idr.drawPolygon(pre);
        }

        public final int compareTo(Object o) {
            FlatPlane pi1 = this;
            if (o instanceof FlatPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                FlatPlane pi2 = (FlatPlane)o;
                double dMinY1 = pi1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = pi2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : (dDiff > 0.0 ? 1 : 0);
                }
                double dMaxY1 = pi1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = pi2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = pi1.getMinX();
                dDiff = dMinX1 - (dMinX2 = pi2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = pi1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = pi2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            if (o instanceof CurvedPlane) {
                double dMaxX2;
                double dMinX2;
                double dMaxY2;
                double dMinY2;
                CurvedPlane pi2 = (CurvedPlane)o;
                double dMinY1 = pi1.getMinY();
                double dDiff = dMinY1 - (dMinY2 = pi2.getMinY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxY1 = pi1.getMaxY();
                dDiff = dMaxY1 - (dMaxY2 = pi2.getMaxY());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMinX1 = pi1.getMinX();
                dDiff = dMinX1 - (dMinX2 = pi2.getMinX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                double dMaxX1 = pi1.getMaxX();
                dDiff = dMaxX1 - (dMaxX2 = pi2.getMaxX());
                if (!ChartUtil.mathEqual((double)dDiff, (double)0.0)) {
                    return dDiff < 0.0 ? -1 : 1;
                }
                return 0;
            }
            return 0;
        }

        private final double getMinY() {
            return this._bo.getTop();
        }

        private final double getMinX() {
            return this._bo.getLeft();
        }

        private final double getMaxX() {
            return this._bo.getLeft() + this._bo.getWidth();
        }

        private final double getMaxY() {
            return this._bo.getTop() + this._bo.getHeight();
        }

        private final Location[] toLocationArray() {
            int n = this._daXPoints.length;
            Location[] loa = new Location[n];
            int i = 0;
            while (i < n) {
                loa[i] = goFactory.createLocation(this._daXPoints[i], this._daYPoints[i]);
                ++i;
            }
            return loa;
        }

        public double getAngle() {
            return this._angle;
        }
    }

    private static interface IDrawable {
        public void draw() throws ChartException;

        public Bounds getBounds();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LabelOverlapResover {
        private static final double DMINDIST = 5.0;
        private static final double HSPACE = 3.0;
        private static final double VSPACE = 3.0;
        private final LeaderLineStyle lls;
        private double dLeadLineLen = 0.0;
        private final List<PieSlice> src_sliceList;
        private final double dLeftEdge;
        private final double dRightEdge;
        private final double dTopEdge;
        private final double dBottomEdge;
        private int idRightFirst;
        private int idLeftFirst;
        private int idRightLast;
        private int idLeftLast;

        public LabelOverlapResover(LeaderLineStyle lls, List<PieSlice> sliceList, Bounds bo, double dLeaderLength) {
            this.dLeftEdge = bo.getLeft();
            this.dRightEdge = bo.getLeft() + bo.getWidth();
            this.dTopEdge = bo.getTop();
            this.dBottomEdge = bo.getTop() + bo.getHeight();
            this.src_sliceList = sliceList;
            this.lls = lls;
            if (lls == LeaderLineStyle.FIXED_LENGTH_LITERAL) {
                this.dLeadLineLen = dLeaderLength;
            }
        }

        private void seekForIndexes() {
            int len = this.src_sliceList.size();
            if (len == 0) {
                return;
            }
            if (len == 1) {
                if (LabelOverlapResover.isLeftSideSlice(this.src_sliceList.get(0))) {
                    this.idLeftFirst = 0;
                    this.idLeftLast = 0;
                    this.idRightLast = -1;
                } else {
                    this.idRightFirst = 0;
                    this.idLeftLast = -1;
                }
                return;
            }
            boolean bCurrentIsLeft = LabelOverlapResover.isLeftSideSlice(this.src_sliceList.get(0));
            boolean bLastFound = false;
            boolean bFirstFound = false;
            int i = 1;
            while (i < len) {
                if (bCurrentIsLeft) {
                    if (!LabelOverlapResover.isLeftSideSlice(this.src_sliceList.get(i))) {
                        this.idLeftLast = i - 1;
                        this.idRightLast = i;
                        bCurrentIsLeft = false;
                        bLastFound = true;
                    }
                } else if (LabelOverlapResover.isLeftSideSlice(this.src_sliceList.get(i))) {
                    this.idRightFirst = i - 1;
                    this.idLeftFirst = i;
                    bCurrentIsLeft = true;
                    bFirstFound = true;
                }
                ++i;
            }
            if (!bFirstFound) {
                this.idLeftFirst = 0;
                this.idRightFirst = len - 1;
            }
            if (!bLastFound) {
                this.idRightLast = 0;
                this.idLeftLast = len - 1;
            }
        }

        private void processLeftSideLoop(LabelGroupList lList, int id0, int id1) {
            int i = id0;
            while (i <= id1) {
                PieSlice slice = this.src_sliceList.get(i);
                if (lList.isFull) break;
                SliceLabel sLabel = new SliceLabel(slice, false);
                lList.addSliceLabel(sLabel, false);
                ++i;
            }
        }

        private void processLeftSide(int len) {
            LabelGroupList lList = new LabelGroupList(false);
            if (this.idLeftLast < 0) {
                return;
            }
            if (this.idLeftLast >= this.idLeftFirst) {
                this.processLeftSideLoop(lList, this.idLeftFirst, this.idLeftLast);
            } else {
                this.processLeftSideLoop(lList, this.idLeftFirst, len - 1);
                this.processLeftSideLoop(lList, 0, this.idLeftLast);
            }
            LabelGroup lg = lList.head.lgNext;
            while (!lg.isTail()) {
                lg.updateSlices();
                lg = lg.lgNext;
            }
        }

        private void processRightSideLoop(LabelGroupList rList, int id0, int id1) {
            int i = id0;
            while (i >= id1) {
                PieSlice slice = this.src_sliceList.get(i);
                if (rList.isFull) break;
                SliceLabel sLabel = new SliceLabel(slice, true);
                rList.addSliceLabel(sLabel, true);
                --i;
            }
        }

        private void processRightSide(int len) {
            LabelGroupList rList = new LabelGroupList(true);
            if (this.idRightLast < 0) {
                return;
            }
            if (this.idRightLast <= this.idRightFirst) {
                this.processRightSideLoop(rList, this.idRightFirst, this.idRightLast);
            } else {
                this.processRightSideLoop(rList, this.idRightFirst, 0);
                this.processRightSideLoop(rList, len - 1, this.idRightLast);
            }
            LabelGroup lg = rList.head.lgNext;
            while (!lg.isTail()) {
                lg.updateSlices();
                lg = lg.lgNext;
            }
        }

        public void resolve() {
            int len = this.src_sliceList.size();
            if (len > 0) {
                this.seekForIndexes();
                this.processLeftSide(len);
                this.processRightSide(len);
            }
        }

        private static boolean isLeftSideSlice(PieSlice slice) {
            double angle = slice.getOriginalMidAngle() % 360.0;
            return angle >= 90.0 && angle < 270.0;
        }

        private LabelGroup createLabelGroup(SliceLabel sLabel, boolean bRight) {
            LabelGroup lg = bRight ? new RightLabelGroup(sLabel) : new LeftLabelGroup(sLabel);
            return lg;
        }

        private abstract class LabelGroup {
            private int type = 0;
            private LabelGroup lgLast = null;
            private LabelGroup lgNext = null;
            protected List<SliceLabel> label_list = new ArrayList<SliceLabel>();
            protected double xStart;
            protected double width = 0.0;
            protected double top;
            protected double height = 0.0;
            private boolean isFull = false;

            public LabelGroup(SliceLabel sLabel) {
                this.label_list.add(sLabel);
                this.top = sLabel.top_init;
                this.width = sLabel.width;
                this.xStart = sLabel.xStart;
                this.height = sLabel.height;
            }

            public LabelGroup(int type) {
                this.type = type;
            }

            public boolean isHead() {
                return this.type == 1;
            }

            public boolean isTail() {
                return this.type == 2;
            }

            private void recomputeHeight() {
                int len = this.label_list.size();
                this.height = this.label_list.get(0).height;
                int i = 1;
                while (i < len) {
                    this.height = Math.max(this.height, this.label_list.get(i).height);
                    ++i;
                }
            }

            private void removeLastLabel() {
                int len = this.label_list.size();
                if (len < 2) {
                    return;
                }
                SliceLabel sLabel = this.label_list.get(len - 1);
                this.label_list.remove(len - 1);
                this.width -= sLabel.width + 3.0;
                this.recomputeHeight();
                this.xStart = this.getXStartClosestToPie();
            }

            public void setTop(double top) {
                this.top = top;
            }

            public abstract double getXStartClosestToPie();

            public double computeMinTop() {
                SliceLabel sLabel;
                double dMinTop = LabelOverlapResover.this.dTopEdge;
                int len = this.label_list.size();
                if (len > 0 && !(sLabel = this.label_list.get(this.label_list.size() - 1)).bUp) {
                    double dx = this.getXStartLimit() - sLabel.slice.xDock;
                    double dy = 0.0;
                    if (dx != 0.0) {
                        dy = dx / sLabel.dRampRate;
                    }
                    double lspace = this.height / (double)(len + 1);
                    dMinTop = sLabel.slice.yDock + dy - this.height + lspace;
                }
                return dMinTop;
            }

            protected abstract double getXStartLimit();

            public double computeMaxTop() {
                SliceLabel sLabel;
                double dMaxTop = LabelOverlapResover.this.dBottomEdge - this.height;
                int len = this.label_list.size();
                if (len > 0 && (sLabel = this.label_list.get(0)).bUp) {
                    double dx = this.getXStartLimit() - sLabel.slice.xDock;
                    double dy = 0.0;
                    if (dx != 0.0) {
                        dy = dx / sLabel.dRampRate;
                    }
                    double lspace = this.height / (double)(len + 1);
                    dMaxTop = sLabel.slice.yDock + dy - lspace;
                }
                return dMaxTop;
            }

            private double getBottomLast() {
                double dBottomLast = LabelOverlapResover.this.dTopEdge;
                if (this.lgLast != null) {
                    dBottomLast = this.lgLast.top + this.lgLast.height + 3.0;
                }
                return dBottomLast;
            }

            public boolean pushUp(double dy) {
                if (this.isFull) {
                    return false;
                }
                double top_new = this.top - dy;
                double dTopMin = this.computeMinTop();
                double bottom_last = this.getBottomLast();
                if (this.lgLast == null || top_new >= bottom_last) {
                    this.top = Math.max(top_new, dTopMin);
                    return top_new >= dTopMin;
                }
                if (this.lgLast.pushUp(bottom_last - top_new)) {
                    this.top = Math.max(top_new, dTopMin);
                    return top_new >= dTopMin;
                }
                bottom_last = this.getBottomLast();
                if (this.top - this.lgLast.top >= dy) {
                    if (this.lgLast.merge(this)) {
                        return true;
                    }
                    this.top = Math.max(bottom_last, dTopMin);
                    return false;
                }
                if (!this.lgLast.merge(this)) {
                    this.top = Math.max(bottom_last, dTopMin);
                }
                return false;
            }

            public boolean merge(LabelGroup lg) {
                if (lg.label_list.size() > 1) {
                    return false;
                }
                if (lg.label_list.size() > 0) {
                    SliceLabel sLabel = lg.label_list.get(0);
                    if (!this.addSliceLabel(sLabel)) {
                        this.isFull = true;
                        return false;
                    }
                    if (this.top < this.computeMinTop() || this.top > this.computeMaxTop()) {
                        this.removeLastLabel();
                        this.isFull = true;
                        return false;
                    }
                }
                lg.delete();
                return true;
            }

            public void delete() {
                if (this.type == 0) {
                    this.lgLast.lgNext = this.lgNext;
                    this.lgNext.lgLast = this.lgLast;
                }
            }

            public abstract boolean addSliceLabel(SliceLabel var1);

            public abstract void updateSlices();

            public String toString() {
                StringBuffer sBuf = new StringBuffer();
                Iterator<SliceLabel> it = this.label_list.iterator();
                while (it.hasNext()) {
                    SliceLabel sLabel = it.next();
                    sBuf.append(sLabel.slice.categoryIndex);
                    if (!it.hasNext()) continue;
                    sBuf.append(", ");
                }
                StringBuilder sb = new StringBuilder("{ ");
                sb.append(sBuf.toString());
                sb.append(" }");
                return sb.toString();
            }
        }

        private class LabelGroupList {
            private boolean isFull = false;
            private LabelGroup head;
            private LabelGroup tail;

            LabelGroupList(boolean bRight) {
                if (bRight) {
                    this.head = new RightLabelGroup(1);
                    this.tail = new RightLabelGroup(2);
                } else {
                    this.head = new LeftLabelGroup(1);
                    this.tail = new LeftLabelGroup(2);
                }
                this.head.lgNext = this.tail;
                this.tail.lgLast = this.head;
            }

            private void append_simply(LabelGroup lg) {
                this.tail.lgLast.lgNext = lg;
                lg.lgLast = this.tail.lgLast;
                lg.lgNext = this.tail;
                this.tail.lgLast = lg;
            }

            private boolean limitLgTop(LabelGroup lg) {
                double maxTop;
                double minTop = lg.computeMinTop();
                if (minTop > (maxTop = lg.computeMaxTop())) {
                    return false;
                }
                lg.top = Math.max(lg.top, lg.computeMinTop());
                lg.top = Math.min(lg.top, lg.computeMaxTop());
                return true;
            }

            public boolean addSliceLabel(SliceLabel sLabel, boolean bRight) {
                LabelGroup lg = LabelOverlapResover.this.createLabelGroup(sLabel, bRight);
                if (this.tail.lgLast == this.head) {
                    this.append_simply(lg);
                    if (!this.limitLgTop(lg)) {
                        return false;
                    }
                    lg.xStart = lg.getXStartClosestToPie();
                    return true;
                }
                if (!this.limitLgTop(lg)) {
                    return false;
                }
                this.limitLgTop(lg);
                lg.xStart = lg.getXStartClosestToPie();
                double last_bottom = ((LabelGroup)this.tail).lgLast.top + ((LabelGroup)this.tail).lgLast.height + 3.0;
                double dy = last_bottom - lg.top;
                if (dy > 0.0) {
                    double lg_top_old = lg.top;
                    lg.top = last_bottom;
                    this.append_simply(lg);
                    double dMaxTop = lg.computeMaxTop();
                    if (lg.top <= dMaxTop) {
                        return true;
                    }
                    if (this.tail.lgLast.pushUp(lg.top - dMaxTop)) {
                        return true;
                    }
                    this.tail.lgLast.delete();
                    lg.top = lg_top_old;
                    this.isFull = true;
                    return false;
                }
                this.append_simply(lg);
                return true;
            }
        }

        private class LeftLabelGroup
        extends LabelGroup {
            public LeftLabelGroup(SliceLabel sLabel) {
                super(sLabel);
            }

            public LeftLabelGroup(int type) {
                super(type);
            }

            protected double getXStartLimit() {
                return LabelOverlapResover.this.dLeftEdge + this.width + LabelOverlapResover.this.dLeadLineLen + 5.0;
            }

            protected double getPrefferredXStart() {
                double x1 = this.getXStartLimit();
                double x0 = this.getXStartClosestToPie();
                double dx = x1 - x0;
                double len = 0.0;
                if (dx < 0.0) {
                    len = Math.abs(dx);
                    len = Math.min(len, LabelOverlapResover.this.dLeadLineLen + 5.0);
                }
                return x0 + len * Math.signum(dx);
            }

            public boolean addSliceLabel(SliceLabel sLabel) {
                double height_new = Math.max(this.height, sLabel.height);
                double width_new = this.label_list.size() == 0 ? 0.0 : this.width + 3.0;
                this.label_list.add(sLabel);
                double xStart_new = this.getXStartClosestToPie();
                if ((width_new += sLabel.width) > xStart_new - LabelOverlapResover.this.dLeftEdge || sLabel.height > LabelOverlapResover.this.dBottomEdge - this.top) {
                    this.label_list.remove(this.label_list.size() - 1);
                    return false;
                }
                this.width = width_new;
                this.xStart = xStart_new;
                this.height = height_new;
                return true;
            }

            public double getXStartClosestToPie() {
                int len = this.label_list.size();
                double lspace = this.height / (double)(len + 1);
                double y = this.top + lspace;
                double xStart = ((SliceLabel)this.label_list.get(0)).getXStartClosestToPie(y);
                int i = 1;
                while (i < len) {
                    xStart = Math.min(xStart, ((SliceLabel)this.label_list.get(i)).getXStartClosestToPie(y));
                    ++i;
                }
                return xStart;
            }

            public void updateSlices() {
                this.top = Math.min(this.top, LabelOverlapResover.this.dBottomEdge - this.height);
                int len = this.label_list.size();
                double lspace = this.height / (double)(len + 1);
                double dYLeadLine = this.top + lspace;
                this.xStart = this.getPrefferredXStart();
                if (LabelOverlapResover.this.lls == LeaderLineStyle.FIXED_LENGTH_LITERAL) {
                    double dRight = this.xStart;
                    int i = 0;
                    while (i < len) {
                        SliceLabel sLabel = (SliceLabel)this.label_list.get(i);
                        sLabel.slice.labelBounding.setTop(this.top);
                        sLabel.slice.labelBounding.setLeft(dRight - sLabel.width);
                        sLabel.slice.loEnd.setX(dRight);
                        sLabel.slice.loEnd.setY(dYLeadLine);
                        sLabel.slice.loStart.setX(this.xStart + LabelOverlapResover.this.dLeadLineLen);
                        sLabel.slice.loStart.setY(dYLeadLine);
                        dRight -= sLabel.width + 3.0;
                        dYLeadLine += lspace;
                        ++i;
                    }
                } else {
                    double dLeft = LabelOverlapResover.this.dLeftEdge;
                    int i = 0;
                    while (i < len) {
                        SliceLabel sLabel = (SliceLabel)this.label_list.get(i);
                        sLabel.slice.labelBounding.setTop(this.top);
                        sLabel.slice.labelBounding.setLeft(dLeft);
                        sLabel.slice.loEnd.setX(dLeft + sLabel.width);
                        sLabel.slice.loEnd.setY(dYLeadLine);
                        sLabel.slice.loStart.setX(this.xStart);
                        sLabel.slice.loStart.setY(dYLeadLine);
                        dLeft += sLabel.width + 3.0;
                        dYLeadLine += lspace;
                        ++i;
                    }
                }
            }
        }

        private class RightLabelGroup
        extends LabelGroup {
            public RightLabelGroup(SliceLabel sLabel) {
                super(sLabel);
            }

            public RightLabelGroup(int type) {
                super(type);
            }

            protected double getXStartLimit() {
                return LabelOverlapResover.this.dRightEdge - this.width - LabelOverlapResover.this.dLeadLineLen - 5.0;
            }

            protected double getPrefferredXStart() {
                double x1 = this.getXStartLimit();
                double x0 = this.getXStartClosestToPie();
                double dx = x1 - x0;
                double len = 0.0;
                if (dx > 0.0) {
                    len = Math.abs(dx);
                    len = Math.min(len, LabelOverlapResover.this.dLeadLineLen + 5.0);
                }
                return x0 + len * Math.signum(dx);
            }

            public boolean addSliceLabel(SliceLabel sLabel) {
                double width_new = this.label_list.size() == 0 ? 0.0 : this.width + 3.0;
                double height_new = Math.max(this.height, sLabel.height);
                this.label_list.add(sLabel);
                double xStart_new = this.getXStartClosestToPie();
                if ((width_new += sLabel.width) > LabelOverlapResover.this.dRightEdge - xStart_new || height_new > LabelOverlapResover.this.dBottomEdge - this.top) {
                    this.label_list.remove(this.label_list.size() - 1);
                    return false;
                }
                this.width = width_new;
                this.xStart = xStart_new;
                this.height = height_new;
                return true;
            }

            public double getXStartClosestToPie() {
                int len = this.label_list.size();
                double lspace = this.height / (double)(len + 1);
                double y = this.top + lspace;
                double xStart = ((SliceLabel)this.label_list.get(0)).getXStartClosestToPie(y);
                int i = 1;
                while (i < len) {
                    xStart = Math.max(xStart, ((SliceLabel)this.label_list.get(i)).getXStartClosestToPie(y));
                    ++i;
                }
                return xStart;
            }

            public void updateSlices() {
                this.top = Math.min(this.top, LabelOverlapResover.this.dBottomEdge - this.height);
                int len = this.label_list.size();
                double lspace = this.height / (double)(len + 1);
                double dYLeadLine = this.top + lspace;
                this.xStart = this.getPrefferredXStart();
                if (LabelOverlapResover.this.lls == LeaderLineStyle.FIXED_LENGTH_LITERAL) {
                    double dLeft = this.xStart;
                    int i = 0;
                    while (i < len) {
                        SliceLabel sLabel = (SliceLabel)this.label_list.get(i);
                        sLabel.slice.labelBounding.setTop(this.top);
                        sLabel.slice.labelBounding.setLeft(dLeft);
                        sLabel.slice.loEnd.setX(dLeft);
                        sLabel.slice.loEnd.setY(dYLeadLine);
                        sLabel.slice.loStart.setX(this.xStart - LabelOverlapResover.this.dLeadLineLen);
                        sLabel.slice.loStart.setY(dYLeadLine);
                        dLeft += sLabel.width + 3.0;
                        dYLeadLine += lspace;
                        ++i;
                    }
                } else {
                    double dRight = LabelOverlapResover.this.dRightEdge;
                    int i = 0;
                    while (i < len) {
                        SliceLabel sLabel = (SliceLabel)this.label_list.get(i);
                        sLabel.slice.labelBounding.setTop(this.top);
                        sLabel.slice.labelBounding.setLeft(dRight - sLabel.width);
                        sLabel.slice.loEnd.setX(dRight - sLabel.width);
                        sLabel.slice.loEnd.setY(dYLeadLine);
                        sLabel.slice.loStart.setX(this.xStart - LabelOverlapResover.this.dLeadLineLen);
                        sLabel.slice.loStart.setY(dYLeadLine);
                        dRight -= sLabel.width + 3.0;
                        dYLeadLine += lspace;
                        ++i;
                    }
                }
            }
        }

        private class SliceLabel {
            private boolean bRight = true;
            private boolean bUp = true;
            private final PieSlice slice;
            private double xStart;
            private final double width;
            private final double height;
            private final double top_init;
            private double dRampRate;

            public SliceLabel(PieSlice slice, boolean bRight) {
                this.slice = slice;
                this.bRight = bRight;
                this.width = slice.labelBounding.getWidth();
                this.height = slice.labelBounding.getHeight();
                this.top_init = slice.labelBounding.getTop();
                this.computeRampRate();
                this.xStart = !bRight ? slice.xDock - 5.0 - LabelOverlapResover.this.dLeadLineLen : slice.xDock + 5.0 + LabelOverlapResover.this.dLeadLineLen;
            }

            public double getXStartClosestToPie(double y) {
                double dy = y - this.slice.yDock;
                double dx = dy * this.dRampRate;
                if (this.bUp && dy <= 0.0 || !this.bUp && dy >= 0.0) {
                    dx = 0.0;
                }
                if (!this.bRight) {
                    return this.slice.xDock - 5.0 - LabelOverlapResover.this.dLeadLineLen + dx;
                }
                return this.slice.xDock + 5.0 + LabelOverlapResover.this.dLeadLineLen + dx;
            }

            private void computeRampRate() {
                double angle = this.slice.getdMidAngle() % 360.0;
                this.dRampRate = Math.tan(Math.toRadians(angle));
                if (angle > 180.0 && angle < 360.0) {
                    this.bUp = false;
                }
            }
        }
    }

    private static class OutsideLabelBoundCache {
        public int iLL = 0;
        public BoundingBox bb = null;

        private OutsideLabelBoundCache() {
        }

        public void reset() {
            this.iLL = 0;
            this.bb = null;
        }
    }

    public class PieSlice
    implements Cloneable {
        private boolean isExploded = true;
        private double originalStartAngle;
        private double startAngle;
        private double sliceLength;
        private double slicePecentage;
        private int categoryIndex;
        private DataPointHints dataPointHints;
        private double primitiveValue;
        private int quadrant = -1;
        private Location loPie;
        private Location loStart;
        private Location loEnd;
        private BoundingBox labelBounding = null;
        private Label la;
        private Bounds bounds = null;
        private double w;
        private double h;
        private double xc;
        private double yc;
        private double xDock;
        private double yDock;

        PieSlice(double primitiveValue, DataPointHints dataPointHints, int categroyIndex) throws ChartException {
            this.primitiveValue = primitiveValue;
            this.dataPointHints = dataPointHints;
            this.categoryIndex = categroyIndex;
            this.createSliceLabel();
        }

        public void createSliceLabel() throws ChartException {
            if (this.la != null) {
                return;
            }
            this.la = goFactory.copyOf(PieRenderer.this.ps.getLabel());
            this.la.getCaption().setValue(this.getDisplayValue());
            AbstractScriptHandler sh = PieRenderer.this.pie.getRunTimeContext().getScriptHandler();
            ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)this.getDataPointHints(), (Object)this.la, (Object)PieRenderer.this.pie.getRunTimeContext().getScriptContext());
            PieRenderer.this.pie.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)this.la);
        }

        private PieSlice() {
        }

        public Label getLabel() {
            return this.la;
        }

        public Object clone() {
            PieSlice slice;
            try {
                slice = (PieSlice)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                slice = new PieSlice();
            }
            this.copyTo(slice);
            return slice;
        }

        public void copyTo(PieSlice slice) {
            slice.primitiveValue = this.primitiveValue;
            slice.dataPointHints = this.dataPointHints;
            slice.categoryIndex = this.categoryIndex;
            slice.setLabelLocation(this.loPie, this.loStart, this.loEnd);
            slice.setExploded(this.isExploded);
            slice.setStartAngle(this.startAngle);
            slice.setSliceLength(this.sliceLength);
            slice.setPercentage(this.slicePecentage);
            slice.setBounds(this.bounds);
            slice.labelBounding = this.labelBounding;
            slice.quadrant = this.quadrant;
        }

        public double getPrimitiveValue() {
            return this.primitiveValue;
        }

        public DataPointHints getDataPointHints() {
            return this.dataPointHints;
        }

        public String getDisplayValue() {
            return this.dataPointHints.getDisplayValue();
        }

        public double getOriginalStartAngle() {
            return this.originalStartAngle;
        }

        public double getStartAngle() {
            return this.startAngle;
        }

        public double getSliceLength() {
            return this.sliceLength;
        }

        public double getdMidAngle() {
            return this.startAngle + this.sliceLength / 2.0;
        }

        public double getOriginalMidAngle() {
            return this.originalStartAngle + this.sliceLength / 2.0;
        }

        public double getSlicePercentage() {
            return this.slicePecentage;
        }

        public int getCategoryIndex() {
            return this.categoryIndex;
        }

        public int getQuadrant() {
            return this.quadrant;
        }

        public void setLabelLocation(double dX0, double dY0, double dX1, double dY1, double dX2, double dY2) {
            this.setLabelLocation(goFactory.createLocation(dX0, dY0), goFactory.createLocation(dX1, dY1), goFactory.createLocation(dX2, dY2));
        }

        public void setLabelLocation(Location loPie, Location loStart, Location loEnd) {
            this.loPie = loPie;
            this.loStart = loStart;
            this.loEnd = loEnd;
        }

        public void setExploded(boolean isExploded) {
            this.isExploded = isExploded;
        }

        public void setOriginalStartAngle(double originalStartAngle) {
            this.originalStartAngle = originalStartAngle;
        }

        public void setStartAngle(double startAngle) {
            this.startAngle = startAngle;
        }

        public void setSliceLength(double newLength) {
            this.sliceLength = newLength;
        }

        public void setPercentage(double newPercentage) {
            this.slicePecentage = newPercentage;
        }

        public final BoundingBox getLabelBounding() {
            return this.labelBounding;
        }

        public void removeLabelBounding() {
            this.labelBounding = null;
        }

        private final void render(Location loC, Location loOffset, Size sz, Fill fi, int iPieceType) throws ChartException {
            loC.translate(loOffset.getX() / 2.0, loOffset.getY() / 2.0);
            if (this.isExploded && PieRenderer.this.dExplosion != 0.0) {
                double dMidAngleInRadians = Math.toRadians(this.getStartAngle() + this.getSliceLength() / 2.0);
                double dSineThetaMid = Math.sin(dMidAngleInRadians);
                double dCosThetaMid = Math.cos(dMidAngleInRadians);
                double xDelta = PieRenderer.this.dExplosion * dCosThetaMid;
                double yDelta = PieRenderer.this.dExplosion * dSineThetaMid;
                if (PieRenderer.this.ratio < 1.0) {
                    yDelta *= PieRenderer.this.ratio;
                } else {
                    xDelta /= PieRenderer.this.ratio;
                }
                loC.translate(xDelta, -yDelta);
            }
            Location loCTop = goFactory.createLocation(loC.getX() - loOffset.getX(), loC.getY() - loOffset.getY());
            double dAngleInRadians = Math.toRadians(this.getStartAngle());
            double dSineThetaStart = Math.sin(dAngleInRadians);
            double dCosThetaStart = Math.cos(dAngleInRadians);
            dAngleInRadians = Math.toRadians(this.getStartAngle() + this.getSliceLength());
            double dSineThetaEnd = Math.sin(dAngleInRadians);
            double dCosThetaEnd = Math.cos(dAngleInRadians);
            double xE = sz.getWidth() * dCosThetaEnd;
            double yE = sz.getHeight() * dSineThetaEnd;
            double xS = sz.getWidth() * dCosThetaStart;
            double yS = sz.getHeight() * dSineThetaStart;
            ArcRenderEvent are = null;
            are = iPieceType == 1 ? new ArcRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints)) : (ArcRenderEvent)((EventObjectCache)PieRenderer.this.idr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.getDataPointHints()), ArcRenderEvent.class);
            are.setBackground(fi);
            PieRenderer.this.liaEdges.setColor(PieRenderer.this.getSliceOutline(fi));
            are.setOutline(PieRenderer.this.liaEdges);
            are.setTopLeft(goFactory.createLocation(loCTop.getX() - sz.getWidth(), loCTop.getY() - sz.getHeight() + (iPieceType == 1 ? PieRenderer.this.dThickness : 0.0)));
            are.setWidth(sz.getWidth() * 2.0);
            are.setHeight(sz.getHeight() * 2.0);
            are.setStartAngle(this.startAngle);
            are.setAngleExtent(this.sliceLength);
            are.setStyle(3);
            PieRenderer.this.idr.fillArc(are);
            if (iPieceType == 1) {
                double[] daXPoints = new double[]{loC.getX(), loCTop.getX(), loCTop.getX() + xE, loC.getX() + xE};
                double[] daYPoints = new double[]{loC.getY(), loCTop.getY(), loCTop.getY() - yE, loC.getY() - yE};
                PieRenderer.this.deferFlatPlane(PieRenderer.this.flatPlanes, this.getStartAngle() + this.getSliceLength(), daXPoints, daYPoints, fi, this.dataPointHints);
                daXPoints = new double[]{loC.getX(), loC.getX() + xS, loCTop.getX() + xS, loCTop.getX()};
                daYPoints = new double[]{loC.getY(), loC.getY() - yS, loCTop.getY() - yS, loCTop.getY()};
                PieRenderer.this.deferFlatPlane(PieRenderer.this.flatPlanes, this.getStartAngle(), daXPoints, daYPoints, fi, this.dataPointHints);
                daXPoints = new double[]{loC.getX() + xS, loCTop.getX() + xS, loCTop.getX() + xE, loC.getX() + xE};
                daYPoints = new double[]{loC.getY() - yS, loCTop.getY() - yS, loCTop.getY() - yE, loC.getY() - yE};
                LineRenderEvent lreStartB2T = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints));
                lreStartB2T.setStart(goFactory.createLocation(loC.getX() + xS, loC.getY() - yS));
                lreStartB2T.setEnd(goFactory.createLocation(loCTop.getX() + xS, loCTop.getY() - yS));
                LineRenderEvent lreEndT2B = new LineRenderEvent((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints));
                lreEndT2B.setStart(goFactory.createLocation(loCTop.getX() + xE, loCTop.getY() - yE));
                lreEndT2B.setEnd(goFactory.createLocation(loC.getX() + xE, loC.getY() - yE));
                Bounds r2ddTop = goFactory.createBounds(loCTop.getX() - sz.getWidth(), loCTop.getY() - sz.getHeight(), sz.getWidth() * 2.0, sz.getHeight() * 2.0);
                Bounds r2ddBottom = goFactory.createBounds(loC.getX() - sz.getWidth(), loC.getY() - sz.getHeight(), sz.getWidth() * 2.0, sz.getHeight() * 2.0);
                PieRenderer.this.registerCurvedSurface(r2ddTop, r2ddBottom, this.getStartAngle(), this.getSliceLength(), lreStartB2T, lreEndT2B, fi, this.dataPointHints, loC, loCTop, sz);
            } else if (iPieceType == 2) {
                EList elTriggers;
                if (PieRenderer.this.ps.getSliceOutline() != null) {
                    PieRenderer.this.idr.drawArc(are);
                }
                if (PieRenderer.this.pie.isInteractivityEnabled() && !(elTriggers = PieRenderer.this.ps.getTriggers()).isEmpty()) {
                    StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints);
                    InteractionEvent iev = (InteractionEvent)((EventObjectCache)PieRenderer.this.idr).getEventObject((Object)iSource, InteractionEvent.class);
                    iev.setCursor(PieRenderer.this.ps.getCursor());
                    int t = 0;
                    while (t < elTriggers.size()) {
                        Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                        PieRenderer.this.pie.processTrigger(tg, iSource);
                        iev.addTrigger(tg);
                        ++t;
                    }
                    iev.setHotSpot((PrimitiveRenderEvent)are);
                    PieRenderer.this.idr.enableInteraction(iev);
                }
            }
        }

        private void renderOneLine(IDeviceRenderer idr, Location lo1, Location lo2) throws ChartException {
            LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)idr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints), LineRenderEvent.class);
            lre.setLineAttributes(PieRenderer.this.liaLL);
            lre.setStart(lo1);
            lre.setEnd(lo2);
            idr.drawLine(lre);
        }

        private final void renderLabel(IDeviceRenderer idr, int iTextRenderType) throws ChartException {
            if (this.labelBounding == null) {
                return;
            }
            if (this.quadrant != -1) {
                if (iTextRenderType == 2) {
                    this.renderOneLine(idr, this.loPie, this.loStart);
                    this.renderOneLine(idr, this.loStart, this.loEnd);
                }
                PieRenderer.this.pie.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)PieRenderer.this.ps, (DataPointHints)this.dataPointHints), 3, this.getLabel(), this.quadrant == 1 || this.quadrant == 4 ? Position.RIGHT_LITERAL : Position.LEFT_LITERAL, this.loEnd, goFactory.createBounds(this.labelBounding.getLeft(), this.labelBounding.getTop(), this.labelBounding.getWidth(), this.labelBounding.getHeight()));
            } else {
                PieRenderer.this.pie.renderLabel(StructureSource.createSeries((Series)PieRenderer.this.ps), 3, this.getLabel(), null, null, goFactory.createBounds(this.labelBounding.getLeft(), this.labelBounding.getTop(), this.labelBounding.getWidth(), this.labelBounding.getHeight()));
            }
        }

        public boolean isLabelClipped(Bounds bo) {
            if (this.labelBounding != null) {
                if (this.labelBounding.getTop() < bo.getTop()) {
                    return true;
                }
                if (this.labelBounding.getLeft() < bo.getLeft()) {
                    return true;
                }
                if (this.labelBounding.getTop() + this.labelBounding.getHeight() > bo.getTop() + bo.getHeight()) {
                    return true;
                }
                if (this.labelBounding.getLeft() + this.labelBounding.getWidth() > bo.getLeft() + bo.getWidth()) {
                    return true;
                }
            }
            return false;
        }

        public boolean isLabelOverlap(PieSlice sliceToCompare) {
            BoundingBox dLow;
            BoundingBox dHigh;
            if (sliceToCompare == null || sliceToCompare == this || sliceToCompare.labelBounding == null) {
                return false;
            }
            BoundingBox bb1 = this.labelBounding;
            BoundingBox bb2 = sliceToCompare.labelBounding;
            if (bb1.getTop() < bb2.getTop()) {
                dHigh = bb1;
                dLow = bb2;
            } else {
                dHigh = bb2;
                dLow = bb1;
            }
            if (dHigh.getLeft() < dLow.getLeft()) {
                double dXHigh = dHigh.getLeft() + dHigh.getWidth();
                double dYHigh = dHigh.getTop() + dHigh.getHeight();
                double dXLow = dLow.getLeft();
                double dYLow = dLow.getTop();
                if (dXHigh > dXLow && dYHigh > dYLow) {
                    return true;
                }
            } else {
                double dXHigh = dHigh.getLeft();
                double dYHigh = dHigh.getTop() + dHigh.getHeight();
                double dXLow = dLow.getLeft() + dLow.getWidth();
                double dYLow = dLow.getTop();
                if (dXHigh < dXLow && dYHigh > dYLow) {
                    return true;
                }
            }
            return false;
        }

        public void setBounds(Bounds bo) {
            this.bounds = bo;
            this.w = this.bounds.getWidth() / 2.0 - PieRenderer.this.dExplosion;
            this.h = this.bounds.getHeight() / 2.0 - PieRenderer.this.dExplosion - PieRenderer.this.dThickness / 2.0;
            this.xc = this.bounds.getLeft() + this.w + PieRenderer.this.dExplosion;
            this.yc = this.bounds.getTop() + this.h + PieRenderer.this.dExplosion + PieRenderer.this.dThickness / 2.0;
            if (PieRenderer.this.ratio > 0.0 && this.w > 0.0) {
                if (this.h / this.w > PieRenderer.this.ratio) {
                    this.h = this.w * PieRenderer.this.ratio;
                } else if (this.h / this.w < PieRenderer.this.ratio) {
                    this.w = this.h / PieRenderer.this.ratio;
                }
            }
            if (this.w <= 0.0 || this.h <= 0.0) {
                this.h = 1.0;
                this.w = 1.0;
            }
        }

        private void computeLabelBoundOutside(LeaderLineStyle lls, double dLeaderLength, OutsideLabelBoundCache bbCache) throws ChartException {
            double yDelta2;
            double xDelta2;
            double yDelta1;
            double xDelta1;
            int iLL = 0;
            double dLeaderTick = Math.max(dLeaderLength / 4.0, 10.0 * PieRenderer.this.pie.getDeviceScale());
            double dLeaderW = 0.0;
            double dLeaderH = 0.0;
            double dBottomLeaderW = 0.0;
            double dBottomLeaderH = 0.0;
            double dTopLeaderW = 0.0;
            double dTopLeaderH = 0.0;
            Location center = goFactory.createLocation(this.xc, this.yc - PieRenderer.this.dThickness / 2.0);
            Location depthCenter = goFactory.createLocation(this.xc, this.yc);
            double dX = 0.0;
            double dLeftSide = this.xc - PieRenderer.this.dExplosion - this.w;
            double dRightSide = this.xc + PieRenderer.this.dExplosion + this.w;
            if (this.w > this.h) {
                dTopLeaderW = dLeaderTick;
                dTopLeaderH = dLeaderTick * PieRenderer.this.ratio;
            } else {
                dTopLeaderH = dLeaderTick;
                dTopLeaderW = dLeaderTick / PieRenderer.this.ratio;
            }
            double dMidAngleInDegrees = this.getOriginalMidAngle() % 360.0;
            double dMidAngleInRadians = Math.toRadians(-dMidAngleInDegrees);
            double dSineThetaMid = Math.sin(dMidAngleInRadians);
            double dCosThetaMid = Math.cos(dMidAngleInRadians);
            if (PieRenderer.this.dThickness > 0.0 && dMidAngleInDegrees > 180.0 && dMidAngleInDegrees < 360.0) {
                double dTmpLeaderTick = Math.max(PieRenderer.this.dThickness * dSineThetaMid + 8.0 * PieRenderer.this.pie.getDeviceScale(), dLeaderTick);
                if (this.w > this.h) {
                    dBottomLeaderW = dTmpLeaderTick;
                    dBottomLeaderH = dTmpLeaderTick * PieRenderer.this.ratio;
                } else {
                    dBottomLeaderH = dTmpLeaderTick;
                    dBottomLeaderW = dTmpLeaderTick / PieRenderer.this.ratio;
                }
                dLeaderW = dBottomLeaderW;
                dLeaderH = dBottomLeaderH;
            } else {
                dLeaderW = dTopLeaderW;
                dLeaderH = dTopLeaderH;
            }
            if (this.isExploded) {
                xDelta1 = (this.w + PieRenderer.this.dExplosion) * dCosThetaMid;
                yDelta1 = (this.h + PieRenderer.this.dExplosion) * dSineThetaMid;
                xDelta2 = (this.w + dLeaderW + PieRenderer.this.dExplosion) * dCosThetaMid;
                yDelta2 = (this.h + dLeaderH + PieRenderer.this.dExplosion) * dSineThetaMid;
            } else {
                xDelta1 = this.w * dCosThetaMid;
                yDelta1 = this.h * dSineThetaMid;
                xDelta2 = (this.w + dLeaderW) * dCosThetaMid;
                yDelta2 = (this.h + dLeaderH) * dSineThetaMid;
            }
            if (lls == LeaderLineStyle.STRETCH_TO_SIDE_LITERAL) {
                if (dMidAngleInDegrees >= 90.0 && dMidAngleInDegrees < 270.0) {
                    dX = dLeftSide - dLeaderW * 1.5;
                    iLL = 1;
                } else {
                    dX = dRightSide + dLeaderW * 1.5;
                    iLL = 2;
                }
            } else if (lls == LeaderLineStyle.FIXED_LENGTH_LITERAL) {
                if (dMidAngleInDegrees > 90.0 && dMidAngleInDegrees < 270.0) {
                    dX = center.getX() + xDelta2 - dLeaderLength;
                    if (dLeaderLength > 0.0) {
                        iLL = 1;
                    } else if (dMidAngleInDegrees < 135.0) {
                        iLL = 4;
                    } else if (dMidAngleInDegrees < 225.0) {
                        iLL = 1;
                    } else if (dMidAngleInDegrees < 270.0) {
                        iLL = 8;
                    } else assert (false);
                } else {
                    dX = center.getX() + xDelta2 + dLeaderLength;
                    if (dLeaderLength > 0.0) {
                        iLL = 2;
                    } else if (dMidAngleInDegrees <= 45.0) {
                        iLL = 2;
                    } else if (dMidAngleInDegrees > 45.0 && dMidAngleInDegrees <= 90.0) {
                        iLL = 4;
                    } else if (dMidAngleInDegrees <= 315.0 && dMidAngleInDegrees >= 270.0) {
                        iLL = 8;
                    } else if (dMidAngleInDegrees > 315.0) {
                        iLL = 2;
                    } else assert (false);
                }
            }
            Location relativeCenter = dMidAngleInDegrees > 0.0 && dMidAngleInDegrees < 180.0 ? center : depthCenter;
            this.xDock = relativeCenter.getX() + xDelta1;
            this.yDock = relativeCenter.getY() + yDelta1;
            this.setLabelLocation(this.xDock, this.yDock, relativeCenter.getX() + xDelta2, relativeCenter.getY() + yDelta2, dX, relativeCenter.getY() + yDelta2);
            if (bbCache != null && bbCache.iLL == iLL && bbCache.bb != null) {
                this.labelBounding = bbCache.bb.clone();
            } else {
                this.labelBounding = PieRenderer.this.cComp.computeBox(PieRenderer.this.xs, iLL, this.getLabel(), 0.0, 0.0);
                if (bbCache != null && bbCache.iLL == 0) {
                    bbCache.iLL = iLL;
                    bbCache.bb = this.labelBounding.clone();
                }
            }
            this.labelBounding.setLeft(this.labelBounding.getLeft() + dX);
            this.labelBounding.setTop(this.labelBounding.getTop() + relativeCenter.getY() + yDelta2);
            if (dMidAngleInDegrees >= 0.0 && dMidAngleInDegrees < 90.0) {
                this.quadrant = 1;
            }
            if (dMidAngleInDegrees >= 90.0 && dMidAngleInDegrees < 180.0) {
                this.quadrant = 2;
            }
            this.quadrant = dMidAngleInDegrees >= 180.0 && dMidAngleInDegrees < 270.0 ? 3 : 4;
        }

        private void computeLabelBoundInside() throws ChartException {
            double yDelta;
            double xDelta;
            double dMidAngleInRadians = Math.toRadians(-this.getdMidAngle());
            double dSineThetaMid = Math.sin(dMidAngleInRadians);
            double dCosThetaMid = Math.cos(dMidAngleInRadians);
            if (this.isExploded) {
                xDelta = (this.w / 1.5 + PieRenderer.this.dExplosion) * dCosThetaMid;
                yDelta = (this.h / 1.5 + PieRenderer.this.dExplosion) * dSineThetaMid;
            } else {
                xDelta = this.w / 1.5 * dCosThetaMid;
                yDelta = this.h / 1.5 * dSineThetaMid;
            }
            this.labelBounding = PieRenderer.this.cComp.computeBox(PieRenderer.this.xs, 1, this.getLabel(), 0.0, 0.0);
            this.labelBounding.setLeft(this.xc + xDelta - this.labelBounding.getWidth() / 2.0);
            this.labelBounding.setTop(this.yc - PieRenderer.this.dThickness / 2.0 + yDelta - this.labelBounding.getHeight() / 2.0);
        }
    }
}

