/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.internal.useractions.UserActionsResources;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDTreeView;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDWorkWithDialog;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDARestoreDefaultsActions;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseManager;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDBaseTreeViewLabelProvider;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeActionCopy;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeActionDelete;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeActionMoveDown;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeActionMoveUp;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeActionPaste;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeViewNewItem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTypeElement;
import org.eclipse.rse.internal.useractions.ui.uda.SystemXMLElementWrapper;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SystemUDBaseTreeView
extends TreeViewer
implements IMenuListener,
IDoubleClickListener,
ISystemUDTreeView {
    protected Composite parent;
    protected MenuManager menuMgr;
    protected SystemUDBaseManager docManager;
    protected ISubSystem subsystem;
    protected ISubSystemConfiguration subsystemFactory;
    protected ISystemProfile profile;
    protected ISystemUDWorkWithDialog wwDialog;
    protected SystemUDTreeActionCopy copyAction;
    protected SystemUDTreeActionPaste pasteAction;
    protected SystemUDTreeActionDelete deleteAction;
    protected SystemUDTreeActionMoveUp moveUpAction;
    protected SystemUDTreeActionMoveDown moveDownAction;
    protected SystemUDARestoreDefaultsActions restoreAction;
    protected Clipboard clipboard;
    protected boolean menuListenerAdded;

    public SystemUDBaseTreeView(Composite parent, ISystemUDWorkWithDialog editPane, ISubSystem ss, SystemUDBaseManager docManager) {
        super(parent, 2820);
        this.parent = parent;
        this.subsystem = ss;
        this.subsystemFactory = this.subsystem.getSubSystemConfiguration();
        this.profile = this.subsystem.getSystemProfile();
        this.docManager = docManager;
        this.wwDialog = editPane;
        this.init();
        this.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (SystemUDBaseTreeView.this.clipboard != null) {
                    SystemUDBaseTreeView.this.clipboard.dispose();
                }
            }
        });
    }

    public SystemUDBaseTreeView(Composite parent, ISystemUDWorkWithDialog editPane, ISubSystemConfiguration ssFactory, ISystemProfile profile, SystemUDBaseManager docManager) {
        super(parent, 2820);
        this.parent = parent;
        this.subsystemFactory = ssFactory;
        this.profile = profile;
        this.docManager = docManager;
        this.wwDialog = editPane;
        this.init();
        this.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (SystemUDBaseTreeView.this.clipboard != null) {
                    SystemUDBaseTreeView.this.clipboard.dispose();
                }
            }
        });
    }

    protected void init() {
        this.setContentProvider((IContentProvider)this.docManager);
        this.setLabelProvider((IBaseLabelProvider)new SystemUDBaseTreeViewLabelProvider(this.docManager));
        this.addDoubleClickListener(this);
        this.menuMgr = new MenuManager("#UDTreePopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener((IMenuListener)this);
        Menu menu = this.menuMgr.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
        this.setInput("0");
    }

    public void expandDomainNodes() {
        if (this.docManager.getActionSubSystem().supportsDomains()) {
            TreeItem[] rootItems = this.getTree().getItems();
            int idx = 0;
            while (idx < rootItems.length) {
                SystemUDTreeViewNewItem newNode;
                if (rootItems[idx].getData() instanceof SystemXMLElementWrapper) {
                    this.setExpandedState(rootItems[idx].getData(), true);
                } else if (rootItems[idx].getData() instanceof SystemUDTreeViewNewItem && !(newNode = (SystemUDTreeViewNewItem)rootItems[idx].getData()).isExecutable()) {
                    this.setExpandedState(rootItems[idx].getData(), true);
                }
                ++idx;
            }
        }
    }

    public void expandDomainNode(String displayName) {
        if (this.docManager.getActionSubSystem().supportsDomains()) {
            TreeItem[] rootItems = this.getTree().getItems();
            int idx = 0;
            while (idx < rootItems.length) {
                if (rootItems[idx].getData() instanceof SystemXMLElementWrapper && rootItems[idx].getText().equals(displayName)) {
                    this.setExpandedState(rootItems[idx].getData(), true);
                    return;
                }
                ++idx;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        Menu m;
        this.fillContextMenu(menu);
        if (!this.menuListenerAdded && menu instanceof MenuManager && (m = ((MenuManager)menu).getMenu()) != null) {
            this.menuListenerAdded = true;
            SystemViewMenuListener ml = new SystemViewMenuListener();
            m.addMenuListener((MenuListener)ml);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        int selectionCount = selection.size();
        if (selectionCount > 0) {
            Object firstSelection = selection.getFirstElement();
            if (firstSelection instanceof SystemXMLElementWrapper && !((SystemXMLElementWrapper)firstSelection).isDomain()) {
                this.createStandardGroups(menu);
                SystemBaseAction action = this.getDeleteAction((ISelection)selection);
                menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
                action = this.getCopyAction((ISelection)selection);
                menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
                action = this.getPasteAction((ISelection)selection);
                menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
                action = this.getMoveUpAction((ISelection)selection);
                menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
                action = this.getMoveDownAction((ISelection)selection);
                menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
                action = this.getRestoreAction((ISelection)selection);
                if (action != null) {
                    menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
                }
            } else if (firstSelection instanceof SystemXMLElementWrapper && ((SystemXMLElementWrapper)firstSelection).isDomain()) {
                this.createStandardGroups(menu);
                SystemUDTreeActionPaste action = this.getPasteAction((ISelection)selection);
                menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
            }
        }
    }

    public void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.reorder"));
        menu.add((IContributionItem)new Separator("group.change"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    private SystemUDTreeActionDelete getDeleteAction(ISelection selection) {
        if (this.deleteAction == null) {
            this.deleteAction = new SystemUDTreeActionDelete(this);
        }
        this.deleteAction.setInputs(this.getShell(), (Viewer)this, selection);
        return this.deleteAction;
    }

    private SystemUDTreeActionMoveUp getMoveUpAction(ISelection selection) {
        if (this.moveUpAction == null) {
            this.moveUpAction = new SystemUDTreeActionMoveUp(this);
        }
        this.moveUpAction.setInputs(this.getShell(), (Viewer)this, selection);
        return this.moveUpAction;
    }

    private SystemUDTreeActionMoveDown getMoveDownAction(ISelection selection) {
        if (this.moveDownAction == null) {
            this.moveDownAction = new SystemUDTreeActionMoveDown(this);
        }
        this.moveDownAction.setInputs(this.getShell(), (Viewer)this, selection);
        return this.moveDownAction;
    }

    private SystemUDTreeActionCopy getCopyAction(ISelection selection) {
        if (this.copyAction == null) {
            this.copyAction = new SystemUDTreeActionCopy(this);
        }
        this.copyAction.setInputs(this.getShell(), (Viewer)this, selection);
        return this.copyAction;
    }

    private SystemUDTreeActionPaste getPasteAction(ISelection selection) {
        if (this.pasteAction == null) {
            this.pasteAction = new SystemUDTreeActionPaste(this);
        }
        this.pasteAction.setInputs(this.getShell(), (Viewer)this, selection);
        return this.pasteAction;
    }

    protected SystemUDARestoreDefaultsActions getRestoreAction(ISelection selection) {
        if (this.restoreAction == null) {
            this.restoreAction = new SystemUDARestoreDefaultsActions(this);
        }
        this.restoreAction.setShell(this.getShell());
        if (selection != null) {
            this.restoreAction.setSelection(selection);
        }
        return this.restoreAction;
    }

    public Shell getShell() {
        return this.getTree().getShell();
    }

    public void clearClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
    }

    public boolean canDelete() {
        return this.wwDialog.canDelete(((IStructuredSelection)this.getSelection()).getFirstElement());
    }

    public boolean canMoveUp() {
        return this.wwDialog.canMoveUp(((IStructuredSelection)this.getSelection()).getFirstElement());
    }

    public boolean canMoveDown() {
        return this.wwDialog.canMoveDown(((IStructuredSelection)this.getSelection()).getFirstElement());
    }

    public boolean canCopy() {
        return this.wwDialog.canCopy(((IStructuredSelection)this.getSelection()).getFirstElement());
    }

    public boolean canPaste() {
        if (this.clipboard == null) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (!(selection.getFirstElement() instanceof SystemXMLElementWrapper)) {
            return false;
        }
        SystemXMLElementWrapper firstSelect = (SystemXMLElementWrapper)selection.getFirstElement();
        TextTransfer textTransfer = TextTransfer.getInstance();
        String textData = (String)this.clipboard.getContents((Transfer)textTransfer);
        return this.docManager.enablePaste(firstSelect, textData);
    }

    public boolean doDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        boolean deleted = false;
        SystemMessage confirmDlt = this.getDeleteConfirmationMessage();
        SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), confirmDlt);
        try {
            deleted = msgDlg.openQuestion();
            if (deleted) {
                this.docManager.delete(this.docManager.getCurrentProfile(), (SystemXMLElementWrapper)selection.getFirstElement());
                this.docManager.saveUserData(this.docManager.getCurrentProfile());
                deleted = true;
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error deleting user actions", (Throwable)exc);
        }
        if (deleted) {
            this.remove(selection.getFirstElement());
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(2, this.getResourceType(), selection.getFirstElement(), null);
        }
        return deleted;
    }

    protected int getResourceType() {
        return -1;
    }

    protected SystemMessage getDeleteConfirmationMessage() {
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1230", 4, UserActionsResources.MSG_CONFIRM_DELETE_USERACTION, UserActionsResources.MSG_CONFIRM_DELETE_USERTYPE_DETAILS);
        msg.setIndicator('Q');
        return msg;
    }

    public boolean doMoveUp() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        SystemXMLElementWrapper firstSelect = (SystemXMLElementWrapper)selection.getFirstElement();
        boolean moved = this.docManager.moveElementUp(firstSelect);
        if (moved) {
            this.refreshElementParent(firstSelect);
            this.selectElement(firstSelect);
            this.docManager.saveUserData(this.docManager.getCurrentProfile());
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(16, this.getResourceType(), (Object)firstSelect, null);
        }
        return true;
    }

    public boolean doMoveDown() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        SystemXMLElementWrapper firstSelect = (SystemXMLElementWrapper)selection.getFirstElement();
        boolean moved = this.docManager.moveElementDown(firstSelect);
        if (moved) {
            this.refreshElementParent(firstSelect);
            this.selectElement(firstSelect);
            this.docManager.saveUserData(this.docManager.getCurrentProfile());
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(16, this.getResourceType(), (Object)firstSelect, null);
        }
        return true;
    }

    public boolean doCopy() {
        String id;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        SystemXMLElementWrapper firstSelect = (SystemXMLElementWrapper)selection.getFirstElement();
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.getShell().getDisplay());
        }
        if ((id = this.docManager.prepareClipboardCopy(firstSelect)) == null) {
            return false;
        }
        TextTransfer transfer = TextTransfer.getInstance();
        this.clipboard.setContents(new Object[]{id}, new Transfer[]{transfer});
        return true;
    }

    public boolean doPaste() {
        TextTransfer textTransfer;
        String textData;
        if (this.clipboard == null) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        SystemXMLElementWrapper firstSelect = (SystemXMLElementWrapper)selection.getFirstElement();
        SystemXMLElementWrapper pastedElementWrapper = this.docManager.pasteClipboardCopy(firstSelect, textData = (String)this.clipboard.getContents((Transfer)(textTransfer = TextTransfer.getInstance())));
        if (pastedElementWrapper != null) {
            if (firstSelect.isDomain()) {
                this.refresh(firstSelect);
                this.setExpandedState(firstSelect, true);
            } else {
                this.refreshElementParent(firstSelect);
            }
            this.selectElement(pastedElementWrapper);
            RSECorePlugin.getTheSystemRegistry().fireModelChangeEvent(1, this.getResourceType(), (Object)pastedElementWrapper, null);
        }
        this.clipboard.dispose();
        this.clipboard = null;
        return pastedElementWrapper != null;
    }

    public boolean canRestore() {
        if (this.wwDialog.areChangesPending()) {
            return false;
        }
        SystemXMLElementWrapper selectedElement = this.getSelectedElement();
        if (selectedElement == null || !(selectedElement instanceof SystemUDActionElement) && !(selectedElement instanceof SystemUDTypeElement)) {
            return false;
        }
        return selectedElement.isIBM() && selectedElement.isUserChanged();
    }

    public void doRestore() {
    }

    public SystemUDBaseManager getDocumentManager() {
        return this.docManager;
    }

    public void doubleClick(DoubleClickEvent event) {
    }

    public String getSelectedElementName() {
        Object selObj;
        String seldName = "";
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        if (sel != null && sel.getFirstElement() != null && (selObj = sel.getFirstElement()) instanceof SystemXMLElementWrapper) {
            seldName = ((SystemXMLElementWrapper)selObj).toString();
        }
        return seldName;
    }

    public boolean isElementAllSelected() {
        return this.getSelectedElementName().equals("ALL");
    }

    public boolean isSelectionVendorSupplied() {
        SystemXMLElementWrapper selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            String vendor = selectedElement.getVendor();
            return vendor != null && vendor.length() > 0;
        }
        return false;
    }

    public String getVendorOfSelection() {
        String vendor;
        SystemXMLElementWrapper selectedElement = this.getSelectedElement();
        if (selectedElement != null && (vendor = selectedElement.getVendor()) != null && vendor.length() > 0) {
            return vendor;
        }
        return null;
    }

    public int getSelectedElementDomain() {
        Object selObj;
        int seldDomain = -1;
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        if (sel != null && sel.getFirstElement() != null && (selObj = sel.getFirstElement()) instanceof SystemXMLElementWrapper) {
            seldDomain = ((SystemXMLElementWrapper)selObj).getDomain();
        }
        return seldDomain;
    }

    public SystemXMLElementWrapper getSelectedElement() {
        SystemXMLElementWrapper selEle;
        Object selObj;
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        if (sel != null && sel.getFirstElement() != null && (selObj = sel.getFirstElement()) instanceof SystemXMLElementWrapper && !(selEle = (SystemXMLElementWrapper)selObj).isDomain()) {
            return selEle;
        }
        return null;
    }

    public void selectElement(SystemXMLElementWrapper element) {
        Widget w = this.findItem(element);
        if (w != null) {
            super.setSelection((ISelection)new StructuredSelection((Object)element), true);
        } else {
            TreeItem matchingItem = this.findElement(element.getElement());
            if (matchingItem != null) {
                super.setSelection((ISelection)new StructuredSelection(matchingItem.getData()), true);
            } else {
                super.setSelection(null);
            }
        }
    }

    public TreeItem findParentItem(SystemXMLElementWrapper element) {
        IPropertySet parentElement = element.getParentElement();
        TreeItem parentItem = null;
        if (parentElement != null) {
            parentItem = this.findElement(parentElement);
        }
        return parentItem;
    }

    public void refreshElementParent(SystemXMLElementWrapper element) {
        TreeItem parentItem = this.findParentItem(element);
        if (parentItem == null) {
            this.refresh();
            parentItem = this.findParentItem(element);
        } else {
            this.refresh(parentItem.getData());
        }
        if (parentItem != null && !parentItem.getExpanded()) {
            this.setExpandedState(parentItem.getData(), true);
        }
    }

    private TreeItem findElement(IPropertySet searchNode) {
        TreeItem match = null;
        TreeItem[] roots = this.getTree().getItems();
        int idx = 0;
        while (match == null && idx < roots.length) {
            match = this.findElement(roots[idx], searchNode);
            ++idx;
        }
        return match;
    }

    private TreeItem findElement(TreeItem parentItem, IPropertySet searchNode) {
        TreeItem match = null;
        Object itemData = parentItem.getData();
        IPropertySet itemNode = null;
        if (itemData != null && itemData instanceof SystemXMLElementWrapper && (itemNode = ((SystemXMLElementWrapper)itemData).getElement()) == searchNode) {
            return parentItem;
        }
        TreeItem[] kids = parentItem.getItems();
        if (kids != null) {
            int idx = 0;
            while (match == null && idx < kids.length) {
                match = this.findElement(kids[idx], searchNode);
                ++idx;
            }
        }
        return match;
    }

    public TreeItem getSelectedTreeItem() {
        TreeItem[] selectedItems = this.getTree().getSelection();
        if (selectedItems != null && selectedItems.length > 0) {
            return selectedItems[0];
        }
        return null;
    }

    public TreeItem getSelectedPreviousTreeItem() {
        TreeItem selectedItem = this.getSelectedTreeItem();
        if (selectedItem == null) {
            return null;
        }
        TreeItem[] siblings = null;
        siblings = selectedItem.getParentItem() != null ? selectedItem.getParentItem().getItems() : selectedItem.getParent().getItems();
        int idx = 0;
        while (idx < siblings.length) {
            if (siblings[idx] == selectedItem) {
                if (idx == 0) {
                    return null;
                }
                return siblings[idx - 1];
            }
            ++idx;
        }
        return null;
    }

    public TreeItem getSelectedNextTreeItem() {
        TreeItem selectedItem = this.getSelectedTreeItem();
        if (selectedItem == null) {
            return null;
        }
        TreeItem[] siblings = null;
        siblings = selectedItem.getParentItem() != null ? selectedItem.getParentItem().getItems() : selectedItem.getParent().getItems();
        int idx = 0;
        while (idx < siblings.length) {
            if (siblings[idx] == selectedItem) {
                if (idx >= siblings.length - 1) {
                    return null;
                }
                return siblings[idx + 1];
            }
            ++idx;
        }
        return null;
    }

    public TreeItem getSelectedNextNextTreeItem() {
        TreeItem selectedItem = this.getSelectedTreeItem();
        if (selectedItem == null) {
            return null;
        }
        TreeItem[] siblings = null;
        siblings = selectedItem.getParentItem() != null ? selectedItem.getParentItem().getItems() : selectedItem.getParent().getItems();
        int idx = 0;
        while (idx < siblings.length) {
            if (siblings[idx] == selectedItem) {
                if (idx >= siblings.length - 2) {
                    return null;
                }
                return siblings[idx + 2];
            }
            ++idx;
        }
        return null;
    }

    protected void moveTreeItem(Widget parentItem, Item item, Object src, int newPosition) {
        if (this.getExpanded(item)) {
            this.setExpanded(item, false);
            this.refresh(src);
        }
        this.createTreeItem(parentItem, src, newPosition);
        this.disassociate(item);
        item.dispose();
    }

    protected int getTreeItemPosition(Widget parentItem, Item childItem) {
        int pos = -1;
        Item[] children = null;
        children = parentItem instanceof Item ? this.getItems((Item)parentItem) : this.getChildren(parentItem);
        int idx = 0;
        while (pos == -1 && idx < children.length) {
            if (children[idx] == childItem) {
                pos = idx;
            }
            ++idx;
        }
        return pos;
    }
}

