/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.monitor;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.extensions.ExtensibilityElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.ws.internal.monitor.IExtensibilityElementTransformer;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;

public class ExtensibilityElementTransformerRegistry {
    public static final ExtensibilityElementTransformerRegistry INSTANCE = new ExtensibilityElementTransformerRegistry();
    private List<IExtensibilityElementTransformer> transformers = new ArrayList<IExtensibilityElementTransformer>();

    private ExtensibilityElementTransformerRegistry() {
        IConfigurationElement[] configs;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configs = extensionRegistry.getConfigurationElementsFor("org.eclipse.wst.ws.ExtensibilityElementTransformer");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                IExtensibilityElementTransformer transformer = (IExtensibilityElementTransformer)config.createExecutableExtension("class");
                this.transformers.add(transformer);
            }
            catch (CoreException e) {
                WSPlugin.getInstance().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    public String transform(ExtensibilityElement element) {
        for (IExtensibilityElementTransformer transformer : this.transformers) {
            String str = transformer.transform(element);
            if (str == null) continue;
            return str;
        }
        return null;
    }
}

