/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XPathDecimalFormat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class XSDecimal
extends NumericType {
    private static final String XS_DECIMAL = "xs:decimal";
    private BigDecimal _value;
    private XPathDecimalFormat format = new XPathDecimalFormat("0.####################");

    public XSDecimal() {
        this(BigDecimal.ZERO);
    }

    public XSDecimal(BigDecimal x) {
        this._value = x;
    }

    public XSDecimal(String x) {
        this._value = new BigDecimal(x, MathContext.DECIMAL128);
    }

    public String string_type() {
        return XS_DECIMAL;
    }

    public String type_name() {
        return "decimal";
    }

    public String string_value() {
        if (this.zero()) {
            return "0";
        }
        this._value = this._value.stripTrailingZeros();
        return this.format.xpathFormat(this._value);
    }

    public boolean zero() {
        return this._value.compareTo(BigDecimal.valueOf(0.0)) == 0;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        if (aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (aat.string_value().contains("-INF")) {
            throw DynamicError.cant_cast(null);
        }
        if (!this.isLexicalValue(aat.string_value())) {
            throw DynamicError.invalidLexicalValue();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        try {
            XSDecimal decimal = this.castDecimal(aat);
            rs.add(decimal);
            return rs;
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    protected boolean isLexicalValue(String value) {
        if (value.equalsIgnoreCase("inf")) {
            return false;
        }
        return !value.equalsIgnoreCase("-inf");
    }

    private boolean isCastable(AnyType aat) throws DynamicError {
        if (aat instanceof XSBoolean || aat instanceof NumericType) {
            return true;
        }
        if (aat.string_value().contains("E") || aat.string_value().contains("e") && !(aat instanceof XSBoolean)) {
            return false;
        }
        return aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof NodeType;
    }

    private XSDecimal castDecimal(AnyType aat) {
        if (aat instanceof XSBoolean) {
            if (aat.string_value().equals("true")) {
                return new XSDecimal(BigDecimal.ONE);
            }
            return new XSDecimal(BigDecimal.ZERO);
        }
        return new XSDecimal(aat.string_value());
    }

    @Deprecated
    public double double_value() {
        return this._value.doubleValue();
    }

    public BigDecimal getValue() {
        return this._value;
    }

    public void set_double(double x) {
        this._value = BigDecimal.valueOf(x);
    }

    public boolean eq(AnyType at, DynamicContext context) throws DynamicError {
        XSDecimal dt = null;
        if (!(at instanceof XSDecimal)) {
            ResultSequence rs = ResultSequenceFactory.create_new(at);
            ResultSequence crs = this.constructor(rs);
            if (crs.empty()) {
                throw DynamicError.throw_type_error();
            }
            AnyType cat = crs.first();
            dt = (XSDecimal)cat;
        } else {
            dt = (XSDecimal)at;
        }
        return this._value.compareTo(dt.getValue()) == 0;
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        AnyType carg = this.convertArg(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        return this._value.compareTo(val.getValue()) == 1;
    }

    protected AnyType convertArg(AnyType arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new(arg);
        rs = this.constructor(rs);
        AnyType carg = rs.first();
        return carg;
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        AnyType carg = this.convertArg(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        return this._value.compareTo(val.getValue()) == -1;
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        AnyType at = this.get_single_arg(carg);
        if (!(at instanceof XSDecimal)) {
            DynamicError.throw_type_error();
        }
        XSDecimal dt = (XSDecimal)at;
        return ResultSequenceFactory.create_new(new XSDecimal(this._value.add(dt.getValue())));
    }

    private ResultSequence convertResultSequence(ResultSequence arg) throws DynamicError {
        ResultSequence carg = arg;
        ListIterator it = carg.iterator();
        while (it.hasNext()) {
            AnyType type = (AnyType)it.next();
            if (!type.string_type().equals("xs:untypedAtomic") && !type.string_type().equals("xs:string")) continue;
            throw DynamicError.invalidType();
        }
        carg = this.constructor(carg);
        return carg;
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        AnyType at = this.get_single_arg(carg);
        if (!(at instanceof XSDecimal)) {
            DynamicError.throw_type_error();
        }
        XSDecimal dt = (XSDecimal)at;
        return ResultSequenceFactory.create_new(new XSDecimal(this._value.subtract(dt.getValue())));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        BigDecimal result = this._value.multiply(val.getValue());
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    public ResultSequence div(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigDecimal result = this.getValue().divide(val.getValue(), 18, RoundingMode.HALF_EVEN);
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    public ResultSequence idiv(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigInteger _ivalue = this._value.toBigInteger();
        BigInteger ival = val.getValue().toBigInteger();
        BigInteger result = _ivalue.divide(ival);
        return ResultSequenceFactory.create_new(new XSInteger(result));
    }

    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        BigDecimal result = this._value.remainder(val.getValue());
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    public ResultSequence unary_minus() {
        BigDecimal result = this._value.negate();
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    public NumericType abs() {
        return new XSDecimal(this._value.abs());
    }

    public NumericType ceiling() {
        BigDecimal ceiling = this._value.setScale(0, RoundingMode.CEILING);
        return new XSDecimal(ceiling);
    }

    public NumericType floor() {
        BigDecimal floor = this._value.setScale(0, RoundingMode.FLOOR);
        return new XSDecimal(floor);
    }

    public NumericType round() {
        BigDecimal round = this._value.setScale(0, RoundingMode.UP);
        return new XSDecimal(round);
    }

    public NumericType round_half_to_even() {
        return this.round_half_to_even(0);
    }

    public NumericType round_half_to_even(int precision) {
        BigDecimal round = this._value.setScale(precision, RoundingMode.HALF_EVEN);
        return new XSDecimal(round);
    }
}

