/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public class FsPlus
extends Function {
    public FsPlus() {
        super(new QName("plus"), 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        return FsPlus.fs_plus(args);
    }

    private static Collection convert_args(Collection args) throws DynamicError {
        AnyType arg;
        ArrayList<ResultSequence> result = new ArrayList<ResultSequence>();
        boolean has_float = false;
        boolean has_double = false;
        Iterator i = args.iterator();
        while (i.hasNext()) {
            ResultSequence rs = FnData.atomize((ResultSequence)i.next());
            if (rs.empty()) {
                return new ArrayList();
            }
            if (rs.size() > 1) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            arg = rs.first();
            if (arg instanceof XSUntypedAtomic) {
                arg = new XSDouble(arg.string_value());
            }
            rs = ResultSequenceFactory.create_new();
            rs.add(arg);
            if (arg instanceof XSDouble) {
                has_double = true;
            }
            if (arg instanceof XSFloat) {
                has_float = true;
            }
            result.add(rs);
        }
        if (has_double) {
            has_float = false;
        }
        if (has_double || has_float) {
            for (ResultSequence rs : result) {
                arg = rs.first();
                if (has_double && arg instanceof XSFloat) {
                    arg = new XSDouble(((XSFloat)arg).float_value());
                } else if (has_double && arg instanceof XSDecimal) {
                    arg = new XSDouble(((XSDecimal)arg).getValue().doubleValue());
                } else if (has_float && arg instanceof XSDecimal) {
                    arg = new XSFloat(((XSDecimal)arg).getValue().floatValue());
                }
                if (rs.first() == arg) continue;
                rs.clear();
                rs.add(arg);
            }
        }
        return result;
    }

    public static ResultSequence fs_plus(Collection args) throws DynamicError {
        return FsPlus.do_math_op(args, MathPlus.class, "plus");
    }

    public static ResultSequence fs_plus_unary(Collection args) throws DynamicError {
        AnyType at;
        ResultSequence arg;
        if (args.size() != 1) {
            DynamicError.throw_type_error();
        }
        if ((arg = (ResultSequence)args.iterator().next()).size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!((at = arg.first()) instanceof NumericType)) {
            DynamicError.throw_type_error();
        }
        return arg;
    }

    public static ResultSequence do_math_op(Collection args, Class type, String mname) throws DynamicError {
        if (args.size() != 2) {
            DynamicError.throw_type_error();
        }
        Collection cargs = FsPlus.convert_args(args);
        ResultSequence result = ResultSequenceFactory.create_new();
        if (cargs.size() == 0) {
            return result;
        }
        Iterator argi = cargs.iterator();
        AnyType arg = ((ResultSequence)argi.next()).first();
        ResultSequence arg2 = (ResultSequence)argi.next();
        if (!type.isInstance(arg)) {
            DynamicError.throw_type_error();
        }
        try {
            Class[] margsdef = new Class[]{ResultSequence.class};
            Method method = null;
            method = type.getMethod(mname, margsdef);
            Object[] margs = new Object[]{arg2};
            return (ResultSequence)method.invoke((Object)arg, margs);
        }
        catch (NoSuchMethodException err) {
            System.out.println("NoSuchMethodException: " + err.getMessage());
            assert (false);
        }
        catch (IllegalAccessException err) {
            System.out.println("IllegalAccessException: " + err.getMessage());
            assert (false);
        }
        catch (InvocationTargetException err) {
            Throwable ex = err.getTargetException();
            if (ex instanceof DynamicError) {
                throw (DynamicError)ex;
            }
            ex.printStackTrace();
            System.exit(1);
        }
        return null;
    }
}

