/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import com.ibm.icu.text.Normalizer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnNormalizeUnicode
extends Function {
    private static Collection _expected_args = null;
    private static W3CNormalizer normalizer = null;

    public FnNormalizeUnicode() {
        super(new QName("normalize-unicode"), 1, 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnNormalizeUnicode.normalize_unicode(args, this.dynamic_context());
    }

    public static ResultSequence normalize_unicode(Collection args, DynamicContext d_context) throws DynamicError {
        assert (args.size() >= 1 && args.size() <= 2);
        Collection cargs = Function.convert_arguments(args, FnNormalizeUnicode.expected_args());
        Iterator cargsIterator = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)cargsIterator.next();
        String normalizationType = "NFC";
        if (cargsIterator.hasNext()) {
            ResultSequence arg2 = (ResultSequence)cargsIterator.next();
            normalizationType = arg2.empty() ? "" : ((XSString)arg2.first()).value().trim().toUpperCase();
        }
        String argument = "";
        if (!arg1.empty()) {
            argument = ((XSString)arg1.first()).value();
        }
        ResultSequence rs = ResultSequenceFactory.create_new();
        String normalized = normalizationType.equals("") ? argument : FnNormalizeUnicode.getNormalizer().normalize(argument, normalizationType);
        rs.add(new XSString(normalized));
        return rs;
    }

    private static W3CNormalizer getNormalizer() {
        if (normalizer == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            normalizer = FnNormalizeUnicode.createICUNormalizer(classLoader);
            if (normalizer == null) {
                normalizer = FnNormalizeUnicode.createJDKNormalizer(classLoader);
            }
            if (normalizer == null) {
                normalizer = new FailingNormalizer();
            }
        }
        return normalizer;
    }

    private static W3CNormalizer createJDKNormalizer(ClassLoader classLoader) {
        try {
            Class<?> normalizerClass = classLoader.loadClass("java.text.Normalizer");
            Class<?> formClass = classLoader.loadClass("java.text.Normalizer$Form");
            return new JDK6Normalizer(normalizerClass, formClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    private static W3CNormalizer createICUNormalizer(ClassLoader classLoader) {
        try {
            if (classLoader.loadClass("com.ibm.icu.text.Normalizer") != null) {
                return new ICUNormalizer();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSString(), 3));
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }

    static class FailingNormalizer
    implements W3CNormalizer {
        FailingNormalizer() {
        }

        public String normalize(String argument, String normalizationForm) throws DynamicError {
            throw DynamicError.unsupported_normalization_form("Can't normalize to form " + normalizationForm + ": No ICU Library or Java 6 found. 'normalize-unicode' requires either 'com.ibm.icu.text.Normalizer' or 'java.text.Normalizer' on the classpath");
        }
    }

    static class ICUNormalizer
    implements W3CNormalizer {
        private Map<String, Normalizer.Mode> modeMap = new HashMap<String, Normalizer.Mode>();

        ICUNormalizer() {
            this.modeMap.put("NFC", Normalizer.NFC);
            this.modeMap.put("NFD", Normalizer.NFD);
            this.modeMap.put("NFKC", Normalizer.NFKC);
            this.modeMap.put("NFKD", Normalizer.NFKD);
        }

        public String normalize(String argument, String normalizationForm) throws DynamicError {
            Normalizer.Mode mode = this.modeMap.get(normalizationForm);
            if (mode != null) {
                return Normalizer.normalize((String)argument, (Normalizer.Mode)mode);
            }
            throw DynamicError.unsupported_normalization_form(normalizationForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JDK6Normalizer
    implements W3CNormalizer {
        private Method normalizeMethod;
        private Map<String, Enum> formMap = new HashMap<String, Enum>();

        public JDK6Normalizer(Class<?> normalizerCls, Class<? extends Enum> formCls) throws SecurityException, NoSuchMethodException {
            Enum[] formConstants;
            this.normalizeMethod = normalizerCls.getMethod("normalize", CharSequence.class, formCls);
            Enum[] enumArray = formConstants = formCls.getEnumConstants();
            int n = formConstants.length;
            int n2 = 0;
            while (n2 < n) {
                Enum form = enumArray[n2];
                this.formMap.put(form.name(), form);
                ++n2;
            }
        }

        @Override
        public String normalize(String argument, String normalizationForm) throws DynamicError {
            Enum form = this.formMap.get(normalizationForm);
            if (form != null) {
                try {
                    return (String)this.normalizeMethod.invoke(null, argument, form);
                }
                catch (RuntimeException e) {
                    throw DynamicError.runtime_error("java.text.Normalizer.normalize(..., \"" + normalizationForm + "\")", e);
                }
                catch (IllegalAccessException e) {
                    throw DynamicError.runtime_error("java.text.Normalizer.normalize(..., \"" + normalizationForm + "\")", e);
                }
                catch (InvocationTargetException e) {
                    throw DynamicError.runtime_error("java.text.Normalizer.normalize(..., \"" + normalizationForm + "\")", e);
                }
            }
            throw DynamicError.unsupported_normalization_form(normalizationForm);
        }
    }

    public static interface W3CNormalizer {
        public String normalize(String var1, String var2) throws DynamicError;
    }
}

