/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.IStatusChangeListener;
import org.eclipse.birt.report.designer.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.birt.report.designer.ui.util.PixelConverter;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ResourceConfigurationBlock
extends OptionsConfigurationBlock {
    public static final String TITLE_LABEL = Messages.getString((String)"ResourecePreferencePage.title");
    public static final String FOLDER_LABEL = Messages.getString((String)"ResourecePreferencePage.folder");
    public static final String BROWSER_BUTTON = Messages.getString((String)"ResourecePreferencePage.select");
    public static final String OPEN_DIALOG_TITLE = Messages.getString((String)"ResourecePreferencePage.openDialogTitle");
    public static final String OPEN_DILAOG_MESSAGE = Messages.getString((String)"ResourecePreferencePage.openDialogMessage");
    public static final String DIRCTORY = "resource";
    public static final String DEFAULT_RESOURCE_FOLDER_DISPLAY = Messages.getString((String)"ResourecePreferencePage.defaultResourceFolder.dispaly");
    private Text resourceText;
    private final OptionsConfigurationBlock.Key PREF_RESOURCE = this.getReportKey("org.eclipse.birt.report.designer.ui.preferences.resourcestore");
    public static final String BUTTON_KEY = "buttons";
    private PixelConverter fPixelConverter;

    public ResourceConfigurationBlock(IStatusChangeListener context, IProject project) {
        super(context, ReportPlugin.getDefault(), project);
        this.setKeys(this.getKeys());
    }

    private OptionsConfigurationBlock.Key[] getKeys() {
        OptionsConfigurationBlock.Key[] keys = new OptionsConfigurationBlock.Key[]{this.PREF_RESOURCE};
        return keys;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite othersComposite = this.createBuildPathTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        othersComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private Composite createBuildPathTabContent(Composite parent) {
        Label title = new Label(parent, 0);
        title.setLayoutData((Object)new GridData(768));
        title.setText(TITLE_LABEL);
        new Label(parent, 0);
        Composite pageContent = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        pageContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        pageContent.setLayout((Layout)layout);
        this.resourceText = this.addTextField(pageContent, Messages.getString((String)"ResourecePreferencePage.folder"), this.PREF_RESOURCE, 0, 0);
        if (this.resourceText.getText().trim().equals(ReportPlugin.getDefault().getDefaultResourcePreference())) {
            this.resourceText.setText(DEFAULT_RESOURCE_FOLDER_DISPLAY);
        } else {
            String str = this.resourceText.getText().trim();
            try {
                IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
                str = mgr.performStringSubstitution(str);
            }
            catch (CoreException coreException) {
                str = this.resourceText.getText().trim();
            }
            File file = new File(str);
            if (!file.isAbsolute()) {
                this.resourceText.setText(this.processString(str));
            }
        }
        IDialogHelperProvider helperProvider = (IDialogHelperProvider)ElementAdapterManager.getAdapter(this, IDialogHelperProvider.class);
        IDialogHelper controlTypeHelper = null;
        if (helperProvider != null) {
            controlTypeHelper = helperProvider.createHelper(this, BUTTON_KEY);
        }
        if (controlTypeHelper != null) {
            controlTypeHelper.setContainer(this);
            controlTypeHelper.createContent(pageContent);
            controlTypeHelper.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ResourceConfigurationBlock.this.resourceText.setText(event.text);
                }
            });
        } else {
            new Label(pageContent, 0);
            Button browser = new Button(pageContent, 8);
            browser.setText(BROWSER_BUTTON);
            data = new GridData();
            browser.setLayoutData((Object)data);
            browser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                    dialog.setText(OPEN_DIALOG_TITLE);
                    dialog.setMessage(OPEN_DILAOG_MESSAGE);
                    String folderName = dialog.open();
                    if (folderName == null) {
                        return;
                    }
                    if (!(folderName = folderName.replace('\\', '/')).endsWith("/")) {
                        folderName = String.valueOf(folderName) + "/";
                    }
                    ResourceConfigurationBlock.this.resourceText.setText(folderName);
                }
            });
        }
        return pageContent;
    }

    private String processString(String str) {
        if (str.startsWith("${") && str.endsWith("}")) {
            return str;
        }
        File file = new File(str);
        String temp = file.getAbsolutePath();
        int index = temp.indexOf(str);
        if (index > 0 && !(str = temp.substring(index)).startsWith(File.separator)) {
            str = String.valueOf(File.separator) + str;
        }
        return String.valueOf(DEFAULT_RESOURCE_FOLDER_DISPLAY) + str;
    }

    protected void textChanged(Text textControl) {
        OptionsConfigurationBlock.Key key = (OptionsConfigurationBlock.Key)textControl.getData();
        String path = textControl.getText();
        if (path != null && textControl == this.resourceText && path.startsWith(DEFAULT_RESOURCE_FOLDER_DISPLAY)) {
            path = path.replaceFirst(DEFAULT_RESOURCE_FOLDER_DISPLAY, this.PREF_RESOURCE.getDefaultValue(this.fPref));
        }
        String oldValue = this.setValue(key, path);
        this.validateSettings(key, oldValue, path);
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        String[] segments;
        if (newValue == null) {
            return;
        }
        String[] stringArray = segments = new Path(newValue).segments();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            IStatus status = ResourcesPlugin.getWorkspace().validateName(segment, 2);
            if (!status.isOK()) {
                this.fContext.statusChanged(status);
                return;
            }
            ++n2;
        }
        this.fContext.statusChanged(null);
    }

    protected void updateText(Text curr) {
        OptionsConfigurationBlock.Key key = (OptionsConfigurationBlock.Key)curr.getData();
        String currValue = this.getValue(key);
        curr.setText(currValue);
        if (currValue != null && curr == this.resourceText) {
            String text = curr.getText().trim();
            if (text.equals(ReportPlugin.getDefault().getDefaultResourcePreference())) {
                curr.setText(DEFAULT_RESOURCE_FOLDER_DISPLAY);
            } else {
                File file = new File(text);
                if (!file.isAbsolute()) {
                    curr.setText(this.processString(text));
                }
            }
        }
    }
}

