/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.CDialogCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.property.widgets.DimensionBuilderDialog;
import org.eclipse.birt.report.designer.util.NumberUtil;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ComboBoxDimensionCellEditor
extends CDialogCellEditor {
    private CCombo comboBox;
    private String[] items;
    private Map itemKeyMap;
    private Map valueKeyMap;
    int selection;
    private static final int defaultStyle = 0;
    private Composite composite;
    private String unitName;
    private String[] units;
    private int inProcessing = 0;

    public ComboBoxDimensionCellEditor(Composite parent) {
        super(parent);
        this.setStyle(0);
    }

    public ComboBoxDimensionCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public ComboBoxDimensionCellEditor(Composite parent, String[] items, String[] values) {
        this(parent, items, values, 0);
    }

    public ComboBoxDimensionCellEditor(Composite parent, String[] items, int style) {
        this(parent, items, null, style);
    }

    public ComboBoxDimensionCellEditor(Composite parent, String[] items, String[] values, int style) {
        super(parent, style);
        if (items != null) {
            if (values != null) {
                assert (values.length == items.length);
                this.itemKeyMap = new HashMap();
                this.valueKeyMap = new HashMap();
                int i = 0;
                while (i < items.length) {
                    this.itemKeyMap.put(items[i], values[i]);
                    this.valueKeyMap.put(values[i], items[i]);
                    ++i;
                }
            }
            Arrays.sort(items);
        }
        this.setItems(items);
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    protected Control createContents(Composite cell) {
        Color bg = cell.getBackground();
        cell.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxDimensionCellEditor.this.focusLost();
            }
        });
        this.composite = new Composite(cell, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new FillLayout());
        this.comboBox = new CCombo(this.composite, 0);
        this.comboBox.setVisibleItemCount(30);
        this.comboBox.setBackground(bg);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ComboBoxDimensionCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                ComboBoxDimensionCellEditor.this.selection = ComboBoxDimensionCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ComboBoxDimensionCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxDimensionCellEditor.this.focusLost();
            }
        });
        this.comboBox.getListeners(25);
        return this.composite;
    }

    void applyEditorValueAndDeactivate() {
        this.inProcessing = 1;
        this.doValueChanged();
        this.fireApplyEditorValue();
        this.deactivate();
        this.inProcessing = 0;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        DimensionValue value;
        DimensionBuilderDialog dialog = new DimensionBuilderDialog(cellEditorWindow.getShell());
        try {
            value = StringUtil.parseInput((String)this.comboBox.getText(), (ULocale)ULocale.getDefault());
        }
        catch (PropertyValueException propertyValueException) {
            value = null;
        }
        dialog.setUnitNames(this.units);
        dialog.setUnitName(this.unitName);
        if (value != null) {
            dialog.setMeasureData(new Double(value.getMeasure()));
        }
        if (dialog.open() == 0) {
            this.deactivate();
            String newValue = null;
            Double doubleValue = 0.0;
            if (dialog.getMeasureData() instanceof Double) {
                doubleValue = (Double)dialog.getMeasureData();
            } else if (dialog.getMeasureData() instanceof DimensionValue) {
                doubleValue = ((DimensionValue)dialog.getMeasureData()).getMeasure();
            }
            DimensionValue dValue = new DimensionValue(doubleValue.doubleValue(), dialog.getUnitName());
            newValue = dValue.toDisplayString();
            return newValue;
        }
        this.comboBox.setFocus();
        return null;
    }

    protected void updateContents(Object value) {
        String item;
        if (this.comboBox == null) {
            return;
        }
        String text = "";
        if (value != null) {
            if (value instanceof String) {
                DimensionValue dValue;
                try {
                    dValue = StringUtil.parseInput((String)((String)value), (ULocale)ULocale.getDefault());
                }
                catch (PropertyValueException propertyValueException) {
                    dValue = null;
                }
                text = dValue != null ? String.valueOf(NumberUtil.double2LocaleNum((double)dValue.getMeasure())) + dValue.getUnits() : value.toString();
            } else {
                text = value.toString();
            }
        }
        int index = -1;
        if (this.valueKeyMap != null && (item = (String)this.valueKeyMap.get(value)) != null) {
            index = this.comboBox.indexOf(item);
        }
        if (index >= 0) {
            text = this.comboBox.getItem(index);
        }
        this.comboBox.setText(text);
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.character == '\r') {
            this.applyEditorValueAndDeactivate();
        }
    }

    public void setUnits(String units) {
        this.unitName = units;
    }

    public void setUnitsList(String[] unitsList) {
        this.units = unitsList;
    }

    protected void focusLost() {
        if (this.inProcessing == 1) {
            return;
        }
        super.focusLost();
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected void doValueChanged() {
        boolean newValidState;
        String comboText = this.comboBox.getText();
        if (this.comboBox.indexOf(comboText) >= 0) {
            int index = this.comboBox.indexOf(comboText);
            this.comboBox.select(index);
        }
        if (this.selection != this.comboBox.getSelectionIndex()) {
            this.markDirty();
        }
        this.selection = this.comboBox.getSelectionIndex();
        String newValue = null;
        if (this.selection == -1) {
            DimensionValue dValue;
            Object oldValue = this.doGetValue();
            if (oldValue != null && oldValue instanceof String) {
                oldValue = this.parseString2dValue((String)oldValue);
            }
            if ((dValue = this.parseString2dValue(newValue = this.comboBox.getText())) != null) {
                newValue = dValue.toDisplayString();
            }
            if (dValue != null && !dValue.equals(oldValue)) {
                this.markDirty();
                this.doSetValue(newValue);
                return;
            }
        } else {
            newValue = this.itemKeyMap != null ? this.itemKeyMap.get(this.comboBox.getItem(this.selection)) : this.comboBox.getItem(this.selection);
        }
        if (newValue != null && (newValidState = this.isCorrect(newValue))) {
            this.doSetValue(newValue);
            this.markDirty();
        }
    }

    private DimensionValue parseString2dValue(String strValue) {
        DimensionValue dValue = null;
        try {
            dValue = StringUtil.parseInput((String)strValue, (ULocale)ULocale.getDefault());
        }
        catch (PropertyValueException propertyValueException) {
            dValue = null;
        }
        return dValue;
    }
}

