/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataColumnBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.ISortingFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;

public class DataSetColumnBindingsFormHandleProvider
implements ISortingFormHandleProvider {
    protected static final Logger logger = Logger.getLogger(DataSetColumnBindingsFormHandleProvider.class.getName());
    private static final String ALL = Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.ALL");
    private static final String NONE = Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.NONE");
    private String[] columnNames;
    private ReportElementHandle bindingObject;
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    private boolean canAggregation = true;
    private TableViewer viewer;
    private int sortingColumnIndex;
    private int sortDirection = 128;

    public DataSetColumnBindingsFormHandleProvider() {
    }

    public DataSetColumnBindingsFormHandleProvider(boolean canAggregation) {
        this.canAggregation = canAggregation;
    }

    public ReportElementHandle getBindingObject() {
        return this.bindingObject;
    }

    public void setBindingObject(ReportElementHandle bindingObject) {
        this.bindingObject = bindingObject;
    }

    public String[] getColumnNames() {
        this.columnNames = this.canAggregation ? new String[]{Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Name"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DisplayNameID"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DisplayName"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DataType"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Expression"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Function"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Filter"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.AggregateOn")} : new String[]{Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Name"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DisplayNameID"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DisplayName"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DataType"), Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Expression")};
        return this.columnNames;
    }

    public int[] getColumnWidths() {
        if (this.canAggregation) {
            return new int[]{120, 120, 120, 80, 120, 100, 120, 120};
        }
        return new int[]{150, 150, 150, 150, 150};
    }

    public String getTitle() {
        if (this.isEditable()) {
            return Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.DatasetTitle");
        }
        return Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.ReportItemTitle");
    }

    public boolean isEditable() {
        if (this.bindingObject == null) {
            return false;
        }
        if (((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.bindingObject)).getDataBindingType() == 2) {
            return false;
        }
        if (((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.bindingObject)).getDataBindingType() == 0) {
            return DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.bindingObject)), (boolean)true) == null || DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.bindingObject)), (boolean)true).getDataBindingType() != 2;
        }
        return true;
    }

    public boolean doDeleteItem(int pos) throws Exception {
        int modelPos = this.getOriginalIndex(pos);
        if (modelPos > -1 && this.bindingObject instanceof ReportItemHandle) {
            ((ReportItemHandle)this.bindingObject).getColumnBindings().getAt(modelPos).drop();
            if (this.viewer != null) {
                this.viewer.refresh(true);
                if (pos - 1 > -1 || this.viewer.getTable().getItemCount() == 0) {
                    this.viewer.getTable().setSelection(pos - 1);
                } else {
                    this.viewer.getTable().setSelection(0);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean doAddItem(int pos) throws Exception {
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
        dialog.setInput((ReportItemHandle)this.bindingObject);
        if (dialog.open() == 0 && this.viewer != null) {
            this.viewer.refresh(true);
            return true;
        }
        return false;
    }

    public boolean doEditItem(int pos) {
        ComputedColumnHandle bindingHandle = null;
        if ((pos = this.getOriginalIndex(pos)) > -1 && this.bindingObject instanceof ReportItemHandle) {
            bindingHandle = (ComputedColumnHandle)((ReportItemHandle)this.bindingObject).getColumnBindings().getAt(pos);
        }
        if (bindingHandle == null) {
            return false;
        }
        boolean isResultSetColumn = false;
        String resultSetName = null;
        if (this.bindingObject instanceof DataItemHandle) {
            resultSetName = ((DataItemHandle)this.bindingObject).getResultSetColumn();
        }
        if (resultSetName != null && bindingHandle.getName().equals(resultSetName)) {
            isResultSetColumn = true;
        }
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(false);
        dialog.setInput((ReportItemHandle)this.bindingObject, bindingHandle);
        if (dialog.open() == 0) {
            if (isResultSetColumn) {
                try {
                    ((DataItemHandle)this.bindingObject).setResultSetColumn(bindingHandle.getName());
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
            }
            if (this.viewer != null) {
                this.viewer.refresh(true);
                return true;
            }
        }
        return false;
    }

    public int getOriginalIndex(int pos) {
        ArrayList children = new ArrayList();
        Iterator iter = ((ReportItemHandle)this.bindingObject).getColumnBindings().iterator();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        Object[] arrays = children.toArray();
        Arrays.sort(arrays, new BindingComparator());
        return children.indexOf(Arrays.asList(arrays).get(pos));
    }

    public int getShowIndex(int pos) {
        ArrayList children = new ArrayList();
        Iterator iter = ((ReportItemHandle)this.bindingObject).getColumnBindings().iterator();
        while (iter.hasNext()) {
            children.add(iter.next());
        }
        Object[] arrays = children.toArray();
        Arrays.sort(arrays, new BindingComparator());
        return Arrays.asList(arrays).indexOf(children.get(pos));
    }

    public String getColumnText(Object element, int columnIndex) {
        ComputedColumnHandle handle = (ComputedColumnHandle)element;
        String text = null;
        switch (columnIndex) {
            case 0: {
                text = handle.getName();
                break;
            }
            case 1: {
                text = handle.getDisplayNameID();
                break;
            }
            case 2: {
                text = handle.getDisplayName();
                break;
            }
            case 3: {
                text = ChoiceSetFactory.getDisplayNameFromChoiceSet(handle.getDataType(), DATA_TYPE_CHOICE_SET);
                break;
            }
            case 4: {
                text = DataUtil.getAggregationExpression(handle);
                break;
            }
            case 5: {
                try {
                    String function = handle.getAggregateFunction();
                    if (function != null && (function = DataAdapterUtil.adaptModelAggregationType((String)function)) != null && DataUtil.getAggregationManager().getAggregation(function) != null) {
                        return DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
                    }
                }
                catch (BirtException e) {
                    ExceptionHandler.handle(e);
                }
                break;
            }
            case 6: {
                text = handle.getFilterExpression();
                break;
            }
            case 7: {
                String value = DEUtil.getAggregateOn((ComputedColumnHandle)handle);
                if (value == null) {
                    if (handle.getAggregateFunction() != null) {
                        text = ALL;
                        break;
                    }
                    text = NONE;
                    break;
                }
                text = value;
            }
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[] && ((Object[])inputElement).length > 0) {
            return this.getElements(((Object[])inputElement)[0]);
        }
        if (inputElement instanceof List) {
            return this.getElements(((List)inputElement).get(0));
        }
        if (inputElement instanceof ReportItemHandle) {
            ReportItemHandle reportHandle = DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)inputElement));
            this.bindingObject = reportHandle;
            ArrayList children = new ArrayList();
            if (reportHandle != null) {
                Iterator iter = reportHandle.getColumnBindings().iterator();
                while (iter.hasNext()) {
                    children.add(iter.next());
                }
            }
            Object[] arrays = children.toArray();
            Arrays.sort(arrays, new BindingComparator());
            return arrays;
        }
        return new Object[0];
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean needRefreshed(NotificationEvent event) {
        PropertyEvent ev;
        String propertyName;
        return event.getEventType() == 5 && ("boundDataColumns".equals(propertyName = (ev = (PropertyEvent)event).getPropertyName()) || "dataSet".equals(propertyName) || "dataBindingRef".equals(propertyName));
    }

    public void generateAllBindingColumns() {
        if (this.bindingObject != null) {
            ReportItemHandle root;
            DataSetHandle datasetHandle = null;
            if (this.bindingObject instanceof ReportItemHandle) {
                root = DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)this.bindingObject));
                if (root != null) {
                    datasetHandle = root.getDataSet();
                }
            } else if (this.bindingObject instanceof GroupHandle && (root = DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)((GroupHandle)this.bindingObject).getContainer()))) != null) {
                datasetHandle = root.getDataSet();
            }
            if (datasetHandle != null) {
                try {
                    CachedMetaDataHandle cmdh = DataSetUIUtil.getCachedMetaDataHandle(datasetHandle);
                    for (ResultSetColumnHandle element : cmdh.getResultSet()) {
                        ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)this.bindingObject, (String)element.getColumnName());
                        bindingColumn.setDataType(element.getDataType());
                        String groupType = DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject);
                        List groupList = DEUtil.getGroups((DesignElementHandle)this.bindingObject);
                        ExpressionUtility.setBindingColumnExpression(element, bindingColumn);
                        if (this.bindingObject instanceof ReportItemHandle) {
                            ((ReportItemHandle)this.bindingObject).addColumnBinding(bindingColumn, false);
                            continue;
                        }
                        if (!ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) continue;
                        if (groupType.equals("group")) {
                            bindingColumn.setAggregateOn(((GroupHandle)groupList.get(0)).getName());
                            continue;
                        }
                        if (!groupType.equals("listing")) continue;
                        bindingColumn.setAggregateOn(null);
                    }
                    this.generateOutputParmsBindings(datasetHandle);
                }
                catch (SemanticException semanticException) {}
            }
        }
    }

    private void generateOutputParmsBindings(DataSetHandle datasetHandle) {
        ArrayList<DataSetParameterHandle> outputParams = new ArrayList<DataSetParameterHandle>();
        Iterator iter = datasetHandle.parametersIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof DataSetParameterHandle) || !((DataSetParameterHandle)obj).isOutput()) continue;
            outputParams.add((DataSetParameterHandle)obj);
        }
        int ret = -1;
        if (outputParams.size() > 0) {
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.generateOutputParam"), null, Messages.getString((String)"dataBinding.msg.generateOutputParam"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No")}, 0);
            ret = prefDialog.open();
        }
        if (ret == 0) {
            int i = 0;
            while (i < outputParams.size()) {
                DataSetParameterHandle param = (DataSetParameterHandle)outputParams.get(i);
                ComputedColumn bindingColumn = StructureFactory.newComputedColumn((DesignElementHandle)this.bindingObject, (String)param.getName());
                bindingColumn.setDataType(param.getDataType());
                String groupType = DEUtil.getGroupControlType((DesignElementHandle)this.bindingObject);
                List groupList = DEUtil.getGroups((DesignElementHandle)this.bindingObject);
                ExpressionUtility.setBindingColumnExpression(param, bindingColumn, true);
                if (this.bindingObject instanceof ReportItemHandle) {
                    try {
                        ((ReportItemHandle)this.bindingObject).addColumnBinding(bindingColumn, false);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                } else if (ExpressionUtil.hasAggregation((String)bindingColumn.getExpression())) {
                    if (groupType.equals("group")) {
                        bindingColumn.setAggregrateOn(((GroupHandle)groupList.get(0)).getName());
                    } else if (groupType.equals("listing")) {
                        bindingColumn.setAggregrateOn(null);
                    }
                }
                ++i;
            }
        }
    }

    public void removedUnusedColumnBindings(List inputElement) {
        Object element;
        if (inputElement.size() > 0 && (element = inputElement.get(0)) instanceof ReportElementHandle) {
            try {
                if (element instanceof GroupHandle) {
                    DesignElementHandle parentHandle = ((GroupHandle)element).getContainer();
                    if (parentHandle instanceof ReportItemHandle) {
                        ((ReportItemHandle)parentHandle).removedUnusedColumnBindings();
                    }
                } else if (element instanceof ReportItemHandle) {
                    ((ReportItemHandle)element).removedUnusedColumnBindings();
                }
            }
            catch (SemanticException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void setTableViewer(TableViewer viewer) {
        this.viewer = viewer;
    }

    public boolean canAggregation() {
        return this.canAggregation;
    }

    public void addAggregateOn(int pos) throws Exception {
        boolean sucess = false;
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        try {
            sucess = this.doAddAggregateOnItem(pos);
        }
        catch (Exception e) {
            stack.rollback();
            throw new Exception(e);
        }
        if (sucess) {
            stack.commit();
        } else {
            stack.rollback();
        }
    }

    public boolean doAddAggregateOnItem(int pos) {
        DataColumnBindingDialog dialog = new DataColumnBindingDialog(true);
        dialog.setAggreate(true);
        dialog.setInput((ReportItemHandle)this.getBindingObject());
        if (dialog.open() == 0 && this.viewer != null) {
            this.viewer.refresh(true);
            return true;
        }
        return false;
    }

    protected CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    public void setSortingColumnIndex(int index) {
        this.sortingColumnIndex = index;
    }

    public void setSortDirection(int dir) {
        this.sortDirection = dir;
    }

    private class BindingComparator
    implements Comparator {
        private BindingComparator() {
        }

        public int compare(Object o1, Object o2) {
            ComputedColumnHandle binding1 = (ComputedColumnHandle)o1;
            ComputedColumnHandle binding2 = (ComputedColumnHandle)o2;
            String columnText1 = DataSetColumnBindingsFormHandleProvider.this.getColumnText(binding1, DataSetColumnBindingsFormHandleProvider.this.sortingColumnIndex);
            String columnText2 = DataSetColumnBindingsFormHandleProvider.this.getColumnText(binding2, DataSetColumnBindingsFormHandleProvider.this.sortingColumnIndex);
            int result = (columnText1 == null ? "" : columnText1).compareTo(columnText2 == null ? "" : columnText2);
            if (DataSetColumnBindingsFormHandleProvider.this.sortDirection == 128) {
                return result;
            }
            return 0 - result;
        }
    }
}

