/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.RenameInputDialog;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewerAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ContentElementHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public class RenameAction
extends AbstractViewerAction {
    public static final String TEXT = Messages.getString((String)"RenameAction.text");
    private TreeItem selectedItem;
    private String originalName;
    private static final String ERROR_TITLE = Messages.getString((String)"RenameInlineTool.DialogTitle.RenameFailed");
    private static final String TRANS_LABEL = Messages.getString((String)"RenameInlineTool.TransLabel.Rename");

    public RenameAction(TreeViewer sourceViewer) {
        this(sourceViewer, TEXT);
    }

    public RenameAction(TreeViewer sourceViewer, String text) {
        super(sourceViewer, text);
        this.setAccelerator(0x100000B);
        if (this.isEnabled()) {
            this.selectedItem = this.getSelectedItems()[0];
        }
    }

    public boolean isEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object obj = super.getSelectedObjects().getFirstElement();
        if (obj instanceof EmbeddedImageHandle) {
            return true;
        }
        if (obj instanceof ReportElementHandle) {
            if (obj instanceof GroupHandle) {
                return !((GroupHandle)obj).getPropertyHandle("groupName").isReadOnly();
            }
            return ((ReportElementHandle)obj).getDefn().getNameOption() != 0 && ((ReportElementHandle)obj).canEdit();
        }
        if (obj instanceof ContentElementHandle) {
            return ((ContentElementHandle)obj).getDefn().getNameOption() != 0 && ((ContentElementHandle)obj).canEdit();
        }
        return false;
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Rename action >> Runs with " + DEUtil.getDisplayLabel((Object)this.getSelectedObjects().getFirstElement()));
        }
        this.doRename();
    }

    private void doRename() {
        if (this.selectedItem.getData() instanceof DesignElementHandle || this.selectedItem.getData() instanceof EmbeddedImageHandle) {
            this.initOriginalName();
            RenameInputDialog inputDialog = new RenameInputDialog(this.selectedItem.getParent().getShell(), Messages.getString((String)"RenameInputDialog.DialogTitle"), Messages.getString((String)"RenameInputDialog.DialogMessage"), this.originalName, "org.eclipse.birt.cshelp.RenameInputDialog_ID");
            inputDialog.create();
            if (inputDialog.open() == 0) {
                this.saveChanges(inputDialog.getResult().toString().trim());
            }
        }
    }

    private void initOriginalName() {
        if (this.selectedItem.getData() instanceof DesignElementHandle) {
            this.originalName = ((DesignElementHandle)this.selectedItem.getData()).getName();
        }
        if (this.selectedItem.getData() instanceof EmbeddedImageHandle) {
            this.originalName = ((EmbeddedImageHandle)this.selectedItem.getData()).getName();
        }
        if (this.originalName == null) {
            this.originalName = "";
        }
    }

    private void saveChanges(String newName) {
        if (!newName.equals(this.originalName) && !this.rename(this.selectedItem.getData(), newName)) {
            this.doRename();
            return;
        }
    }

    private boolean rename(Object handle, String newName) {
        if (newName.length() == 0) {
            newName = null;
        }
        if (SessionHandleAdapter.getInstance().getReportDesignHandle() == null) {
            return false;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(String.valueOf(TRANS_LABEL) + " " + DEUtil.getDisplayLabel((Object)handle));
        try {
            if (handle instanceof DesignElementHandle) {
                ((DesignElementHandle)handle).setName(newName);
            }
            if (handle instanceof EmbeddedImageHandle) {
                ((EmbeddedImageHandle)handle).setName(newName);
            }
            stack.commit();
        }
        catch (NameException e) {
            ExceptionHandler.handle(e, ERROR_TITLE, e.getLocalizedMessage());
            stack.rollback();
            return false;
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e, ERROR_TITLE, e.getLocalizedMessage());
            stack.rollback();
            return true;
        }
        return true;
    }
}

