/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.TableBorderHelper;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutCell;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixTableLayout
extends TableLayout {
    private static final int ALLOW_ROW_HEIGHT = 1;
    private static final int ALLOW_COLOUMN_WIDTH = 1;
    public static final int DEFAULT_ROW_HEIGHT = 16;

    public FixTableLayout(ITableLayoutOwner part) {
        super(part);
    }

    @Override
    public void layout(IFigure container) {
        if (!this.isDistroy()) {
            return;
        }
        ITableLayoutOwner owner = this.getOwner();
        this.helper = new TableBorderHelper(owner);
        this.helper.updateCellBorderInsets();
        this.data = new TableLayout.WorkingData();
        this.data.columnWidths = new TableLayoutData.ColumnData[this.getColumnCount()];
        this.data.rowHeights = new TableLayoutData.RowData[this.getRowCount()];
        List children = container.getChildren();
        this.init(this.data.columnWidths, this.data.rowHeights);
        this.initFigureInfo(children);
        this.caleColumnWidth();
        this.preCaleRow();
        this.layoutTable(container);
        this.resetRowMinSize(this.data.rowHeights);
        this.initRowMinSize(children);
        this.initRowMergeMinsize(children);
        this.caleRowData();
        this.layoutTable(container);
        this.setConstraint(container, this.data);
        this.needlayout = false;
        int containerWidth = this.getOwner().getFigure().getParent().getClientArea().getSize().width;
        if (containerWidth < 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    FixTableLayout.this.getOwner().reLayout();
                }
            });
            return;
        }
        this.reselect();
    }

    private void caleRowData() {
        if (this.data == null) {
            return;
        }
        int size = this.data.rowHeights.length;
        int[] dxRows = new int[size];
        int i = 0;
        while (i < size) {
            dxRows[i] = this.data.rowHeights[i].height - this.data.rowHeights[i].trueMinRowHeight;
            ++i;
        }
        i = 0;
        while (i < size) {
            if (dxRows[i] < 0 && !this.data.rowHeights[i].isForce) {
                this.data.rowHeights[i].height = this.data.rowHeights[i].trueMinRowHeight;
            }
            ++i;
        }
        String dw = this.getOwner().getDefinedHeight();
        if (dw == null) {
            return;
        }
        int rowHeight = this.getDefinedHeight(dw, 0);
        if (rowHeight <= 0) {
            return;
        }
        int forceTotal = 0;
        int forceCount = size;
        ArrayList<TableLayoutData.RowData> noSettingList = new ArrayList<TableLayoutData.RowData>();
        int i2 = 0;
        while (i2 < size) {
            if (this.data.rowHeights[i2].isForce) {
                --forceCount;
            } else if (!this.data.rowHeights[i2].isSetting) {
                this.data.rowHeights[i2].height = 1;
                noSettingList.add(this.data.rowHeights[i2]);
            }
            forceTotal += this.data.rowHeights[i2].height;
            ++i2;
        }
        if (forceTotal >= rowHeight) {
            i2 = 0;
            while (i2 < size) {
                TableLayoutData.RowData rData = this.data.rowHeights[i2];
                if (!rData.isSetting) {
                    rData.height = 1;
                    rData.trueMinRowHeight = 1;
                }
                ++i2;
            }
        } else {
            int moreWith = rowHeight - forceTotal;
            if (forceCount == 0) {
                int argaWith = moreWith / size;
                int others = moreWith % size;
                int i3 = 0;
                while (i3 < size) {
                    TableLayoutData.RowData rData = this.data.rowHeights[i3];
                    rData.height = i3 <= others - 1 ? rData.height + argaWith + 1 : (rData.height += argaWith);
                    ++i3;
                }
            } else {
                int noSettingSize = noSettingList.size();
                if (moreWith < noSettingSize * 15) {
                    int argaWith = moreWith / noSettingSize;
                    int others = moreWith % noSettingSize;
                    int i4 = 0;
                    while (i4 < noSettingList.size()) {
                        TableLayoutData.RowData adjust = (TableLayoutData.RowData)noSettingList.get(i4);
                        adjust.height = i4 <= others - 1 ? adjust.height + argaWith + 1 : (adjust.height += argaWith);
                        ++i4;
                    }
                } else {
                    int i5 = 0;
                    while (i5 < noSettingList.size()) {
                        TableLayoutData.RowData adjust = (TableLayoutData.RowData)noSettingList.get(i5);
                        adjust.height = 16;
                        ++i5;
                    }
                    int argaWith = (moreWith -= noSettingSize * 15) / forceCount;
                    int others = moreWith % forceCount;
                    ArrayList<TableLayoutData.RowData> adjustList = new ArrayList<TableLayoutData.RowData>();
                    int i6 = 0;
                    while (i6 < size) {
                        TableLayoutData.RowData rData = this.data.rowHeights[i6];
                        if (!rData.isForce) {
                            adjustList.add(rData);
                        }
                        ++i6;
                    }
                    i6 = 0;
                    while (i6 < adjustList.size()) {
                        TableLayoutData.RowData adjust = (TableLayoutData.RowData)adjustList.get(i6);
                        adjust.height = i6 <= others - 1 ? adjust.height + argaWith + 1 : (adjust.height += argaWith);
                        ++i6;
                    }
                }
            }
        }
    }

    private void getOtioseRow(List<TableLayoutData.RowData> rows, int forceCount, int width) {
    }

    private int getDefinedHeight(String dw, int cw) {
        if (dw == null || dw.length() == 0) {
            return 0;
        }
        try {
            if (dw.endsWith("%")) {
                return (int)(Double.parseDouble(dw.substring(0, dw.length() - 1)) * (double)cw / 100.0);
            }
            return (int)Double.parseDouble(dw);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void initRowMergeMinsize(List children) {
        int size = children.size();
        this.getOwner().getViewer().getVisualPartMap();
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        ArrayList<Integer> adjustRow = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)children.get(i);
            TableLayout.FigureInfomation info = (TableLayout.FigureInfomation)this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            int rowSpan = info.rowSpan;
            if (rowSpan != 1 && figure.getChildren().size() != 0) {
                list.add(figure);
                if (rowSpan > 1) {
                    int j = rowNumber;
                    while (j < rowNumber + rowSpan) {
                        this.data.findRowData(j);
                        if (!adjustRow.contains(j)) {
                            adjustRow.add(j);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        ArrayList<Integer> hasAdjust = new ArrayList<Integer>();
        size = this.data.rowHeights.length;
        int[] cfr_ignored_0 = new int[size];
        int i2 = 0;
        while (i2 < size) {
            if (this.data.rowHeights[i2].isForce) {
                hasAdjust.add(this.data.rowHeights[i2].rowNumber);
            }
            ++i2;
        }
        this.caleRowMergeMinHeight(list, adjustRow, hasAdjust);
    }

    private void caleRowMergeMinHeight(List figures, List adjust, List hasAdjust) {
        if (adjust.isEmpty()) {
            return;
        }
        int size = figures.size();
        this.getOwner().getViewer().getVisualPartMap();
        int trueAdjustMax = 0;
        int adjustMaxNumber = 0;
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)figures.get(i);
            TableLayout.FigureInfomation info = (TableLayout.FigureInfomation)this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            int rowSpan = info.rowSpan;
            int colWith = this.getColumnWith(info.columnNumber, info.columnSpan);
            Dimension minSize = figure.getMinimumSize(colWith, -1);
            int samMin = 0;
            int trueSamMin = 0;
            int[] adjustNumber = new int[]{};
            int j = rowNumber;
            while (j < rowNumber + rowSpan) {
                TableLayoutData.RowData rowData = this.data.findRowData(j);
                if (!hasAdjust.contains(j)) {
                    int len = adjustNumber.length;
                    int[] temp = new int[len + 1];
                    System.arraycopy(adjustNumber, 0, temp, 0, len);
                    temp[len] = j;
                    adjustNumber = temp;
                } else {
                    samMin += rowData.trueMinRowHeight;
                    trueSamMin += rowData.trueMinRowHeight;
                }
                if (!rowData.isSetting) {
                    rowData.height = 1;
                }
                ++j;
            }
            int adjustCount = adjustNumber.length;
            if (adjustCount != 0) {
                int value = minSize.height - samMin;
                int trueValue = minSize.height - trueSamMin;
                int j2 = 0;
                while (j2 < adjustCount) {
                    int temp = 0;
                    int trueTemp = 0;
                    TableLayoutData.RowData rowData = this.data.findRowData(adjustNumber[j2]);
                    if (rowData.isForce) {
                        temp = rowData.minRowHeight;
                        trueTemp = rowData.trueMinRowHeight;
                    } else {
                        int otioseValue = value % adjustCount;
                        int trueOtioseValue = trueValue % adjustCount;
                        temp = j2 <= otioseValue - 1 ? value / adjustCount + 1 : value / adjustCount;
                        trueTemp = j2 <= trueOtioseValue - 1 ? trueValue / adjustCount + 1 : trueValue / adjustCount;
                    }
                    temp = Math.max(temp, rowData.minRowHeight);
                    trueTemp = Math.max(trueTemp, rowData.trueMinRowHeight);
                    if (trueTemp > trueAdjustMax) {
                        trueAdjustMax = trueTemp;
                        adjustMaxNumber = adjustNumber[j2];
                    }
                    ++j2;
                }
            }
            ++i;
        }
        if (adjustMaxNumber > 0) {
            TableLayoutData.RowData rowData = this.data.findRowData(adjustMaxNumber);
            rowData.trueMinRowHeight = trueAdjustMax;
            rowData.isSetting = true;
            adjust.remove((Object)adjustMaxNumber);
            hasAdjust.add(adjustMaxNumber);
            this.caleRowMergeMinHeight(figures, adjust, hasAdjust);
        }
    }

    private void initRowMinSize(List children) {
        int size = children.size();
        this.getOwner().getViewer().getVisualPartMap();
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)children.get(i);
            TableLayout.FigureInfomation info = (TableLayout.FigureInfomation)this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            TableLayoutData.RowData rowData = this.data.findRowData(rowNumber);
            if (!rowData.isForce) {
                int columnNumber = info.columnNumber;
                int columnSpan = info.columnSpan;
                int rowSpan = info.rowSpan;
                if (rowSpan == 1) {
                    int colWidth = this.getColumnWith(columnNumber, columnSpan);
                    Dimension dim = figure.getMinimumSize(colWidth, -1);
                    if (rowData.isSetting) {
                        if (dim.height > rowData.trueMinRowHeight) {
                            rowData.trueMinRowHeight = dim.height;
                            rowData.isSetting = true;
                        }
                    } else if (figure.getChildren().size() > 0) {
                        if (dim.height > rowData.trueMinRowHeight) {
                            rowData.trueMinRowHeight = dim.height;
                        }
                        rowData.height = 1;
                        rowData.isSetting = true;
                    }
                }
            }
            ++i;
        }
    }

    private int getColumnWith(int columnNumber, int columnSpan) {
        TableLayoutData.ColumnData columnData = this.data.findColumnData(columnNumber);
        int colWidth = columnData.width;
        if (columnSpan > 1) {
            int k = 1;
            while (k < columnSpan) {
                TableLayoutData.ColumnData cData = this.data.findColumnData(columnNumber + k);
                if (cData != null) {
                    colWidth += cData.width;
                }
                ++k;
            }
        }
        return colWidth;
    }

    private void preCaleRow() {
        int size = this.data.rowHeights.length;
        int[] dxRows = new int[size];
        int i = 0;
        while (i < size) {
            dxRows[i] = this.data.rowHeights[i].height - this.data.rowHeights[i].trueMinRowHeight;
            ++i;
        }
        i = 0;
        while (i < size) {
            if (dxRows[i] < 0) {
                this.data.rowHeights[i].height = this.data.rowHeights[i].trueMinRowHeight;
            }
            ++i;
        }
    }

    private void debugColumn() {
        System.out.println("//////////start//////////");
        int containerWidth = this.getLayoutWidth();
        System.out.println("container width===" + containerWidth);
        int size = this.data.columnWidths.length;
        int i = 0;
        while (i < size) {
            TableLayoutData.ColumnData cData = this.data.columnWidths[i];
            System.out.println("column " + (i + 1) + "===" + cData.width);
            ++i;
        }
    }

    private void caleColumnWidth() {
        TableLayoutData.ColumnData cData;
        int size = this.data.columnWidths.length;
        int containerWidth = this.getLayoutWidth();
        containerWidth = Math.max(0, containerWidth);
        int totalColumn = 0;
        int forceCount = size;
        int percentageTotal = 0;
        int forceTotal = 0;
        double percentageValueTotal = 0.0;
        int i = 0;
        while (i < size) {
            cData = this.data.columnWidths[i];
            if (cData.isPercentage) {
                cData.trueMinColumnWidth = (int)((double)containerWidth * cData.percentageWidth / 100.0);
                totalColumn += cData.trueMinColumnWidth;
                percentageTotal += cData.trueMinColumnWidth;
                percentageValueTotal += cData.percentageWidth;
                cData.width = cData.trueMinColumnWidth;
                --forceCount;
            } else if (cData.isForce) {
                totalColumn += cData.trueMinColumnWidth;
                forceTotal += cData.trueMinColumnWidth;
                cData.width = cData.trueMinColumnWidth;
                --forceCount;
            }
            ++i;
        }
        if (percentageTotal > 0 && containerWidth - forceTotal < percentageTotal) {
            percentageTotal = 0;
            int widthMore = containerWidth - forceTotal;
            int i2 = 0;
            while (i2 < size) {
                TableLayoutData.ColumnData cData2 = this.data.columnWidths[i2];
                if (cData2.isPercentage) {
                    cData2.trueMinColumnWidth = widthMore < 0 ? 1 : (int)((double)widthMore * cData2.percentageWidth / percentageValueTotal);
                    percentageTotal += cData2.trueMinColumnWidth;
                    cData2.width = cData2.trueMinColumnWidth;
                }
                ++i2;
            }
            totalColumn = percentageTotal + forceTotal;
        }
        if (!this.getOwner().isForceWidth() && forceCount == 0) {
            return;
        }
        if (totalColumn >= containerWidth) {
            i = 0;
            while (i < size) {
                cData = this.data.columnWidths[i];
                if (!cData.isForce) {
                    cData.width = 1;
                    cData.trueMinColumnWidth = 1;
                }
                ++i;
            }
        } else {
            int moreWith = containerWidth - totalColumn;
            if (forceCount == 0) {
                int argaWith = moreWith / size;
                int others = moreWith % size;
                int i3 = 0;
                while (i3 < size) {
                    TableLayoutData.ColumnData cData3 = this.data.columnWidths[i3];
                    cData3.width = i3 <= others - 1 ? cData3.width + argaWith + 1 : (cData3.width += argaWith);
                    ++i3;
                }
            } else if (moreWith < forceCount * 1) {
                int i4 = 0;
                while (i4 < size) {
                    TableLayoutData.ColumnData cData4 = this.data.columnWidths[i4];
                    if (!cData4.isForce) {
                        cData4.width = 1;
                    }
                    ++i4;
                }
            } else {
                int argaWith = moreWith / forceCount;
                int others = moreWith % forceCount;
                ArrayList<TableLayoutData.ColumnData> adjustList = new ArrayList<TableLayoutData.ColumnData>();
                int i5 = 0;
                while (i5 < size) {
                    TableLayoutData.ColumnData cData5 = this.data.columnWidths[i5];
                    if (!cData5.isForce) {
                        adjustList.add(cData5);
                    }
                    ++i5;
                }
                i5 = 0;
                while (i5 < adjustList.size()) {
                    TableLayoutData.ColumnData adjust = (TableLayoutData.ColumnData)adjustList.get(i5);
                    adjust.width = i5 <= others - 1 ? argaWith + 1 : argaWith;
                    ++i5;
                }
            }
        }
    }

    private void init(TableLayoutData.ColumnData[] columnWidths, TableLayoutData.RowData[] rowHeights) {
        ITableLayoutOwner.DimensionInfomation dim;
        int size = rowHeights.length;
        int i = 1;
        while (i < size + 1) {
            rowHeights[i - 1] = new TableLayoutData.RowData();
            rowHeights[i - 1].rowNumber = i;
            rowHeights[i - 1].height = this.getOwner().getRowHeightValue(i);
            rowHeights[i - 1].minRowHeight = 1;
            dim = this.getOwner().getRowHeight(i);
            boolean bl = rowHeights[i - 1].isForce = dim.getMeasure() > 0.0 || dim.isSet();
            if (dim.getUnits() == null || dim.getUnits().length() == 0 || "%".equals(dim.getUnits())) {
                rowHeights[i - 1].isAuto = true;
                rowHeights[i - 1].isForce = false;
            }
            int n = rowHeights[i - 1].trueMinRowHeight = rowHeights[i - 1].isForce ? rowHeights[i - 1].height : 16;
            if (rowHeights[i - 1].trueMinRowHeight < 1) {
                rowHeights[i - 1].trueMinRowHeight = 1;
            }
            ++i;
        }
        size = columnWidths.length;
        i = 1;
        while (i < size + 1) {
            columnWidths[i - 1] = new TableLayoutData.ColumnData();
            columnWidths[i - 1].columnNumber = i;
            columnWidths[i - 1].width = this.getOwner().getColumnWidthValue(i);
            columnWidths[i - 1].minColumnWidth = 1;
            dim = this.getOwner().getColumnWidth(i);
            boolean bl = columnWidths[i - 1].isForce = dim.getMeasure() > 0.0 || dim.isSet();
            if ("%".equals(dim.getUnits()) && dim.getMeasure() > 0.0) {
                columnWidths[i - 1].isPercentage = true;
                columnWidths[i - 1].percentageWidth = dim.getMeasure();
            }
            if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                columnWidths[i - 1].isAuto = true;
            }
            columnWidths[i - 1].trueMinColumnWidth = columnWidths[i - 1].isForce && !columnWidths[i - 1].isPercentage ? columnWidths[i - 1].width : columnWidths[i - 1].minColumnWidth;
            ++i;
        }
    }

    private void resetRowMinSize(TableLayoutData.RowData[] rowHeights) {
        int size = rowHeights.length;
        int i = 1;
        while (i < size + 1) {
            rowHeights[i - 1] = new TableLayoutData.RowData();
            rowHeights[i - 1].rowNumber = i;
            rowHeights[i - 1].height = this.getOwner().getRowHeightValue(i);
            rowHeights[i - 1].minRowHeight = 1;
            ITableLayoutOwner.DimensionInfomation dim = this.getOwner().getRowHeight(i);
            rowHeights[i - 1].isForce = dim.getMeasure() > 0.0 || dim.isSet();
            boolean bl = rowHeights[i - 1].isSetting = dim.getMeasure() > 0.0 || dim.isSet();
            if (dim.getUnits() == null || dim.getUnits().length() == 0 || "%".equals(dim.getUnits())) {
                rowHeights[i - 1].isAuto = true;
                rowHeights[i - 1].isForce = false;
                rowHeights[i - 1].isSetting = false;
            }
            rowHeights[i - 1].trueMinRowHeight = rowHeights[i - 1].isForce ? rowHeights[i - 1].height : 1;
            ++i;
        }
    }

    private void initFigureInfo(List children) {
        int size = children.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)children.get(i);
            ITableLayoutCell cellPart = (ITableLayoutCell)map.get(figure);
            int rowNumber = cellPart.getRowNumber();
            int columnNumber = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int columnSpan = cellPart.getColSpan();
            TableLayout.FigureInfomation info = new TableLayout.FigureInfomation();
            info.rowNumber = rowNumber;
            info.columnNumber = columnNumber;
            info.rowSpan = rowSpan;
            info.columnSpan = columnSpan;
            this.figureInfo.put(figure, info);
            ++i;
        }
    }
}

