/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ExportStyleDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ExportElementDialog
extends ResourceFileFolderSelectionDialog {
    private Text text;
    private String ext = ".rptlibrary";
    private Object designElement;
    protected String newFileName = "";
    private Status OKStatus = new Status(0, "org.eclipse.birt.report.designer.ui", 0, "", null);
    private Status ErrorStatus = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"ExportElementDialog.ErrorMessage"), null);
    private Status ErrorStatusNoSelection = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)""), null);
    private Status ErrorStatusInvalid = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"ExportElementDialog.ErrorMessageInvalid"), null);
    private Status ErrorStatusDuplicate = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"ExportElementDialog.ErrorMessageDuplicate"), null);
    private Status ErrorStatusCanNotExport = new Status(4, "org.eclipse.birt.report.designer.ui", 4, Messages.getString((String)"ExportElementDialog.ErrorStatusCanNotExport"), null);

    public ExportElementDialog(Object selection) {
        super(false, new String[]{"*.rptlibrary"});
        this.setDoubleClickSelects(true);
        this.setValidator(new Validator());
        this.setAllowMultiple(false);
        this.setTitle(Messages.getString((String)"ExportElementDialog.Dialog.Title"));
        this.setMessage(Messages.getString((String)"ExportElementDialog.Dialog.Message"));
        this.designElement = selection;
        if (this.designElement instanceof StructuredSelection) {
            this.designElement = ((StructuredSelection)this.designElement).getFirstElement();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite rt = (Composite)super.createDialogArea(parent);
        rt.setLayoutData((Object)new GridData(1808));
        Composite pane = new Composite(rt, 0);
        pane.setLayoutData((Object)new GridData(768));
        pane.setLayout((Layout)new GridLayout(2, false));
        pane.setLayoutData((Object)new GridData(768));
        Label lb = new Label(pane, 0);
        lb.setText(Messages.getString((String)"ExportElementDialog.label.NewFile"));
        this.text = new Text(pane, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String tempText = ExportElementDialog.this.text.getText().trim();
                ExportElementDialog.this.newFileName = tempText.length() > 0 && !tempText.toLowerCase().endsWith(ExportElementDialog.this.ext) ? String.valueOf(tempText) + ExportElementDialog.this.ext : tempText;
                ExportElementDialog.this.updateOKStatus();
            }
        });
        this.configViewer();
        return rt;
    }

    private void configViewer() {
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String tempText;
                Object object = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (object instanceof ResourceEntry) {
                    ResourceEntry entry = (ResourceEntry)object;
                    if (entry.getURL() != null && entry.getURL().getProtocol().equals("file")) {
                        File file = new File(entry.getURL().getPath());
                        ExportElementDialog.this.text.setEnabled(file.isDirectory());
                    } else {
                        ExportElementDialog.this.text.setText("");
                        ExportElementDialog.this.text.setEnabled(false);
                    }
                } else {
                    ExportElementDialog.this.text.setText("");
                    ExportElementDialog.this.text.setEnabled(false);
                }
                ExportElementDialog.this.newFileName = !ExportElementDialog.this.text.isEnabled() ? "" : ((tempText = ExportElementDialog.this.text.getText().trim()).length() > 0 && tempText.toLowerCase().endsWith(ExportElementDialog.this.ext) ? String.valueOf(tempText) + ExportElementDialog.this.ext : tempText);
            }
        });
    }

    /*
     * Exception decompiling
     */
    protected void okPressed() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 23[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object[] getExportTheme(StyleHandle firstElement, LibraryHandle libraryHandle) {
        ExportStyleDialog dialog = new ExportStyleDialog(firstElement, libraryHandle);
        if (dialog.open() == 0) {
            return (Object[])dialog.getResult();
        }
        return null;
    }

    public String getPath() {
        Object[] selected = this.getResult();
        String fullPath = "";
        if (selected.length > 0) {
            ResourceEntry entry = (ResourceEntry)selected[0];
            fullPath = entry.getURL().getPath();
            File file = new File(fullPath);
            if (file.isDirectory()) {
                fullPath = String.valueOf(fullPath) + (fullPath.equals("") || fullPath.endsWith("/") ? "" : "/") + this.newFileName;
            }
        } else {
            String resouceFolder = ReportPlugin.getDefault().getResourceFolder();
            fullPath = String.valueOf(resouceFolder) + (resouceFolder.equals("") || resouceFolder.endsWith("/") ? "" : "/") + this.newFileName;
        }
        return fullPath;
    }

    private int confirmOverride(String confirmTitle, String confirmMsg) {
        Object[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        if (confirmTitle == null || confirmTitle.trim().length() == 0) {
            confirmTitle = Messages.getString((String)"ExportElementDialog.WarningMessageDuplicate.Title");
        }
        if (confirmMsg == null || confirmMsg.trim().length() == 0) {
            confirmMsg = Messages.getFormattedString((String)"ExportElementDialog.WarningMessageDuplicate.Message", (Object[])buttons);
        }
        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), confirmTitle, null, confirmMsg, 3, (String[])buttons, 0);
        return dialog.open();
    }

    private int confirmOverride() {
        return this.confirmOverride(null, null);
    }

    private boolean exportEmbeddedImage(ImageHandle image, LibraryHandle libraryHandle) throws SemanticException {
        if (!"embed".equals(image.getSource())) {
            return false;
        }
        EmbeddedImageHandle embeded = image.getEmbeddedImage();
        if (embeded == null) {
            return false;
        }
        boolean notExist = ElementExportUtil.canExport((StructureHandle)embeded, (LibraryHandle)libraryHandle, (boolean)false);
        if (!notExist) {
            int confirm = this.confirmOverride(null, Messages.getString((String)"ExportElementDialog.WarningMessageDuplicate.OverrideImage"));
            switch (confirm) {
                case 0: {
                    break;
                }
                case 1: {
                    ElementExportUtil.exportElement((DesignElementHandle)image, (LibraryHandle)libraryHandle, (boolean)true);
                    return true;
                }
                default: {
                    this.cancelPressed();
                    return false;
                }
            }
        }
        ElementExportUtil.exportElement((DesignElementHandle)image, (LibraryHandle)libraryHandle, (boolean)true);
        ElementExportUtil.exportStructure((StructureHandle)embeded, (LibraryHandle)libraryHandle, (boolean)true);
        return true;
    }

    private LibraryHandle openOrCreateLibrary(SessionHandle session, String libraryFileName) throws DesignFileException {
        try {
            LibraryHandle library = session.openLibrary(libraryFileName);
            return library;
        }
        catch (DesignFileException e) {
            List errorList;
            ErrorDetail error;
            if ("Error.DesignFileException.SYNTAX_ERROR" == e.getErrorCode() && "Error.DesignParserException.FILE_NOT_FOUND" == (error = (ErrorDetail)(errorList = e.getErrorList()).get(0)).getErrorCode()) {
                String templateName = UIUtil.getDefaultLibraryTemplate();
                LibraryHandle libraryHandle = templateName == null ? session.createLibrary() : session.createLibraryFromTemplate(templateName);
                libraryHandle.setFileName(libraryFileName);
                return libraryHandle;
            }
            throw e;
        }
    }

    private boolean containInvalidChar(String fileName) {
        boolean ret = false;
        char[] invalidChars = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
        int i = 0;
        while (i < invalidChars.length) {
            if (fileName.indexOf(invalidChars[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return ret;
    }

    private class Validator
    implements ISelectionStatusValidator {
        private Validator() {
        }

        public IStatus validate(Object[] selection) {
            Status status = ExportElementDialog.this.OKStatus;
            int nSelected = selection.length;
            if (nSelected == 0) {
                return ExportElementDialog.this.ErrorStatusNoSelection;
            }
            if (nSelected > 1) {
                return ExportElementDialog.this.ErrorStatus;
            }
            if (selection[0] instanceof ResourceEntry && ((ResourceEntry)selection[0]).isFile()) {
                status = ExportElementDialog.this.OKStatus;
            } else {
                if (ExportElementDialog.this.newFileName == null || ExportElementDialog.this.newFileName.length() == 0 || ExportElementDialog.this.newFileName.toLowerCase().equals(ExportElementDialog.this.ext.toLowerCase()) || ExportElementDialog.this.newFileName.startsWith(".") || ExportElementDialog.this.containInvalidChar(ExportElementDialog.this.newFileName)) {
                    return ExportElementDialog.this.ErrorStatusInvalid;
                }
                if (!ExportElementDialog.this.newFileName.toLowerCase().endsWith(ExportElementDialog.this.ext.toLowerCase())) {
                    return ExportElementDialog.this.ErrorStatus;
                }
            }
            if (status == ExportElementDialog.this.OKStatus) {
                String path = ExportElementDialog.this.getPath();
                try {
                    LibraryHandle handle;
                    LibraryHandle libraryHandle = handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(path);
                    boolean can = false;
                    if (ExportElementDialog.this.designElement instanceof DesignElementHandle) {
                        can = ElementExportUtil.canExport((DesignElementHandle)((DesignElementHandle)ExportElementDialog.this.designElement), (LibraryHandle)libraryHandle, (boolean)true);
                    } else if (ExportElementDialog.this.designElement instanceof StructureHandle) {
                        can = ElementExportUtil.canExport((StructureHandle)((StructureHandle)ExportElementDialog.this.designElement), (LibraryHandle)libraryHandle, (boolean)true);
                    }
                    libraryHandle.close();
                    if (!can) {
                        return ExportElementDialog.this.ErrorStatusCanNotExport;
                    }
                }
                catch (DesignFileException e) {
                    e.printStackTrace();
                }
            }
            return ExportElementDialog.this.OKStatus;
        }
    }
}

