/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TextFieldEditor
extends AbstractFieldEditor {
    public static final int DEFAULT = 2048;
    private int style;
    private Text text = null;

    protected TextFieldEditor() {
    }

    public TextFieldEditor(String name, String labelText, int style, Composite parent) {
        this.init(name, labelText);
        this.style = style;
        this.createControl(parent);
    }

    public TextFieldEditor(String name, String label, Composite parent) {
        this(name, label, 2048, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.text.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getTextControl(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        String value;
        if (this.text != null && (value = this.getPreferenceStore().getString(this.getPreferenceName())) != null) {
            this.text.setText(value);
        }
        this.markDirty(false);
    }

    protected void doLoadDefault() {
        String value;
        if (this.text != null && (value = this.getPreferenceStore().getDefaultString(this.getPreferenceName())) != null) {
            this.text.setText(value);
        }
        this.markDirty(false);
    }

    protected void doStore() {
        if (this.isDirty()) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.text.getText());
        }
    }

    protected Text getTextControl(Composite parent) {
        if (this.text == null) {
            this.text = new Text(parent, 2882);
            this.text.setFont(parent.getFont());
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String value = TextFieldEditor.this.text.getText();
                    TextFieldEditor.this.valueChanged(value);
                }
            });
            this.text.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TextFieldEditor.this.text = null;
                }
            });
        } else {
            this.checkParent((Control)this.text, parent);
        }
        return this.text;
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void setFocus() {
        if (this.text != null) {
            this.text.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        Label label = this.getLabelControl();
        if (label == null && text != null) {
            this.text.setText(text);
        }
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged("field_editor_value", oldValue, newValue);
            this.markDirty(true);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.getTextControl(parent).setEnabled(enabled);
    }

    protected String getStringValue() {
        return null;
    }
}

