/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.GregorianCalendar;

public class DateUtil {
    private static final int[] DAYS_MONTH = new int[]{31, -1, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static GregorianCalendar calendarInstance = null;
    private static String[] splitStrs = new String[]{"/", "-", "."};

    public static boolean checkValid(DateFormat df, String dateStr) {
        assert (df != null);
        assert (dateStr != null);
        boolean isValid = true;
        if (df instanceof SimpleDateFormat) {
            String[] dateResult = DateUtil.splitDateStr(dateStr);
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String pattern = sdf.toPattern();
            String[] patternResult = DateUtil.splitDateStr(pattern);
            if (dateResult != null && patternResult != null) {
                isValid = DateUtil.isMatch(dateResult, patternResult);
            }
        }
        return isValid;
    }

    private static String[] splitDateStr(String dateStr) {
        String splitChar = null;
        int i = 0;
        while (i < splitStrs.length) {
            if (dateStr.indexOf(splitStrs[i]) >= 0) {
                splitChar = splitStrs[i];
                break;
            }
            ++i;
        }
        if (splitChar == null) {
            return null;
        }
        String[] result = dateStr.split(splitChar);
        if (result.length != 3) {
            return null;
        }
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = result[i2].trim();
            ++i2;
        }
        return result;
    }

    private static boolean isMatch(String[] dateStr, String[] patternStr) {
        assert (dateStr != null);
        assert (patternStr != null);
        int year = -1;
        int month = -1;
        int day = -1;
        int i = 0;
        while (i < dateStr.length) {
            int value = Integer.valueOf(dateStr[i]);
            if (patternStr[i].startsWith("y") || patternStr[i].startsWith("Y")) {
                year = value;
            } else if (patternStr[i].startsWith("M") || patternStr[i].startsWith("m")) {
                month = value;
            } else if (patternStr[i].startsWith("d") || patternStr[i].startsWith("D")) {
                day = value;
            }
            ++i;
        }
        boolean result = true;
        if (year < 0 || month < 1 || month > 12 || DateUtil.isInvalidDay(day, year, month)) {
            result = false;
        }
        return result;
    }

    private static boolean isInvalidDay(int day, int year, int month) {
        if (calendarInstance == null) {
            calendarInstance = new GregorianCalendar();
        }
        int dayOfMonth = DAYS_MONTH[month - 1];
        if (month == 2) {
            dayOfMonth = calendarInstance.isLeapYear(year) ? 29 : 28;
        }
        return day < 1 || day > dayOfMonth;
    }
}

