/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.core.btree.BTreeFile;

public class FileBTreeFile
implements BTreeFile,
Closeable {
    private RandomAccessFile file;

    public FileBTreeFile(String fileName) throws IOException {
        new File(fileName).getParentFile().mkdirs();
        this.file = new RandomAccessFile(fileName, "rw");
    }

    public void close() throws IOException {
        try {
            this.file.close();
        }
        finally {
            this.file = null;
        }
    }

    public int allocBlock() throws IOException {
        long length = this.file.length();
        int blockId = (int)(length + 4096L - 1L) / 4096;
        this.file.setLength((blockId + 1) * 4096);
        return blockId;
    }

    public int getTotalBlock() throws IOException {
        long length = this.file.length();
        return (int)(length + 4096L - 1L) / 4096;
    }

    public Object lock() throws IOException {
        return this;
    }

    public void readBlock(int blockId, byte[] bytes) throws IOException {
        this.file.seek(blockId * 4096);
        int readSize = bytes.length;
        if (readSize > 4096) {
            readSize = 4096;
        }
        this.file.read(bytes, 0, readSize);
    }

    public void unlock(Object lock) throws IOException {
    }

    public void writeBlock(int blockId, byte[] bytes) throws IOException {
        int writeSize = bytes.length;
        if (writeSize > 4096) {
            writeSize = 4096;
        }
        this.file.seek(blockId * 4096);
        this.file.write(bytes, 0, writeSize);
    }
}

