/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.btree.BTreeConstants;

class BTreeHead
implements BTreeConstants {
    int version = 0;
    boolean allowDuplicate = false;
    int keySize = 0;
    boolean hasValues = true;
    int valueSize = 0;
    int rootNodeId = -1;
    int totalLevels = 0;
    int totalKeys = 0;
    int totalValues = 0;

    BTreeHead() {
    }

    void read(DataInput in) throws IOException {
        long tag = in.readLong();
        if (tag != 0x4254524545L) {
            throw new IOException("Invalid magic tag:" + Long.toHexString(tag));
        }
        this.version = in.readInt();
        if (this.version != 0) {
            throw new IOException("Unsupported version:" + this.version);
        }
        this.readV0(in);
    }

    void readV0(DataInput in) throws IOException {
        this.allowDuplicate = in.readBoolean();
        this.keySize = in.readShort();
        this.hasValues = in.readBoolean();
        this.valueSize = in.readShort();
        this.rootNodeId = in.readInt();
        this.totalLevels = in.readInt();
        this.totalKeys = in.readInt();
        this.totalValues = in.readInt();
    }

    void write(DataOutput out) throws IOException {
        out.writeLong(0x4254524545L);
        out.writeInt(0);
        out.writeBoolean(this.allowDuplicate);
        out.writeShort(this.keySize);
        out.writeBoolean(this.hasValues);
        out.writeShort(this.valueSize);
        out.writeInt(this.rootNodeId);
        out.writeInt(this.totalLevels);
        out.writeInt(this.totalKeys);
        out.writeInt(this.totalValues);
    }
}

