/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.archive.compound.v3.Ext2Node;
import org.eclipse.birt.core.archive.compound.v3.FatBlock;

public class FatBlockList {
    static final int MAX_DIRECT_BLOCK = 9;
    static final int INDIRECT_BLOCK_COUNT = 3;
    static final int MAX_INDIRECT_BLOCK = 1024;
    static final int MAX_DOUBLE_INDIRECT_BLOCK = 0x100000;
    static final int DOUBLE_INDIRECT_MASK_1 = 1047552;
    static final int DOUBLE_INDIRECT_SHIFT_1 = 10;
    static final int DOUBLE_INDIRECT_MASK_2 = 1023;
    static final int DOUBLE_INDIRECT_SHIFT_2 = 0;
    static final int MAX_TRIPLE_INDIRECT_BLOCK = 0x40000000;
    static final int TRIPLE_INDIRECT_MASK_1 = 0x3FF00000;
    static final int TRIPLE_INDIRECT_SHIFT_1 = 20;
    static final int TRIPLE_INDIRECT_MASK_2 = 1047552;
    static final int TRIPLE_INDIRECT_SHIFT_2 = 10;
    static final int TRIPLE_INDIRECT_MASK_3 = 1023;
    static final int TRIPLE_INDIRECT_SHIFT_3 = 0;
    protected Ext2FileSystem fs;
    protected Ext2Node node;
    protected FatBlock[] cachedFatBlocks = new FatBlock[3];

    FatBlockList(Ext2FileSystem fs, Ext2Node node) {
        this.fs = fs;
        this.node = node;
    }

    public void clear() throws IOException {
        int i = 0;
        while (i < 3) {
            this.clear(i);
            ++i;
        }
    }

    protected void clear(int level) throws IOException {
        FatBlock cachedBlock = this.cachedFatBlocks[level];
        if (cachedBlock != null) {
            this.fs.unloadBlock(cachedBlock);
            this.cachedFatBlocks[level] = null;
        }
    }

    public Ext2Node getNode() {
        return this.node;
    }

    public int getFileBlock(int index) throws IOException {
        if (index < 9) {
            return this.node.getDirectBlock(index);
        }
        if ((index -= 9) < 1024) {
            return this.getIndirectBlock1(index);
        }
        if ((index -= 1024) < 0x100000) {
            return this.getIndirectBlock2(index);
        }
        if ((index -= 0x100000) < 0x40000000) {
            return this.getIndirectBlock3(index);
        }
        throw new EOFException("exceed the max file length");
    }

    public void setFileBlock(int index, int fileBlockId) throws IOException {
        if (index < 9) {
            this.node.setDirectBlock(index, fileBlockId);
            return;
        }
        if ((index -= 9) < 1024) {
            this.setIndirectBlock1(index, fileBlockId);
            return;
        }
        if ((index -= 1024) < 0x100000) {
            this.setIndirectBlock2(index, fileBlockId);
            return;
        }
        if ((index -= 0x100000) < 0x40000000) {
            this.setIndirectBlock3(index, fileBlockId);
            return;
        }
        throw new EOFException("exceed the max file length");
    }

    private void setIndirectBlock1(int index, int blockId) throws IOException {
        int fatBlockId = this.node.getIndirectBlock(0);
        FatBlock fatBlock = this.getCachedBlock(0, fatBlockId);
        if (fatBlockId <= 0) {
            fatBlockId = fatBlock.getBlockId();
            this.node.setBlockCount(this.node.getBlockCount() + 1);
            this.node.setIndirectBlock(0, fatBlockId);
        }
        fatBlock.setBlock(index, blockId);
    }

    private int getIndirectBlock1(int index) throws IOException {
        int fatBlockId = this.node.getIndirectBlock(0);
        if (fatBlockId <= 0) {
            return -1;
        }
        FatBlock fatBlock = this.getCachedBlock(0, fatBlockId);
        return fatBlock.getBlock(index);
    }

    private void setIndirectBlock2(int index, int blockId) throws IOException {
        int fatBlockId = this.node.getIndirectBlock(1);
        FatBlock fatBlock = this.getCachedBlock(0, fatBlockId);
        if (fatBlockId <= 0) {
            fatBlockId = fatBlock.getBlockId();
            this.node.setBlockCount(this.node.getBlockCount() + 1);
            this.node.setIndirectBlock(1, fatBlockId);
        }
        int index1 = (index & 0xFFC00) >> 10;
        int fatBlockId1 = fatBlock.getBlock(index1);
        FatBlock fatBlock1 = this.getCachedBlock(1, fatBlockId1);
        if (fatBlockId1 <= 0) {
            fatBlockId1 = fatBlock1.getBlockId();
            this.node.setBlockCount(this.node.getBlockCount() + 1);
            fatBlock.setBlock(index1, fatBlockId1);
        }
        int index2 = index & 0x3FF;
        fatBlock1.setBlock(index2, blockId);
    }

    private int getIndirectBlock2(int index) throws IOException {
        int index1;
        FatBlock fatBlock;
        int fatBlockId1;
        int fatBlockId = this.node.getIndirectBlock(1);
        if (fatBlockId > 0 && (fatBlockId1 = (fatBlock = this.getCachedBlock(0, fatBlockId)).getBlock(index1 = (index & 0xFFC00) >> 10)) > 0) {
            FatBlock fatBlock1 = this.getCachedBlock(1, fatBlockId1);
            int index2 = index & 0x3FF;
            return fatBlock1.getBlock(index2);
        }
        return -1;
    }

    private void setIndirectBlock3(int index, int blockId) throws IOException {
        int fatBlockId = this.node.getIndirectBlock(2);
        FatBlock fatBlock = this.getCachedBlock(0, fatBlockId);
        if (fatBlockId <= 0) {
            fatBlockId = fatBlock.getBlockId();
            this.node.setBlockCount(this.node.getBlockCount() + 1);
            this.node.setIndirectBlock(2, fatBlockId);
        }
        int index1 = (index & 0x3FF00000) >> 20;
        int fatBlockId1 = fatBlock.getBlock(index1);
        FatBlock fatBlock1 = this.getCachedBlock(1, fatBlockId1);
        if (fatBlockId1 <= 0) {
            fatBlockId1 = fatBlock1.getBlockId();
            this.node.setBlockCount(this.node.getBlockCount() + 1);
            fatBlock.setBlock(index1, fatBlockId1);
        }
        int index2 = (index & 0xFFC00) >> 10;
        int fatBlockId2 = fatBlock1.getBlock(index2);
        FatBlock fatBlock2 = this.getCachedBlock(2, fatBlockId2);
        if (fatBlockId2 <= 0) {
            fatBlockId2 = fatBlock2.getBlockId();
            this.node.setBlockCount(this.node.getBlockCount() + 1);
            fatBlock1.setBlock(index2, fatBlockId2);
        }
        int index3 = index & 0x3FF;
        fatBlock2.setBlock(index3, blockId);
    }

    private int getIndirectBlock3(int index) throws IOException {
        int index2;
        FatBlock fatBlock1;
        int fatBlockId2;
        int index1;
        FatBlock fatBlock;
        int fatBlockId1;
        int fatBlockId = this.node.getIndirectBlock(2);
        if (fatBlockId > 0 && (fatBlockId1 = (fatBlock = this.getCachedBlock(0, fatBlockId)).getBlock(index1 = (index & 0x3FF00000) >> 20)) > 0 && (fatBlockId2 = (fatBlock1 = this.getCachedBlock(1, fatBlockId1)).getBlock(index2 = (index & 0xFFC00) >> 10)) > 0) {
            FatBlock fatBlock2 = this.getCachedBlock(2, fatBlockId2);
            int index3 = index & 0x3FF;
            return fatBlock2.getBlock(index3);
        }
        return -1;
    }

    FatBlock getCachedBlock(int level, int blockId) throws IOException {
        FatBlock block = this.cachedFatBlocks[level];
        if (block != null) {
            if (block.getBlockId() == blockId) {
                return block;
            }
            this.fs.unloadBlock(block);
        }
        block = blockId != -1 ? this.fs.loadFatBlock(blockId) : this.fs.createFatBlock();
        this.cachedFatBlocks[level] = block;
        return block;
    }
}

