/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAFolderInputStream;
import org.eclipse.birt.core.archive.RAFolderOutputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class FolderArchiveWriter
implements IDocArchiveWriter {
    private static Logger logger = Logger.getLogger(FolderArchiveWriter.class.getName());
    private String folderName;
    private IStreamSorter streamSorter = null;
    private HashSet<RAFolderInputStream> inputStreams = new HashSet();
    private HashSet<RAFolderOutputStream> outputStreams = new HashSet();

    public FolderArchiveWriter(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException("The folder name is null or empty string.");
        }
        File fd = new File(folderName);
        if (!fd.exists()) {
            fd.mkdirs();
        }
        this.folderName = fd.getCanonicalPath();
    }

    public void initialize() {
    }

    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        ArchiveUtil.createParentFolder(fd);
        RAFolderOutputStream out = new RAFolderOutputStream(this.outputStreams, fd);
        return out;
    }

    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        ArchiveUtil.createParentFolder(fd);
        RAFolderOutputStream out = new RAFolderOutputStream(this.outputStreams, fd, true);
        return out;
    }

    public RAOutputStream createOutputStream(String relativePath) throws IOException {
        return this.createRandomAccessStream(relativePath);
    }

    public RAOutputStream getOutputStream(String relativePath) throws IOException {
        return this.openRandomAccessStream(relativePath);
    }

    public RAInputStream getInputStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File file = new File(path);
        if (file.exists()) {
            RAFolderInputStream in = new RAFolderInputStream(this.inputStreams, file);
            return in;
        }
        throw new IOException(String.valueOf(relativePath) + " doesn't exit");
    }

    public boolean dropStream(String relativePath) {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        return this.removeFileAndFolder(fd);
    }

    public String getName() {
        return this.folderName;
    }

    public boolean exists(String relativePath) {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        return fd.exists();
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
        this.streamSorter = streamSorter;
    }

    public void finish() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IOException exception = null;
        HashSet<Closeable> hashSet = this.outputStreams;
        synchronized (hashSet) {
            ArrayList<RAFolderOutputStream> outputs = new ArrayList<RAFolderOutputStream>(this.outputStreams);
            for (RAFolderOutputStream output : outputs) {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (exception == null) continue;
                    exception = ex;
                }
            }
            this.outputStreams.clear();
        }
        hashSet = this.inputStreams;
        synchronized (hashSet) {
            ArrayList<RAFolderInputStream> inputs = new ArrayList<RAFolderInputStream>(this.inputStreams);
            for (RAFolderInputStream input : inputs) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (exception == null) continue;
                    exception = ex;
                }
            }
            this.inputStreams.clear();
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void toFileArchive(String fileArchiveName) throws IOException {
        ArchiveUtil.archive(this.folderName, this.streamSorter, fileArchiveName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object ioex = null;
        HashSet<RAFolderInputStream> hashSet = this.inputStreams;
        synchronized (hashSet) {
            for (RAOutputStream rAOutputStream : this.outputStreams) {
                rAOutputStream.flush();
            }
        }
    }

    private boolean removeFileAndFolder(File file) {
        File[] children;
        assert (file != null);
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                this.removeFileAndFolder(children[i]);
                ++i;
            }
        }
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public Object lock(String stream) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, String.valueOf(stream) + ".lck");
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    public void unlock(Object lock) {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(lock);
    }
}

