/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class LineCanvas
extends Canvas
implements PaintListener,
FocusListener {
    int iLineStyle = 1;
    int iLineWidth = 1;
    boolean isFocusIn = false;

    public LineCanvas(Composite parent, int iStyle, int iLineStyle, int iLineWidth) {
        super(parent, iStyle);
        this.iLineStyle = iLineStyle;
        this.iLineWidth = iLineWidth;
        this.addPaintListener(this);
        this.addFocusListener(this);
    }

    public int getLineStyle() {
        return this.iLineStyle;
    }

    public void setLineStyle(int iLineStyle) {
        this.iLineStyle = iLineStyle;
    }

    public int getLineWidth() {
        return this.iLineWidth;
    }

    public void setLineWidth(int iLineWidth) {
        this.iLineWidth = iLineWidth;
    }

    public void paintControl(PaintEvent pe) {
        if (this.isEnabled() && this.isFocusControl()) {
            this.isFocusIn = true;
        }
        Color cForeground = null;
        Color cBackground = null;
        if (this.isEnabled()) {
            cForeground = this.getDisplay().getSystemColor(24);
            cBackground = this.getDisplay().getSystemColor(25);
        } else {
            cForeground = this.getDisplay().getSystemColor(16);
            cBackground = this.getDisplay().getSystemColor(22);
        }
        GC gc = pe.gc;
        if (this.isFocusIn) {
            gc.setBackground(this.getDisplay().getSystemColor(26));
            gc.setForeground(this.getDisplay().getSystemColor(27));
        } else {
            gc.setBackground(cBackground);
            gc.setForeground(cForeground);
        }
        gc.fillRectangle(0, 0, this.getSize().x, this.getSize().y);
        gc.setLineStyle(this.iLineStyle);
        gc.setLineWidth(this.iLineWidth);
        gc.drawLine(10, this.getSize().y / 2, this.getSize().x - 10, this.getSize().y / 2);
    }

    public void setEnabled(boolean bState) {
        super.setEnabled(bState);
        this.redraw();
    }

    public void focusGained(FocusEvent e) {
        this.isFocusIn = true;
    }

    public void focusLost(FocusEvent e) {
        this.isFocusIn = false;
    }
}

