/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledTaskContainer
extends AbstractTaskContainer {
    private final TaskActivityManager activityManager;
    private final String summary;
    private final DateRange range;

    public ScheduledTaskContainer(TaskActivityManager activityManager, DateRange range, String summary) {
        super(summary == null ? range.toString(false) : summary);
        this.activityManager = activityManager;
        this.range = range;
        this.summary = summary == null ? range.toString(false) : summary;
    }

    public ScheduledTaskContainer(TaskActivityManager taskActivityManager, DateRange day) {
        this(taskActivityManager, day, null);
    }

    public boolean isFuture() {
        return !this.isPresent() && this.range.getStartDate().after(Calendar.getInstance());
    }

    public boolean isPresent() {
        return this.range.getStartDate().before(Calendar.getInstance()) && this.range.getEndDate().after(Calendar.getInstance());
    }

    @Override
    public Collection<ITask> getChildren() {
        HashSet<ITask> children = new HashSet<ITask>();
        Calendar cal = TaskActivityUtil.getCalendar();
        for (ITask iTask : this.activityManager.getScheduledTasks(this.range)) {
            if (iTask.isCompleted() && !this.isCompletedToday(iTask) || this.isDueBeforeScheduled(iTask) && this.activityManager.isOwnedByUser(iTask)) continue;
            if (this.isThisWeekBin() && this.isScheduledForAWeek(iTask)) {
                if (iTask.getDueDate() != null) {
                    cal.setTime(iTask.getDueDate());
                    if (this.range.includes(cal)) continue;
                }
                this.addChild(children, iTask);
            }
            this.addChild(children, iTask);
        }
        if (!(this.range instanceof WeekDateRange) || !((WeekDateRange)this.range).isPresent()) {
            for (ITask iTask : this.getTasksDueThisWeek()) {
                if (this.isScheduledBeforeDue(iTask) || !this.activityManager.isOwnedByUser(iTask)) continue;
                this.addChild(children, iTask);
            }
        }
        if (this.isTodayBin()) {
            for (ITask iTask : this.activityManager.getOverScheduledTasks()) {
                if (!this.isScheduledForADay(iTask)) continue;
                this.addChild(children, iTask);
            }
            for (ITask iTask : this.activityManager.getOverDueTasks()) {
                this.addChild(children, iTask);
            }
            ITask iTask = this.activityManager.getActiveTask();
            if (iTask != null && !children.contains(iTask)) {
                this.addChild(children, iTask);
            }
        }
        if (this.range instanceof WeekDateRange && ((WeekDateRange)this.range).isThisWeek()) {
            for (ITask iTask : this.activityManager.getOverScheduledTasks()) {
                if (!this.isScheduledForAWeek(iTask)) continue;
                this.addChild(children, iTask);
            }
        }
        return children;
    }

    private boolean isTodayBin() {
        return this.range instanceof DayDateRange && ((DayDateRange)this.range).isPresent();
    }

    private boolean isThisWeekBin() {
        return this.range instanceof WeekDateRange && ((WeekDateRange)this.range).isThisWeek();
    }

    private Set<ITask> getTasksDueThisWeek() {
        return this.activityManager.getDueTasks(this.range.getStartDate(), this.range.getEndDate());
    }

    private boolean isScheduledForAWeek(ITask task) {
        return task instanceof AbstractTask && ((AbstractTask)task).getScheduledForDate() instanceof WeekDateRange;
    }

    private boolean isDueBeforeScheduled(ITask task) {
        return task.getDueDate() != null && task.getDueDate().before(((AbstractTask)task).getScheduledForDate().getStartDate().getTime());
    }

    private boolean isScheduledForADay(ITask task) {
        return task instanceof AbstractTask && !(((AbstractTask)task).getScheduledForDate() instanceof WeekDateRange);
    }

    private boolean isScheduledBeforeDue(ITask task) {
        return ((AbstractTask)task).getScheduledForDate() != null && ((AbstractTask)task).getScheduledForDate().before(this.range.getStartDate());
    }

    private boolean isCompletedToday(ITask task) {
        return task.isCompleted() && TaskActivityUtil.getDayOf(task.getCompletionDate()).isPresent();
    }

    private void addChild(Set<ITask> collection, ITask task) {
        collection.add(task);
    }

    @Override
    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        return this.range.toString();
    }

    @Override
    public String getHandleIdentifier() {
        return this.summary;
    }

    @Override
    public String getPriority() {
        return "";
    }

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public int compareTo(IRepositoryElement element) {
        if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)element;
            return this.range.compareTo(container.getDateRange());
        }
        return 0;
    }

    public DateRange getDateRange() {
        return this.range;
    }

    public Calendar getEnd() {
        return this.range.getEndDate();
    }

    public Calendar getStart() {
        return this.range.getStartDate();
    }

    public boolean includes(Calendar pastWeeksTaskStart) {
        return this.range.includes(pastWeeksTaskStart);
    }
}

