/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wst.server.ui.internal.Messages;

public class SWTUtil {
    private static FontMetrics fontMetrics;

    protected static void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected static int getButtonWidthHint(Button button) {
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Button createButton(Composite comp, String label) {
        Button b = new Button(comp, 8);
        b.setText(label);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        GridData data = new GridData(258);
        data.widthHint = SWTUtil.getButtonWidthHint(b);
        b.setLayoutData((Object)data);
        return b;
    }

    public static int convertHorizontalDLUsToPixels(Composite comp, int x) {
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)x);
    }

    public static int convertVerticalDLUsToPixels(Composite comp, int y) {
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        return Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)y);
    }

    public static void setSpinnerTooltip(Spinner spinner) {
        String tooltipText;
        int seconds = spinner.getSelection();
        if (seconds <= 60) {
            tooltipText = null;
        } else if (seconds % 60 == 0) {
            int minutes = seconds / 60;
            tooltipText = NLS.bind((String)Messages.minutes, (Object)String.valueOf(minutes));
        } else {
            int minutes = seconds / 60;
            int modSec = seconds % 60;
            String secondsText = modSec < 10 ? "0" + modSec : Integer.toString(modSec);
            tooltipText = NLS.bind((String)Messages.minutes, (Object)(String.valueOf(minutes) + ":" + secondsText));
        }
        spinner.setToolTipText(tooltipText);
    }
}

