/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.handlers;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.css.ui.internal.CSSUIMessages;
import org.eclipse.wst.css.ui.internal.Logger;
import org.eclipse.wst.css.ui.internal.handlers.AbstractCommentHandler;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class ToggleCommentHandler
extends AbstractCommentHandler {
    protected void processAction(ITextEditor textEditor, IDocument document, ITextSelection textSelection) {
        int selectionStartLine = textSelection.getStartLine();
        int selectionEndLine = textSelection.getEndLine();
        try {
            int selectionEndLineOffset = document.getLineOffset(selectionEndLine);
            int selectionEndOffset = textSelection.getOffset() + textSelection.getLength();
            if (selectionEndLine > selectionStartLine && selectionEndLineOffset == selectionEndOffset) {
                --selectionEndLine;
            }
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
        Position selectionPosition = null;
        boolean updateStartOffset = false;
        try {
            selectionPosition = new Position(textSelection.getOffset(), textSelection.getLength());
            document.addPosition(selectionPosition);
            int selectionStartLineOffset = document.getLineOffset(selectionStartLine);
            if (textSelection.getLength() > 0 && selectionStartLineOffset == textSelection.getOffset() && !this.isCommentLine(document, selectionStartLine)) {
                updateStartOffset = true;
            }
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
        this.processAction(document, selectionStartLine, selectionEndLine);
        this.updateCurrentSelection(textEditor, selectionPosition, document, updateStartOffset);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processAction(IDocument document, int selectionStartLine, int selectionEndLine) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
        if (model == null) return;
        try {
            model.beginRecording((Object)this, CSSUIMessages.ToggleComment_tooltip);
            model.aboutToChangeModel();
            int i = selectionStartLine;
            while (i <= selectionEndLine) {
                block8: {
                    try {
                        if (document.getLineLength(i) <= 0) break block8;
                        if (this.isCommentLine(document, i)) {
                            int lineOffset = document.getLineOffset(i);
                            IRegion region = document.getLineInformation(i);
                            String string = document.get(region.getOffset(), region.getLength());
                            int openCommentOffset = lineOffset + string.indexOf("/*");
                            int closeCommentOffset = lineOffset + string.indexOf("*/") - "/*".length();
                            this.uncomment(document, openCommentOffset, closeCommentOffset);
                        } else {
                            int openCommentOffset = document.getLineOffset(i);
                            int lineDelimiterLength = document.getLineDelimiter(i) == null ? 0 : document.getLineDelimiter(i).length();
                            int closeCommentOffset = openCommentOffset + document.getLineLength(i) - lineDelimiterLength + "/*".length();
                            this.comment(document, openCommentOffset, closeCommentOffset);
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            model.changedModel();
            model.endRecording((Object)this);
            model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var11_17 = null;
        }
        model.changedModel();
        model.endRecording((Object)this);
        model.releaseFromEdit();
    }

    private void updateCurrentSelection(ITextEditor textEditor, Position selectionPosition, IDocument document, boolean updateStartOffset) {
        if (selectionPosition != null) {
            TextSelection selection = null;
            selection = updateStartOffset ? new TextSelection(document, selectionPosition.getOffset() - "/*".length(), selectionPosition.getLength() + "/*".length()) : new TextSelection(document, selectionPosition.getOffset(), selectionPosition.getLength());
            ISelectionProvider provider = textEditor.getSelectionProvider();
            if (provider != null) {
                provider.setSelection((ISelection)selection);
            }
            document.removePosition(selectionPosition);
        }
    }

    private boolean isCommentLine(IDocument document, int line) {
        boolean isComment = false;
        try {
            IRegion region = document.getLineInformation(line);
            String string = document.get(region.getOffset(), region.getLength()).trim();
            isComment = string.length() >= "/*".length() + "*/".length() && string.startsWith("/*") && string.endsWith("*/");
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
        return isComment;
    }

    private void comment(IDocument document, int openCommentOffset, int closeCommentOffset) {
        try {
            document.replace(openCommentOffset, 0, "/*");
            document.replace(closeCommentOffset, 0, "*/");
            this.removeOpenCloseComments(document, openCommentOffset + "/*".length(), closeCommentOffset - openCommentOffset - "*/".length());
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }

    private void uncomment(IDocument document, int openCommentOffset, int closeCommentOffset) {
        try {
            document.replace(openCommentOffset, "/*".length(), "");
            document.replace(closeCommentOffset, "*/".length(), "");
        }
        catch (BadLocationException e) {
            Logger.log(202, e.getMessage(), e);
        }
    }
}

