/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.util.Vector;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.AppServerWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WebappAccessor {
    private static Vector<String> applicationsStarted = new Vector();

    public static synchronized void start(String webappName) throws CoreException {
        WebappAccessor.start(webappName, "org.eclipse.birt.report.viewer");
    }

    public static synchronized void start(String webappName, String pluginID) throws CoreException {
        if (applicationsStarted.contains(webappName)) {
            return;
        }
        try {
            AppServerWrapper.getInstance().start(webappName, pluginID);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.birt.report.viewer", 0, ViewerPlugin.getFormattedResourceString("viewer.appserver.errorstart", new Object[0]), (Throwable)e));
        }
        applicationsStarted.add(webappName);
    }

    public static synchronized void start(String webappName, String pluginId, IPath path) throws CoreException {
        WebappAccessor.start(webappName, pluginId);
    }

    public static synchronized void stop(String webappName) throws CoreException {
        if (!applicationsStarted.contains(webappName)) {
            return;
        }
        try {
            AppServerWrapper.getInstance().stop(webappName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        applicationsStarted.remove(webappName);
    }

    public static synchronized void stopAll() throws CoreException {
        int i = 0;
        while (i < applicationsStarted.size()) {
            try {
                AppServerWrapper.getInstance().stop(applicationsStarted.get(i));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        applicationsStarted.clear();
    }

    public static int getPort(String webappName) {
        return AppServerWrapper.getInstance().getPort(webappName);
    }

    public static String getHost() {
        return AppServerWrapper.getInstance().getHost();
    }
}

