/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusOutlineAction
extends AbstractFocusViewAction {
    public static final String ID_CONTENT_OUTLINE = "org.eclipse.ui.views.ContentOutline";

    public FocusOutlineAction() {
        super(new InterestFilter(), true, false, false);
    }

    public void update(IEditorPart editorPart) {
        if (!super.isChecked()) {
            return;
        }
        boolean on = ContextUiPlugin.getDefault().getPreferenceStore().getBoolean(this.getGlobalPrefId());
        AbstractContextUiBridge bridge = ContextUi.getUiBridgeForEditor(editorPart);
        List<TreeViewer> outlineViewers = bridge.getContentOutlineViewers(editorPart);
        for (TreeViewer viewer : outlineViewers) {
            if (this.viewPart != null) {
                ContextUiPlugin.getViewerManager().addManagedViewer((StructuredViewer)viewer, (IWorkbenchPart)this.viewPart);
            }
            this.updateInterestFilter(on, (StructuredViewer)viewer);
            this.configureDecorator(viewer);
        }
    }

    private void configureDecorator(TreeViewer viewer) {
        if (viewer != null && !(viewer.getLabelProvider() instanceof DecoratingLabelProvider)) {
            viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)viewer.getLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        }
    }

    @Override
    public List<StructuredViewer> getViewers() {
        ArrayList<StructuredViewer> viewers = new ArrayList<StructuredViewer>();
        if (PlatformUI.getWorkbench().isClosing()) {
            return viewers;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorPart[] parts;
                IEditorPart[] iEditorPartArray = parts = page.getEditors();
                int n3 = parts.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorPart part = iEditorPartArray[n4];
                    AbstractContextUiBridge bridge = ContextUi.getUiBridgeForEditor(part);
                    List<TreeViewer> outlineViewers = bridge.getContentOutlineViewers(part);
                    for (TreeViewer viewer : outlineViewers) {
                        if (viewer == null || viewers.contains(viewer)) continue;
                        viewers.add((StructuredViewer)viewer);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return viewers;
    }

    public static FocusOutlineAction getOutlineActionForEditor(IEditorPart part) {
        IViewPart outlineView = part.getSite().getPage().findView(ID_CONTENT_OUTLINE);
        if (outlineView != null) {
            return (FocusOutlineAction)AbstractFocusViewAction.getActionForPart(outlineView);
        }
        return null;
    }
}

