/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFocusViewAction
extends Action
implements IViewActionDelegate,
IActionDelegate2,
ISelectionListener {
    public static final String PREF_ID_PREFIX = "org.eclipse.mylyn.ui.interest.filter.";
    private static Map<IViewPart, AbstractFocusViewAction> partMap = new WeakHashMap<IViewPart, AbstractFocusViewAction>();
    protected String globalPrefId;
    protected IAction initAction = null;
    protected final InterestFilter interestFilter;
    protected IViewPart viewPart;
    protected Map<StructuredViewer, List<ViewerFilter>> previousFilters = new WeakHashMap<StructuredViewer, List<ViewerFilter>>();
    private final boolean manageViewer;
    private final boolean manageFilters;
    private final boolean manageLinking;
    private boolean wasLinkingEnabled = false;
    private boolean wasRun = false;
    private Set<Class<?>> cachedPreservedFilters;
    @Deprecated
    protected boolean internalSuppressExpandAll = false;
    protected boolean showEmptyViewMessage = false;
    private final Map<StructuredViewer, EmptyContextDrawer> viewerToDrawerMap = new HashMap<StructuredViewer, EmptyContextDrawer>();
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case ACTIVATED: {
                    if (!AbstractFocusViewAction.this.updateEnablementWithContextActivation()) break;
                    AbstractFocusViewAction.this.updateEnablement(AbstractFocusViewAction.this.initAction);
                    break;
                }
                case DEACTIVATED: {
                    if (!AbstractFocusViewAction.this.updateEnablementWithContextActivation()) break;
                    AbstractFocusViewAction.this.updateEnablement(AbstractFocusViewAction.this.initAction);
                    AbstractFocusViewAction.this.update(false);
                }
            }
        }
    };
    private final IWorkbenchListener WORKBENCH_LISTENER = new IWorkbenchListener(){

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            if (AbstractFocusViewAction.this.wasRun && AbstractFocusViewAction.this.manageLinking) {
                AbstractFocusViewAction.this.setDefaultLinkingEnabled(AbstractFocusViewAction.this.wasLinkingEnabled);
            }
            List<StructuredViewer> viewers = AbstractFocusViewAction.this.getViewers();
            Set excludedFilters = AbstractFocusViewAction.this.getPreservedFilterClasses(false);
            for (StructuredViewer viewer : viewers) {
                if (!AbstractFocusViewAction.this.previousFilters.containsKey(viewer)) continue;
                for (ViewerFilter filter : AbstractFocusViewAction.this.previousFilters.get(viewer)) {
                    if (excludedFilters.contains(filter.getClass())) continue;
                    try {
                        viewer.addFilter(filter);
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Failed to restore filter: " + filter, t));
                    }
                }
                AbstractFocusViewAction.this.previousFilters.remove(viewer);
            }
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
        }
    };

    public static AbstractFocusViewAction getActionForPart(IViewPart part) {
        return partMap.get(part);
    }

    public IViewPart getPartForAction() {
        if (this.viewPart == null) {
            if (this instanceof IWorkbenchWindowActionDelegate) {
                PlatformUI.getWorkbench().isClosing();
            } else {
                throw new RuntimeException("error: viewPart is null");
            }
        }
        return this.viewPart;
    }

    public AbstractFocusViewAction(InterestFilter interestFilter, boolean manageViewer, boolean manageFilters, boolean manageLinking) {
        this.interestFilter = interestFilter;
        this.manageViewer = manageViewer;
        this.manageFilters = manageFilters;
        this.manageLinking = manageLinking;
        this.setText(Messages.AbstractFocusViewAction_Apply_Mylyn);
        this.setToolTipText(Messages.AbstractFocusViewAction_Apply_Mylyn);
        this.setImageDescriptor(TasksUiImages.CONTEXT_FOCUS);
        PlatformUI.getWorkbench().addWorkbenchListener(this.WORKBENCH_LISTENER);
        ContextCore.getContextManager().addListener(this.CONTEXT_LISTENER);
    }

    public void dispose() {
        partMap.remove(this.getPartForAction());
        if (this.viewPart != null && !PlatformUI.getWorkbench().isClosing()) {
            for (StructuredViewer viewer : this.getViewers()) {
                ContextUiPlugin.getViewerManager().removeManagedViewer(viewer, (IWorkbenchPart)this.viewPart);
            }
        }
        MonitorUi.removeWindowPostSelectionListener((ISelectionListener)this);
        ContextCore.getContextManager().removeListener(this.CONTEXT_LISTENER);
        PlatformUI.getWorkbench().removeWorkbenchListener(this.WORKBENCH_LISTENER);
    }

    public void init(IAction action) {
        this.initAction = action;
        this.initAction.setChecked(action.isChecked());
    }

    public void init(IViewPart view) {
        String id = view.getSite().getId();
        this.globalPrefId = PREF_ID_PREFIX + id;
        this.viewPart = view;
        partMap.put(view, this);
        this.wasLinkingEnabled = this.isDefaultLinkingEnabled();
    }

    protected boolean updateEnablementWithContextActivation() {
        return true;
    }

    public void run(IAction action) {
        this.setChecked(action.isChecked());
        this.valueChanged(action, action.isChecked(), true);
        this.wasRun = true;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void update() {
        if (this.globalPrefId != null) {
            this.update(ContextUiPlugin.getDefault().getPreferenceStore().getBoolean(this.globalPrefId));
        }
    }

    public void update(boolean on) {
        this.valueChanged(this.initAction, on, false);
        this.updateEnablement(this.initAction);
    }

    protected void valueChanged(IAction action, boolean on, boolean store) {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        boolean wasPaused = ContextCore.getContextManager().isContextCapturePaused();
        try {
            try {
                if (!wasPaused) {
                    ContextCore.getContextManager().setContextCapturePaused(true);
                }
                this.setChecked(on);
                if (action != null) {
                    action.setChecked(on);
                }
                if (store && ContextCorePlugin.getDefault() != null) {
                    ContextUiPlugin.getDefault().getPreferenceStore().setValue(this.globalPrefId, on);
                }
                List<StructuredViewer> viewers = this.getViewers();
                for (StructuredViewer viewer : viewers) {
                    if (this.viewPart != null && !viewer.getControl().isDisposed() && this.manageViewer) {
                        ContextUiPlugin.getViewerManager().addManagedViewer(viewer, (IWorkbenchPart)this.viewPart);
                    }
                    this.updateInterestFilter(on, viewer);
                }
                this.setManualFilteringAndLinkingEnabled(!on);
                if (this.manageLinking) {
                    this.updateLinking(on);
                }
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not install viewer manager on: " + this.globalPrefId, t));
                if (!wasPaused) {
                    ContextCore.getContextManager().setContextCapturePaused(false);
                }
            }
        }
        finally {
            if (!wasPaused) {
                ContextCore.getContextManager().setContextCapturePaused(false);
            }
        }
    }

    protected void updateEnablement(IAction action) {
        if (this.updateEnablementWithContextActivation() && action != null) {
            action.setEnabled(ContextCore.getContextManager().isContextActivePropertySet());
        }
    }

    private void updateLinking(boolean on) {
        if (on) {
            this.wasLinkingEnabled = this.isDefaultLinkingEnabled();
            MonitorUi.addWindowPostSelectionListener((ISelectionListener)this);
        } else {
            MonitorUi.removeWindowPostSelectionListener((ISelectionListener)this);
            this.setDefaultLinkingEnabled(this.wasLinkingEnabled);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.manageLinking && selection instanceof ITextSelection && part instanceof IEditorPart) {
            try {
                ISelection currentSelection;
                StructuredViewer viewer;
                ITextSelection textSelection;
                ISelection toSelect;
                List<StructuredViewer> viewers = this.getViewers();
                if (viewers.size() == 1 && (toSelect = this.resolveSelection((IEditorPart)part, textSelection = (ITextSelection)selection, viewer = this.getViewers().get(0))) != null && !toSelect.equals(currentSelection = viewer.getSelection())) {
                    this.select(viewer, toSelect);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    protected void select(StructuredViewer viewer, ISelection selection) {
        viewer.setSelection(selection, true);
    }

    protected ISelection resolveSelection(IEditorPart part, ITextSelection selection, StructuredViewer viewer) throws CoreException {
        return null;
    }

    protected void setDefaultLinkingEnabled(boolean on) {
    }

    protected boolean isDefaultLinkingEnabled() {
        return false;
    }

    protected void setManualFilteringAndLinkingEnabled(boolean on) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.updateEnablement(action);
    }

    public void updateInterestFilter(boolean on, StructuredViewer viewer) {
        if (viewer != null) {
            if (on) {
                if (this.showEmptyViewMessage && viewer instanceof TreeViewer) {
                    Tree tree = ((TreeViewer)viewer).getTree();
                    Listener drawingListener = this.viewerToDrawerMap.get(viewer);
                    if (drawingListener == null) {
                        EmptyContextDrawer drawer = new EmptyContextDrawer(tree);
                        this.viewerToDrawerMap.put(viewer, drawer);
                        tree.addListener(9, (Listener)drawer);
                    }
                }
                this.installInterestFilter(viewer);
                ContextUiPlugin.getViewerManager().addFilteredViewer(viewer, this);
            } else {
                if (this.showEmptyViewMessage && viewer instanceof TreeViewer) {
                    Tree tree = ((TreeViewer)viewer).getTree();
                    EmptyContextDrawer drawer = this.viewerToDrawerMap.remove(viewer);
                    if (drawer != null) {
                        tree.removeListener(9, (Listener)drawer);
                    }
                }
                ContextUiPlugin.getViewerManager().removeFilteredViewer(viewer);
                this.uninstallInterestFilter(viewer);
            }
        }
    }

    public abstract List<StructuredViewer> getViewers();

    private Set<Class<?>> getPreservedFilterClasses(boolean cacheFilters) {
        if (ContextUiPlugin.getDefault() == null || this.viewPart == null) {
            return Collections.emptySet();
        }
        if (this.cachedPreservedFilters == null && cacheFilters) {
            try {
                this.cachedPreservedFilters = ContextUiPlugin.getDefault().getPreservedFilterClasses(this.viewPart.getSite().getId());
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not determine preserved filters", (Throwable)e));
            }
        }
        if (this.cachedPreservedFilters != null) {
            return this.cachedPreservedFilters;
        }
        return Collections.emptySet();
    }

    protected boolean installInterestFilter(StructuredViewer viewer) {
        if (viewer == null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "The viewer to install interest filter is null", (Throwable)new Exception()));
            return false;
        }
        if (viewer.getControl().isDisposed() && this.manageViewer) {
            return false;
        }
        if (this.previousFilters.containsKey(viewer) && this.hasInterestFilter(viewer)) {
            return false;
        }
        try {
            viewer.getControl().setRedraw(false);
            this.previousFilters.put(viewer, Arrays.asList(viewer.getFilters()));
            if (this.viewPart != null && this.manageFilters) {
                HashSet<ViewerFilter> toAdd = new HashSet<ViewerFilter>();
                Set<Class<?>> preservedFilterClasses = this.getPreservedFilterClasses(true);
                for (ViewerFilter filter : this.previousFilters.get(viewer)) {
                    if (!preservedFilterClasses.contains(filter.getClass()) && !this.isPreservedFilter(filter)) continue;
                    toAdd.add(filter);
                }
                toAdd.add(this.interestFilter);
                viewer.setFilters(toAdd.toArray(new ViewerFilter[toAdd.size()]));
            } else {
                viewer.addFilter((ViewerFilter)this.interestFilter);
            }
            if (viewer instanceof TreeViewer && !this.internalSuppressExpandAll) {
                ((TreeViewer)viewer).expandAll();
            }
            return true;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not install viewer filter on: " + this.globalPrefId, t));
        }
        finally {
            viewer.getControl().setRedraw(true);
            this.internalSuppressExpandAll = false;
        }
        return false;
    }

    private boolean hasInterestFilter(StructuredViewer viewer) {
        ViewerFilter[] viewerFilterArray = viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter == this.getInterestFilter()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isPreservedFilter(ViewerFilter filter) {
        return false;
    }

    protected void uninstallInterestFilter(StructuredViewer viewer) {
        if (viewer == null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "The viewer to uninstall interest filter is null", (Throwable)new Exception()));
            return;
        }
        if (viewer.getControl().isDisposed()) {
            ContextUiPlugin.getViewerManager().removeManagedViewer(viewer, (IWorkbenchPart)this.viewPart);
            return;
        }
        try {
            try {
                viewer.getControl().setRedraw(false);
                List<ViewerFilter> restoreFilters = this.previousFilters.remove(viewer);
                if (restoreFilters != null && this.viewPart != null && this.manageFilters) {
                    HashSet<ViewerFilter> filters = new HashSet<ViewerFilter>(restoreFilters);
                    filters.addAll(Arrays.asList(viewer.getFilters()));
                    Iterator it = filters.iterator();
                    while (it.hasNext()) {
                        if (!(it.next() instanceof InterestFilter)) continue;
                        it.remove();
                    }
                    viewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
                }
                viewer.removeFilter((ViewerFilter)this.interestFilter);
                this.interestFilter.resetTemporarilyUnfiltered();
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not uninstall interest viewer filter on: " + this.globalPrefId, t));
                viewer.getControl().setRedraw(true);
            }
        }
        finally {
            viewer.getControl().setRedraw(true);
        }
    }

    public String getGlobalPrefId() {
        return this.globalPrefId;
    }

    public InterestFilter getInterestFilter() {
        return this.interestFilter;
    }

    protected String getEmptyViewMessage() {
        return Messages.AbstractFocusViewAction_Empty_task_context;
    }

    private class EmptyContextDrawer
    implements Listener {
        private final String LABEL;
        private final Image IMAGE;
        private final Tree tree;

        EmptyContextDrawer(Tree tree) {
            this.LABEL = AbstractFocusViewAction.this.getEmptyViewMessage();
            this.IMAGE = CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_FOCUS);
            this.tree = tree;
        }

        public void handleEvent(Event event) {
            if (this.tree != null && this.tree.getItemCount() == 0) {
                switch (event.type) {
                    case 9: {
                        int offset = 7;
                        event.gc.drawImage(this.IMAGE, offset, offset);
                        event.gc.drawText(this.LABEL, offset + this.IMAGE.getBounds().width + 5, offset);
                    }
                }
            }
        }
    }
}

