/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import org.eclipse.mylyn.context.core.IDegreeOfInterest;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.core.DegreeOfInterest;
import org.eclipse.mylyn.internal.context.core.InteractionContext;

public class InteractionContextRelation
implements IInteractionRelation {
    private final DegreeOfInterest interest;
    private final String structureKind;
    private final String relationshipHandle;
    private final IInteractionElement source;
    private final IInteractionElement target;

    public InteractionContextRelation(String kind, String edgeKind, IInteractionElement source, IInteractionElement target, InteractionContext context) {
        this.interest = new DegreeOfInterest(context, context.getScaling());
        this.structureKind = kind;
        this.relationshipHandle = edgeKind;
        this.target = target;
        this.source = source;
    }

    public IInteractionElement getTarget() {
        return this.target;
    }

    public IDegreeOfInterest getInterest() {
        return this.interest;
    }

    public String toString() {
        return "(rel: " + this.relationshipHandle + ", source: " + this.source.getHandleIdentifier() + ", target: " + this.target.getHandleIdentifier() + ")";
    }

    public String getLabel() {
        return this.toString();
    }

    public String getRelationshipHandle() {
        return this.relationshipHandle;
    }

    public String getContentType() {
        return this.structureKind;
    }

    public IInteractionElement getSource() {
        return this.source;
    }
}

