/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.model;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.core.internal.model.StylesheetParserData;
import org.eclipse.wst.xsl.core.internal.model.XSLElementFactory;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.core.model.XSLElement;
import org.eclipse.wst.xsl.core.model.XSLModelObject;
import org.eclipse.wst.xsl.core.model.XSLNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLModelObjectFactory {
    private static final String VARIABLE = "variable";
    private static final String FUNCTION = "function";
    private static final String WITH_PARAM = "with-param";
    private static final String CALL_TEMPLATE = "call-template";
    private static final String PARAM = "param";
    private static final String TEMPLATE = "template";
    private static final String IMPORT = "import";
    private static final String INCLUDE = "include";
    private static final String STYLESHEET = "stylesheet";
    private Element element;
    private XSLElement xslEl;
    private StylesheetParserData stylesheetParserData;

    public XSLModelObjectFactory(Element element, XSLElement xslEl, StylesheetParserData data) {
        this.element = element;
        this.xslEl = xslEl;
        this.stylesheetParserData = data;
    }

    public XSLElement createXSLModelObject() {
        String elName = this.element.getLocalName();
        int elementSize = this.stylesheetParserData.getElementStack().size();
        XSLElementFactory factory = new XSLElementFactory(this.stylesheetParserData, this.element);
        if (elementSize == 0) {
            if (STYLESHEET.equals(elName)) {
                this.xslEl = factory.createStyleSheet();
            }
        } else {
            this.xslEl = INCLUDE.equals(elName) && elementSize == 1 ? factory.createInclude() : (IMPORT.equals(elName) && elementSize == 1 ? factory.createImport() : (TEMPLATE.equals(elName) && elementSize == 1 ? factory.createTemplate() : (PARAM.equals(elName) && this.notParentStylesheet() ? factory.createParamater() : (CALL_TEMPLATE.equals(elName) && elementSize >= 2 ? factory.createCallTemplate() : (WITH_PARAM.equals(elName) && elementSize >= 3 && this.stylesheetParserData.getCallTemplates().size() > 0 ? factory.createWithParamParm() : (this.isVariable(elName) ? factory.createVariable(this.xslEl) : (FUNCTION.equals(elName) ? factory.createFunction() : factory.createXSLElement())))))));
        }
        if (this.xslEl != null) {
            this.configure((IDOMNode)this.element, this.xslEl);
        }
        return this.xslEl;
    }

    private boolean isVariable(String elName) {
        return VARIABLE.equals(elName) || PARAM.equals(elName);
    }

    private boolean notParentStylesheet() {
        return this.stylesheetParserData.getParentEl().getModelType() != XSLModelObject.Type.STYLESHEET;
    }

    private void configure(IDOMNode node, XSLElement element) {
        XSLModelObjectFactory.setPositionInfo(node, element);
        IDOMElement domElem = (IDOMElement)node;
        element.setName(domElem.getLocalName());
        NamedNodeMap map = node.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            IDOMAttr attr = (IDOMAttr)map.item(i);
            XSLAttribute xslatt = new XSLAttribute(element, attr.getName(), attr.getValue());
            XSLModelObjectFactory.setPositionInfo((IDOMNode)attr, xslatt);
            element.setAttribute(xslatt);
            ++i;
        }
        this.setParentElement(node, element);
    }

    private void setParentElement(IDOMNode node, XSLElement element) {
        if (this.stylesheetParserData.getParentEl() != null) {
            this.stylesheetParserData.getParentEl().addChild(element);
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node lnode = nodeList.item(i);
                if (lnode.getNodeType() == 1) {
                    this.stylesheetParserData.setParentEl(element);
                    break;
                }
                ++i;
            }
        }
    }

    private static void setPositionInfo(IDOMNode node, XSLNode inc) {
        try {
            IStructuredDocument structuredDocument = node.getStructuredDocument();
            int line = structuredDocument.getLineOfOffset(node.getStartOffset());
            int lineOffset = structuredDocument.getLineOffset(line);
            int col = node.getStartOffset() - lineOffset;
            inc.setOffset(node.getStartOffset());
            inc.setLineNumber(line);
            inc.setColumnNumber(col);
            inc.setLength(node.getLength());
        }
        catch (BadLocationException e) {
            XSLCorePlugin.log(e);
        }
    }
}

