/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.model.event;

import java.util.Collection;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListRemoveEvent
extends ListEvent {
    private final int index;
    private final Object[] items;
    private static final long serialVersionUID = 1L;

    public ListRemoveEvent(Model source, String listName, int index, Object item) {
        this(source, listName, index, new Object[]{item});
    }

    public ListRemoveEvent(Model source, String listName, int index, Collection<?> items) {
        this(source, listName, index, items.toArray());
    }

    private ListRemoveEvent(Model source, String listName, int index, Object[] items) {
        super(source, listName);
        this.index = index;
        this.items = items;
    }

    public int getIndex() {
        return this.index;
    }

    public Iterable<?> getItems() {
        return new ArrayIterable<Object>(this.items);
    }

    public int getItemsSize() {
        return this.items.length;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(": ");
        StringTools.append(sb, this.items);
    }

    public ListRemoveEvent clone(Model newSource) {
        return this.clone(newSource, this.listName);
    }

    public ListRemoveEvent clone(Model newSource, String newListName) {
        return this.clone(newSource, newListName, 0);
    }

    public ListRemoveEvent clone(Model newSource, String newListName, int offset) {
        return new ListRemoveEvent(newSource, newListName, this.index + offset, this.items);
    }
}

