/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyListIterator;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListValueModelWrapper;
import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationListValueModelAdapter<E1, E2>
extends ListValueModelWrapper<E1>
implements ListValueModel<E2> {
    protected Transformer<E1, E2> transformer;
    protected final List<E2> transformedList;

    public TransformationListValueModelAdapter(ListValueModel<? extends E1> listHolder, Transformer<E1, E2> transformer) {
        super(listHolder);
        this.transformer = transformer;
        this.transformedList = new ArrayList<E2>();
    }

    public TransformationListValueModelAdapter(ListValueModel<? extends E1> listHolder) {
        this(listHolder, Transformer.Null.instance());
    }

    public TransformationListValueModelAdapter(CollectionValueModel<? extends E1> collectionHolder, Transformer<E1, E2> transformer) {
        this(new CollectionListValueModelAdapter<E1>(collectionHolder), transformer);
    }

    public TransformationListValueModelAdapter(CollectionValueModel<? extends E1> collectionHolder) {
        this((ListValueModel<? extends E1>)new CollectionListValueModelAdapter<E1>(collectionHolder));
    }

    @Override
    public Iterator<E2> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E2> listIterator() {
        return new ReadOnlyListIterator<E2>(this.transformedList);
    }

    @Override
    public E2 get(int index) {
        return this.transformedList.get(index);
    }

    @Override
    public int size() {
        return this.transformedList.size();
    }

    @Override
    public Object[] toArray() {
        return this.transformedList.toArray();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.transformedList.addAll(this.transformItems(this.listHolder));
    }

    @Override
    protected void disengageModel() {
        super.disengageModel();
        this.transformedList.clear();
    }

    protected List<E2> transformItems(ListValueModel<? extends E1> lvm) {
        return this.transformItems(lvm, lvm.size());
    }

    protected List<E2> transformItems(ListAddEvent event) {
        return this.transformItems(this.getItems(event), event.getItemsSize());
    }

    protected List<E2> transformItems(ListRemoveEvent event) {
        return this.transformItems(this.getItems(event), event.getItemsSize());
    }

    protected List<E2> transformNewItems(ListReplaceEvent event) {
        return this.transformItems(this.getNewItems(event), event.getItemsSize());
    }

    protected List<E2> transformOldItems(ListReplaceEvent event) {
        return this.transformItems(this.getOldItems(event), event.getItemsSize());
    }

    protected List<E2> transformItems(Iterable<? extends E1> items, int size) {
        ArrayList<E2> result = new ArrayList<E2>(size);
        for (E1 item : items) {
            result.add(this.transformItem(item));
        }
        return result;
    }

    protected E2 transformItem(E1 item) {
        return this.transformer.transform(item);
    }

    public void setTransformer(Transformer<E1, E2> transformer) {
        this.transformer = transformer;
        this.rebuildTransformedList();
    }

    protected void rebuildTransformedList() {
        this.transformedList.clear();
        this.transformedList.addAll(this.transformItems(this.listHolder));
        this.fireListChanged("list values", this.transformedList);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.transformedList);
    }

    @Override
    protected void itemsAdded(ListAddEvent event) {
        this.addItemsToList(event.getIndex(), this.transformItems(event), this.transformedList, "list values");
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent event) {
        this.removeItemsFromList(event.getIndex(), event.getItemsSize(), this.transformedList, "list values");
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent event) {
        this.setItemsInList(event.getIndex(), this.transformNewItems(event), this.transformedList, "list values");
    }

    @Override
    protected void itemsMoved(ListMoveEvent event) {
        this.moveItemsInList(event.getTargetIndex(), event.getSourceIndex(), event.getLength(), this.transformedList, "list values");
    }

    @Override
    protected void listCleared(ListClearEvent event) {
        this.clearList(this.transformedList, "list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        this.rebuildTransformedList();
    }
}

