/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterables;

import java.util.Iterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationIterable<E1, E2>
implements Iterable<E2> {
    private final Iterable<? extends E1> iterable;
    private final Transformer<E1, ? extends E2> transformer;

    public TransformationIterable(Iterable<? extends E1> iterable) {
        this.iterable = iterable;
        this.transformer = this.buildDefaultTransformer();
    }

    public TransformationIterable(Iterable<? extends E1> iterable, Transformer<E1, ? extends E2> transformer) {
        this.iterable = iterable;
        this.transformer = transformer;
    }

    protected Transformer<E1, ? extends E2> buildDefaultTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public Iterator<E2> iterator() {
        return new TransformationIterator<E1, E2>(this.iterable.iterator(), this.transformer);
    }

    protected E2 transform(E1 o) {
        throw new RuntimeException("This method was not overridden.");
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultTransformer
    implements Transformer<E1, E2> {
        protected DefaultTransformer() {
        }

        @Override
        public E2 transform(E1 o) {
            return TransformationIterable.this.transform(o);
        }
    }
}

