/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterables;

import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.ArrayListIterable;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyCompositeListIterable<E>
implements ListIterable<E> {
    private final ListIterable<? extends ListIterable<? extends E>> iterables;

    public ReadOnlyCompositeListIterable(ListIterable<? extends ListIterable<? extends E>> iterables) {
        this.iterables = iterables;
    }

    public ReadOnlyCompositeListIterable(E object, ListIterable<? extends E> iterable) {
        this(new ListIterable[]{new SingleElementListIterable<E>(object), iterable});
    }

    public ReadOnlyCompositeListIterable(ListIterable<? extends E> iterable, E object) {
        this(new ListIterable[]{iterable, new SingleElementListIterable<E>(object)});
    }

    public ReadOnlyCompositeListIterable(ListIterable<? extends E> ... iterables) {
        this((ListIterable<ListIterable<? extends E>>)new ArrayListIterable<ListIterable<? extends E>>(iterables));
    }

    @Override
    public ListIterator<E> iterator() {
        return new ReadOnlyCompositeListIterator<E>(this.iterators());
    }

    protected ListIterator<? extends ListIterator<? extends E>> iterators() {
        return new TransformationListIterator<ListIterable<? extends E>, ListIterator<? extends E>>(this.iterables()){

            @Override
            protected ListIterator<? extends E> transform(ListIterable<? extends E> next) {
                return next.iterator();
            }
        };
    }

    protected ListIterator<? extends ListIterable<? extends E>> iterables() {
        return this.iterables.iterator();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.iterables);
    }
}

