/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;

public class Range
implements Cloneable,
Serializable {
    public final int start;
    public final int end;
    public final int size;
    private static final long serialVersionUID = 1L;

    public Range(int start, int end) {
        this.start = start;
        this.end = end;
        this.size = end - start + 1;
    }

    public boolean includes(int index) {
        return this.start <= index && index <= this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range otherRange = (Range)o;
        return this.start == otherRange.start && this.end == otherRange.end;
    }

    public int hashCode() {
        return this.start ^ this.end;
    }

    public Range clone() {
        try {
            return (Range)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(91 + this.start) + ", " + this.end + ']';
    }
}

