/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jst.server.preview.adapter.internal.IMemento;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLMemento
implements IMemento {
    private Document factory;
    private Element element;

    private XMLMemento(Document doc, Element el) {
        this.factory = doc;
        this.element = el;
    }

    public IMemento createChild(String type) {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    public static XMLMemento createWriteRoot(String type) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    public void putInteger(String key, int n) {
        this.element.setAttribute(key, String.valueOf(n));
    }

    public void putString(String key, String value) {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    private void save(OutputStream os) throws IOException {
        StreamResult result = new StreamResult(os);
        DOMSource source = new DOMSource(this.factory);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public void saveToFile(String filename) throws IOException {
        FileOutputStream w = null;
        try {
            try {
                w = new FileOutputStream(filename);
                this.save(w);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (w != null) {
            try {
                w.close();
            }
            catch (Exception exception) {}
        }
    }
}

