/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMedian
extends AggrFunction {
    public String getName() {
        return "MEDIAN";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 0;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalMedian.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalMedian.displayName");
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private List list;
        private Object ret = null;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.list = new ArrayList();
            this.ret = null;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (args[0] != null) {
                if (this.calculator == null) {
                    this.calculator = CalculatorFactory.getCalculator(args[0].getClass());
                }
                this.list.add(this.calculator.getTypedObject(args[0]));
            }
        }

        public void finish() throws DataException {
            int size = this.list.size();
            if (size > 0) {
                Object[] values = this.list.toArray();
                Arrays.sort(values);
                if (size % 2 == 0) {
                    Object d1 = values[size / 2 - 1];
                    Object d2 = values[size / 2];
                    this.ret = this.calculator.divide(this.calculator.add(d1, d2), 2.0);
                } else {
                    this.ret = values[size / 2];
                }
                this.ret = this.calculator.getTypedObject(this.ret);
            }
            super.finish();
        }

        public Object getSummaryValue() {
            return this.ret;
        }
    }
}

