/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.extension.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.DataExtractionFormatInfo;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ExtendedGenerateExecutor;
import org.eclipse.birt.report.engine.extension.IDataExtractionExtension;
import org.eclipse.birt.report.engine.extension.IExtendedItemFactory;
import org.eclipse.birt.report.engine.extension.IReportEventHandler;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemGeneration;
import org.eclipse.birt.report.engine.extension.IReportItemPreparation;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IReportItemQuery;

public class ExtensionManager {
    protected static Logger logger = Logger.getLogger(ExtensionManager.class.getName());
    public static final String EXTENSION_POINT_EMITTERS = "org.eclipse.birt.report.engine.emitters";
    public static final String EXTENSION_POINT_GENERATION = "org.eclipse.birt.report.engine.reportitemGeneration";
    public static final String EXTENSION_POINT_PRESENTATION = "org.eclipse.birt.report.engine.reportitemPresentation";
    public static final String EXTENSION_POINT_QUERY = "org.eclipse.birt.report.engine.reportitemQuery";
    public static final String EXTENSION_POINT_EVENTHANDLER = "org.eclipse.birt.report.engine.reportEventHandler";
    public static final String EXTENSION_POINT_PREPARATION = "org.eclipse.birt.report.engine.reportItemPreparation";
    public static final String EXTENSION_POINT_DATAEXTRACTION = "org.eclipse.birt.report.engine.dataExtraction";
    public static final String EXTENSION_POINT_EXTENDED_ITEM_FACTORY = "org.eclipse.birt.report.engine.extendedItemFactory";
    protected static ExtensionManager sm_instance;
    protected HashMap generationExtensions = new HashMap();
    protected HashMap presentationExtensions = new HashMap();
    protected HashMap queryExtensions = new HashMap();
    protected ArrayList<EmitterInfo> emitterExtensions = new ArrayList();
    protected HashMap eventHandlerExtensions = new HashMap();
    protected HashMap preparationExtensions = new HashMap();
    protected HashMap factories = new HashMap();
    protected HashMap formats = new HashMap();
    protected HashMap emitters = new HashMap();
    protected Map dataExtractionFormats = new HashMap();
    public static final String PAGE_BREAK_PAGINATION = "page-break-pagination";
    public static final String PAPER_SIZE_PAGINATION = "paper-size-pagination";
    public static final String NO_PAGINATION = "no-pagination";
    public static final Boolean DEFAULT_OUTPUT_DISPLAY_NONE;
    public static final String DEFAULT_SUPPORTED_IMAGE_FORMATS = "PNG;GIF;JPG;BMP";
    public static final boolean DEFAULT_NEED_OUTPUT_RESULTSET = false;

    static {
        DEFAULT_OUTPUT_DISPLAY_NONE = new Boolean(false);
    }

    ExtensionManager() {
        this.loadGenerationExtensionDefns();
        this.loadPresentationExtensionDefns();
        this.loadQueryExtensionDefns();
        this.loadEmitterExtensionDefns();
        this.loadEventHandlerExtensionDefns();
        this.loadPreparationExtensionDefns();
        this.loadDataExtractionExtensions();
        this.loadExtendedItems();
    }

    private static synchronized void createInstance() {
        if (sm_instance == null) {
            sm_instance = new ExtensionManager();
        }
    }

    public static ExtensionManager getInstance() {
        if (sm_instance == null) {
            ExtensionManager.createInstance();
        }
        return sm_instance;
    }

    public IReportItemExecutor createReportItemExecutor(ExecutorManager manager, String itemType) {
        IConfigurationElement config = (IConfigurationElement)this.generationExtensions.get(itemType);
        if (config != null) {
            Object object = this.createObject(config, "class");
            if (object instanceof IReportItemExecutor) {
                return (IReportItemExecutor)object;
            }
            if (object instanceof IReportItemGeneration) {
                return new ExtendedGenerateExecutor(manager, (IReportItemGeneration)object);
            }
            logger.log(Level.WARNING, "Create Report Item Executor fail, Config not exist class: {0}", config.getName());
        }
        return new ExtendedGenerateExecutor(manager, null);
    }

    public IReportItemPresentation createPresentationItem(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.presentationExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportItemPresentation) {
            return (IReportItemPresentation)object;
        }
        return null;
    }

    public IReportItemQuery createQueryItem(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.queryExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportItemQuery) {
            return (IReportItemQuery)object;
        }
        return null;
    }

    public boolean getAllRows(String itemType) {
        IConfigurationElement config = (IConfigurationElement)this.queryExtensions.get(itemType);
        if (config != null) {
            return Boolean.valueOf(config.getAttribute("getAllRows"));
        }
        return false;
    }

    public IContentEmitter createEmitter(String format, String id) {
        Object object;
        IConfigurationElement config = null;
        if (id != null) {
            for (EmitterInfo emitterInfo : this.emitterExtensions) {
                if (!id.equalsIgnoreCase(emitterInfo.getID())) continue;
                config = emitterInfo.getEmitter();
                break;
            }
        } else {
            for (EmitterInfo emitterInfo : this.emitterExtensions) {
                if (!format.equalsIgnoreCase(emitterInfo.getFormat())) continue;
                config = emitterInfo.getEmitter();
                break;
            }
        }
        if (config != null && (object = this.createObject(config, "class")) instanceof IContentEmitter) {
            return (IContentEmitter)object;
        }
        return null;
    }

    public IContentEmitter createEmitter(String format) {
        Object object;
        if (format == null) {
            return null;
        }
        IConfigurationElement config = null;
        int i = 0;
        while (i < this.emitterExtensions.size()) {
            EmitterInfo emitterInfo = this.emitterExtensions.get(i);
            if (format.equalsIgnoreCase(emitterInfo.getFormat())) {
                config = emitterInfo.getEmitter();
                break;
            }
            ++i;
        }
        if (config != null && (object = this.createObject(config, "class")) instanceof IContentEmitter) {
            return (IContentEmitter)object;
        }
        return null;
    }

    public IDataExtractionExtension createDataExtractionExtensionById(String id) {
        Object object;
        if (id == null) {
            return null;
        }
        DataExtractionFormatInfo info = (DataExtractionFormatInfo)this.dataExtractionFormats.get(id);
        IConfigurationElement config = info.getDataExtractionExtension();
        if (config != null && (object = this.createObject(config, "class")) instanceof IDataExtractionExtension) {
            return (IDataExtractionExtension)object;
        }
        return null;
    }

    public IDataExtractionExtension createDataExtractionExtensionByFormat(String format) {
        Object object;
        if (format == null) {
            return null;
        }
        IConfigurationElement config = null;
        for (DataExtractionFormatInfo info : this.dataExtractionFormats.values()) {
            if (!format.equals(info.getFormat())) continue;
            config = info.getDataExtractionExtension();
            break;
        }
        if (config != null && (object = this.createObject(config, "class")) instanceof IDataExtractionExtension) {
            return (IDataExtractionExtension)object;
        }
        return null;
    }

    public IReportEventHandler createEventHandler(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.eventHandlerExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportEventHandler) {
            return (IReportEventHandler)object;
        }
        return null;
    }

    public IReportItemPreparation createPreparationItem(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.preparationExtensions.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IReportItemPreparation) {
            return (IReportItemPreparation)object;
        }
        return null;
    }

    public IExtendedItemFactory createExtendedItemFactory(String itemType) {
        Object object;
        IConfigurationElement config = (IConfigurationElement)this.factories.get(itemType);
        if (config != null && (object = this.createObject(config, "class")) instanceof IExtendedItemFactory) {
            return (IExtendedItemFactory)object;
        }
        return null;
    }

    public Collection getSupportedFormat() {
        return this.formats.keySet();
    }

    public EmitterInfo[] getEmitterInfo() {
        EmitterInfo[] infos = new EmitterInfo[this.emitters.size()];
        Object[] keys = this.emitters.keySet().toArray();
        int index = 0;
        int length = keys.length;
        while (index < length) {
            infos[index] = (EmitterInfo)this.emitters.get(keys[index].toString());
            ++index;
        }
        return infos;
    }

    protected Object createObject(IConfigurationElement config, String property) {
        block3: {
            try {
                Object object;
                String value = config.getAttribute(property);
                if (value != null && (object = config.createExecutableExtension(property)) != null) {
                    return object;
                }
            }
            catch (FrameworkException frameworkException) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Can not instantiate class {0} with property {1}.", new String[]{config.getAttribute("class"), property});
            }
        }
        return null;
    }

    protected void loadGenerationExtensionDefns() {
        IExtension[] exts = this.getExtensions(EXTENSION_POINT_GENERATION);
        if (exts == null) {
            return;
        }
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.generationExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load generation extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    protected void loadPresentationExtensionDefns() {
        IExtension[] exts = this.getExtensions(EXTENSION_POINT_PRESENTATION);
        if (exts == null) {
            return;
        }
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.presentationExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load prsentation extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    protected void loadQueryExtensionDefns() {
        IExtension[] exts = this.getExtensions(EXTENSION_POINT_QUERY);
        if (exts == null) {
            return;
        }
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.queryExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load query extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    protected void loadEmitterExtensionDefns() {
        IExtension[] exts = this.getExtensions(EXTENSION_POINT_EMITTERS);
        if (exts == null) {
            return;
        }
        int i = 0;
        while (i < exts.length) {
            String namespace = exts[i].getNamespace();
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                block10: {
                    int priority;
                    String id;
                    block9: {
                        EmitterInfo info;
                        id = configs[j].getAttribute("id");
                        String overridePriority = configs[j].getAttribute("overridePriority");
                        priority = 0;
                        if (overridePriority != null) {
                            priority = new Integer(overridePriority);
                        }
                        if ((info = (EmitterInfo)this.emitters.get(id)) == null) break block9;
                        if (info.getOverridePriority() >= priority) break block10;
                        this.emitterExtensions.remove(info);
                    }
                    String format = configs[j].getAttribute("format");
                    String mimeType = configs[j].getAttribute("mimeType");
                    String pagination = configs[j].getAttribute("pagination");
                    String supportedImageFormats = configs[j].getAttribute("supportedImageFormats");
                    if (pagination == null) {
                        pagination = PAGE_BREAK_PAGINATION;
                    }
                    String icon = configs[j].getAttribute("icon");
                    Boolean outDisplayNone = new Boolean(configs[j].getAttribute("outputDisplayNone"));
                    String fileExtension = configs[j].getAttribute("fileExtension");
                    Boolean isHidden = new Boolean(configs[j].getAttribute("isHidden"));
                    boolean needOutputResultSet = Boolean.valueOf(configs[j].getAttribute("needOutputResultSet"));
                    EmitterInfo emitterInfo = new EmitterInfo(format, id, pagination, mimeType, icon, namespace, fileExtension, outDisplayNone, isHidden, supportedImageFormats, needOutputResultSet, configs[j]);
                    emitterInfo.setOverridePriority(priority);
                    this.emitterExtensions.add(emitterInfo);
                    assert (format != null);
                    this.formats.put(format, emitterInfo);
                    this.emitters.put(id, emitterInfo);
                    logger.log(Level.FINE, "Load {0} emitter {1}", new String[]{format, id});
                }
                ++j;
            }
            ++i;
        }
    }

    protected void loadEventHandlerExtensionDefns() {
        IExtension[] exts = this.getExtensions(EXTENSION_POINT_EVENTHANDLER);
        if (exts == null) {
            return;
        }
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.eventHandlerExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load reportEventHandler extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    protected void loadPreparationExtensionDefns() {
        IExtension[] exts = this.getExtensions(EXTENSION_POINT_PREPARATION);
        if (exts == null) {
            return;
        }
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.preparationExtensions.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load reportItemPrepare extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    protected void loadExtendedItems() {
        IExtension[] exts = this.getExtensions(EXTENSION_POINT_EXTENDED_ITEM_FACTORY);
        if (exts == null) {
            return;
        }
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String itemName = configs[j].getAttribute("name");
                this.factories.put(itemName, configs[j]);
                logger.log(Level.FINE, "Load extendedItem extension: {0}", itemName);
                ++j;
            }
            ++i;
        }
    }

    private IExtension[] getExtensions(String extensionPoint) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(extensionPoint);
        if (extPoint == null) {
            return null;
        }
        IExtension[] exts = extPoint.getExtensions();
        logger.log(Level.FINE, "Start load extension point: {0}", extensionPoint);
        return exts;
    }

    public void loadDataExtractionExtensions() {
        IExtension[] exts = this.getExtensions(EXTENSION_POINT_DATAEXTRACTION);
        if (exts == null) {
            return;
        }
        int i = 0;
        while (i < exts.length) {
            IConfigurationElement[] configs = exts[i].getConfigurationElements();
            int j = 0;
            while (j < configs.length) {
                String id = configs[j].getAttribute("id");
                String format = configs[j].getAttribute("format");
                String mimeType = configs[j].getAttribute("mimeType");
                String name = configs[j].getAttribute("name");
                Boolean isHidden = new Boolean(configs[j].getAttribute("isHidden"));
                DataExtractionFormatInfo info = new DataExtractionFormatInfo(id, format, mimeType, name, isHidden, configs[j]);
                this.dataExtractionFormats.put(id, info);
                logger.log(Level.FINE, "Load data extraction extension: {0}", id);
                ++j;
            }
            ++i;
        }
    }

    public String getMIMEType(String format) {
        if (format != null) {
            format = format.toLowerCase();
        }
        if (this.formats.containsKey(format)) {
            return ((EmitterInfo)this.formats.get(format)).getMimeType();
        }
        return null;
    }

    public String getPagination(String emitterId) {
        if (emitterId != null) {
            for (EmitterInfo emitterInfo : this.emitterExtensions) {
                if (!emitterId.equals(emitterInfo.getID())) continue;
                return emitterInfo.getPagination();
            }
        }
        return PAGE_BREAK_PAGINATION;
    }

    public Boolean getOutputDisplayNone(String emitterId) {
        if (emitterId != null) {
            for (EmitterInfo emitterInfo : this.emitterExtensions) {
                if (!emitterId.equals(emitterInfo.getID())) continue;
                return emitterInfo.getOutputDisplayNone();
            }
        }
        return DEFAULT_OUTPUT_DISPLAY_NONE;
    }

    public String getSupportedImageFormats(String emitterId) {
        String supportedImageFormats;
        EmitterInfo emitterInfo;
        if (emitterId != null && (emitterInfo = (EmitterInfo)this.emitters.get(emitterId)) != null && (supportedImageFormats = emitterInfo.getSupportedImageFormats()) != null) {
            return supportedImageFormats;
        }
        return DEFAULT_SUPPORTED_IMAGE_FORMATS;
    }

    public boolean needOutputResultSet(String emitterId) {
        EmitterInfo emitterInfo = this.getEmitter(emitterId);
        return emitterInfo == null ? false : emitterInfo.needOutputResultSet();
    }

    private EmitterInfo getEmitter(String emitterId) {
        if (emitterId != null) {
            for (EmitterInfo emitterInfo : this.emitterExtensions) {
                if (!emitterId.equals(emitterInfo.getID())) continue;
                return emitterInfo;
            }
        }
        return null;
    }

    public DataExtractionFormatInfo[] getDataExtractionExtensionInfo() {
        int length = this.dataExtractionFormats.size();
        DataExtractionFormatInfo[] result = new DataExtractionFormatInfo[length];
        Iterator iterator = this.dataExtractionFormats.values().iterator();
        int i = 0;
        while (i < length) {
            result[i] = (DataExtractionFormatInfo)iterator.next();
            ++i;
        }
        return result;
    }

    public boolean isValidEmitterID(String id) {
        boolean isValidEmitterID = false;
        for (EmitterInfo emitterInfo : this.emitterExtensions) {
            if (id == null || !id.equalsIgnoreCase(emitterInfo.getID())) continue;
            isValidEmitterID = true;
        }
        return isValidEmitterID;
    }

    public boolean isSupportedFormat(String format) {
        boolean supported = false;
        Collection supportedFormats = this.getSupportedFormat();
        for (String supportedFormat : supportedFormats) {
            if (supportedFormat == null || !supportedFormat.equalsIgnoreCase(format)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    public String getSupportedFormat(String format) {
        Collection supportedFormats = this.getSupportedFormat();
        for (String supportedFormat : supportedFormats) {
            if (supportedFormat == null || !supportedFormat.equalsIgnoreCase(format)) continue;
            return supportedFormat;
        }
        return null;
    }

    public String getFormat(String emitterid) {
        String format = null;
        int i = 0;
        while (i < this.emitterExtensions.size()) {
            EmitterInfo emitterInfo = this.emitterExtensions.get(i);
            if (emitterid.equalsIgnoreCase(emitterInfo.getID())) {
                format = emitterInfo.getFormat();
            }
            ++i;
        }
        return format;
    }

    public String getEmitterID(String format) {
        String emitterid = null;
        int i = 0;
        while (i < this.emitterExtensions.size()) {
            EmitterInfo emitterInfo = this.emitterExtensions.get(i);
            if (format.equalsIgnoreCase(emitterInfo.getFormat())) {
                emitterid = emitterInfo.getID();
            }
            ++i;
        }
        return emitterid;
    }
}

