/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationProblem
implements Comparable<ValidationProblem> {
    public static final String DEFAULT_MARKER_ID = "org.eclipse.mylyn.wikitext.core.validation.problem";
    private String markerId = "org.eclipse.mylyn.wikitext.core.validation.problem";
    private Severity severity;
    private String message;
    private int offset;
    private int length;

    public ValidationProblem(Severity severity, String message, int offset, int length) {
        this.setSeverity(severity);
        this.setMessage(message);
        this.setOffset(offset);
        this.setLength(length);
    }

    public String getMarkerId() {
        return this.markerId;
    }

    public void setMarkerId(String markerId) {
        this.markerId = markerId;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException();
        }
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        if (message == null || message.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.message = message;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.length = length;
    }

    public String toString() {
        return (Object)((Object)this.severity) + "[" + this.offset + "," + this.length + "]: " + this.message;
    }

    @Override
    public int compareTo(ValidationProblem o2) {
        int length2;
        int offset2;
        if (this == o2) {
            return 0;
        }
        int offset1 = this.getOffset();
        if (offset1 < (offset2 = o2.getOffset())) {
            return -1;
        }
        if (offset2 < offset1) {
            return 1;
        }
        int length1 = this.getLength();
        if (length1 > (length2 = o2.getLength())) {
            return -1;
        }
        if (length2 > length1) {
            return 1;
        }
        int i = this.getMessage().compareTo(o2.getMessage());
        if (i == 0) {
            i = this.getMarkerId().compareTo(o2.getMarkerId());
        }
        return i;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        WARNING,
        ERROR;

    }
}

