/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.log.impl;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.ToolEnvironment;
import org.eclipse.wst.wsi.internal.core.ToolInfo;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.LogReader;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.log.MessageEntryHandler;
import org.eclipse.wst.wsi.internal.core.log.MimePart;
import org.eclipse.wst.wsi.internal.core.log.MimeParts;
import org.eclipse.wst.wsi.internal.core.log.impl.MessageEntryImpl;
import org.eclipse.wst.wsi.internal.core.log.impl.MimePartImpl;
import org.eclipse.wst.wsi.internal.core.log.impl.MimePartsImpl;
import org.eclipse.wst.wsi.internal.core.monitor.config.impl.CommentImpl;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.report.ArtifactReference;
import org.eclipse.wst.wsi.internal.core.report.impl.ArtifactReferenceImpl;
import org.eclipse.wst.wsi.internal.core.report.impl.EntryImpl;
import org.eclipse.wst.wsi.internal.core.util.EntryType;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.eclipse.wst.wsi.internal.core.xml.dom.ElementLocation;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LogReaderImpl
implements LogReader {
    private String documentURI;
    private int firstLogElement = 0;
    private int elementCount = 0;
    private boolean bMonitorFirst = false;
    private WSIException wsiException = null;

    public void readLog(String logURI, MessageEntryHandler logReaderCallback) throws WSIException {
        this.readLog(new InputSource(logURI), logReaderCallback);
    }

    public void readLog(Reader reader, MessageEntryHandler logReaderCallback) throws WSIException {
        this.readLog(new InputSource(reader), logReaderCallback);
    }

    protected void readLog(InputSource inputSource, MessageEntryHandler messageEntryHandler) throws WSIException {
        try {
            XMLReader xmlReader = XMLUtils.getXMLReader();
            xmlReader.setContentHandler(new LogFileHandler(messageEntryHandler));
            xmlReader.parse(inputSource);
            if (!this.bMonitorFirst) {
                throw new WSIException("The Element \"monitor\" is not the first child of the Element \"log\"");
            }
        }
        catch (Exception e) {
            throw new WSIException("An error occurred while processing the message log file.", e);
        }
    }

    public String getLocation() {
        return this.documentURI;
    }

    public void setLocation(String documentURI) {
        this.documentURI = documentURI;
    }

    private boolean omitRequest(MessageEntry messageEntryRequest) {
        boolean omit = false;
        if (messageEntryRequest == null) {
            omit = true;
        } else {
            String requestHeaders = messageEntryRequest.getHTTPHeaders();
            if (requestHeaders != null && (requestHeaders.startsWith("CONNECT") || requestHeaders.startsWith("TRACE") || requestHeaders.startsWith("DELETE") || requestHeaders.startsWith("OPTIONS") || requestHeaders.startsWith("HEAD") || requestHeaders.startsWith("GET") && !this.isMessageWithBrackets(messageEntryRequest.getMessage()))) {
                omit = true;
            }
        }
        return omit;
    }

    public boolean isMessageWithBrackets(String message) {
        return message != null && message.indexOf("<") != -1 && message.indexOf(">") != -1;
    }

    private boolean isMessageEncrypted(String message) {
        return message != null && message.indexOf("<EncryptedKey ") != -1;
    }

    private class LogFileHandler
    extends DefaultHandler {
        private String id;
        private String conversationID;
        private String type;
        private String timestamp;
        private StringBuffer senderHostAndPort = null;
        private StringBuffer receiverHostAndPort = null;
        private StringBuffer messageContent = null;
        private StringBuffer httpHeaders = null;
        private StringBuffer boundary = null;
        private StringBuffer mimeHeaders = null;
        private StringBuffer mimeContent = null;
        private MimeParts mimeParts = null;
        private List boundaries = null;
        private int bom = 0;
        private String logTimestamp = null;
        private StringBuffer monitorComment;
        private boolean ignoreComment = false;
        private String currentElement;
        private ElementLocation entryElementLocation = null;
        private ToolInfo toolInfo = null;
        private Vector messageEntryList = new Vector();
        private MessageEntryHandler logEntryHandler = null;
        private Locator locator = null;

        public LogFileHandler(MessageEntryHandler logEntryHandler) {
            this.logEntryHandler = logEntryHandler;
            this.toolInfo = new ToolInfo();
            this.toolInfo.setToolEnvironment(new ToolEnvironment());
        }

        public void startDocument() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            if (LogReaderImpl.this.elementCount == 2 && LogReaderImpl.this.firstLogElement == 1) {
                LogReaderImpl.this.bMonitorFirst = true;
            }
            LogReaderImpl logReaderImpl = LogReaderImpl.this;
            logReaderImpl.elementCount = logReaderImpl.elementCount + 1;
            if (localName == "log") {
                this.logTimestamp = attributes.getValue("timestamp");
            } else if (localName == "configuration" && namespaceURI == "http://www.ws-i.org/testing/2004/07/monitorConfig/") {
                this.ignoreComment = false;
            } else if (localName == "comment" && namespaceURI == "http://www.ws-i.org/testing/2004/07/monitorConfig/") {
                if (!this.ignoreComment) {
                    this.currentElement = "comment";
                    this.monitorComment = new StringBuffer();
                }
            } else if (localName == "redirect" && namespaceURI == "http://www.ws-i.org/testing/2004/07/monitorConfig/") {
                this.ignoreComment = true;
                this.monitorComment = null;
            } else if (localName == "monitor") {
                LogReaderImpl logReaderImpl2 = LogReaderImpl.this;
                logReaderImpl2.firstLogElement = logReaderImpl2.firstLogElement + 1;
                this.toolInfo.setName("monitor");
                this.toolInfo.setVersion(attributes.getValue("version"));
                this.toolInfo.setReleaseDate(attributes.getValue("releaseDate"));
            } else if (localName == "implementer") {
                this.currentElement = "implementer";
                this.toolInfo.setImplementer(attributes.getValue("name"));
                this.toolInfo.setLocation(attributes.getValue("location"));
            } else if (localName == "runtime") {
                this.currentElement = "runtime";
                this.toolInfo.getToolEnvironment().setRuntimeName(attributes.getValue("name"));
                this.toolInfo.getToolEnvironment().setRuntimeVersion(attributes.getValue("version"));
            } else if (localName == "operatingSystem") {
                this.currentElement = "operatingSystem";
                this.toolInfo.getToolEnvironment().setOSName(attributes.getValue("name"));
                this.toolInfo.getToolEnvironment().setOSVersion(attributes.getValue("version"));
            } else if (localName == "xmlParser") {
                this.currentElement = "xmlParser";
                this.toolInfo.getToolEnvironment().setXMLParserName(attributes.getValue("name"));
                this.toolInfo.getToolEnvironment().setXMLParserVersion(attributes.getValue("version"));
            } else if (localName == "messageEntry") {
                this.currentElement = "messageEntry";
                this.entryElementLocation = new ElementLocation(this.locator);
                this.timestamp = attributes.getValue("timestamp");
                this.conversationID = attributes.getValue("conversationID");
                this.id = attributes.getValue("ID");
                this.type = attributes.getValue("type");
            } else if (localName == "httpHeaders") {
                this.httpHeaders = new StringBuffer();
                this.currentElement = "httpHeaders";
            } else if (localName == "messageContent") {
                this.messageContent = new StringBuffer();
                this.mimeParts = null;
                this.currentElement = "messageContent";
                String bomString = attributes.getValue("BOM");
                this.bom = bomString != null ? Integer.valueOf(bomString) : 0;
            } else if (localName == "messageContentWithAttachments") {
                this.messageContent = null;
                this.mimeParts = new MimePartsImpl();
                String bomString = attributes.getValue("BOM");
                this.bom = bomString != null ? Integer.valueOf(bomString) : 0;
            } else if (localName == "mimePart") {
                if (this.boundaries == null) {
                    this.boundaries = new ArrayList(2);
                } else {
                    this.boundaries.clear();
                }
            } else if (localName == "boundaryString") {
                this.boundary = new StringBuffer();
                this.currentElement = "boundaryString";
            } else if (localName == "mimeHeaders") {
                this.mimeHeaders = new StringBuffer();
                this.currentElement = "mimeHeaders";
            } else if (localName == "mimeContent") {
                this.mimeContent = new StringBuffer();
                this.currentElement = "mimeContent";
            } else if (localName == "senderHostAndPort") {
                this.senderHostAndPort = new StringBuffer();
                this.currentElement = "senderHostAndPort";
            } else if (localName == "receiverHostAndPort") {
                this.receiverHostAndPort = new StringBuffer();
                this.currentElement = "receiverHostAndPort";
            }
        }

        public void characters(char[] ch, int start, int length) {
            int altStart = start;
            int altLength = length;
            if (start > 0 && ch[start - 1] == '\r' && ch[start] == '\n') {
                ++altStart;
                --altLength;
            }
            if (this.monitorComment != null && this.currentElement == "comment") {
                this.monitorComment.append(ch, start, length);
            } else if (this.messageContent != null && this.currentElement == "messageContent") {
                this.messageContent.append(ch, start, length);
            } else if (this.httpHeaders != null && this.currentElement == "httpHeaders") {
                this.httpHeaders.append(ch, start, length);
            } else if (this.boundary != null && this.currentElement == "boundaryString") {
                this.boundary.append(ch, altStart, altLength);
            } else if (this.mimeHeaders != null && this.currentElement == "mimeHeaders") {
                this.mimeHeaders.append(ch, altStart, altLength);
            } else if (this.mimeContent != null && this.currentElement == "mimeContent") {
                this.mimeContent.append(ch, altStart, altLength);
            } else if (this.senderHostAndPort != null && this.currentElement == "senderHostAndPort") {
                this.senderHostAndPort.append(ch, start, length);
            } else if (this.receiverHostAndPort != null && this.currentElement == "receiverHostAndPort") {
                this.receiverHostAndPort.append(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (localName == "comment" && namespaceURI == "http://www.ws-i.org/testing/2004/07/monitorConfig/") {
                if (this.monitorComment != null) {
                    ArtifactReferenceImpl artifactReference = new ArtifactReferenceImpl();
                    artifactReference.setTimestamp(this.logTimestamp);
                    CommentImpl comment = new CommentImpl();
                    comment.setText(this.monitorComment.toString());
                    artifactReference.setDocumentElement(comment, "wsi-monConfig");
                    this.processArtifactReference(artifactReference);
                }
            } else if (localName == "boundaryString") {
                this.boundaries.add(this.boundary.toString());
            } else if (localName == "mimePart") {
                MimePartImpl part = new MimePartImpl();
                part.setHeaders(this.mimeHeaders.toString());
                part.setContent(this.mimeContent.toString());
                part.setBoundaryStrings(this.boundaries.toArray(new String[0]));
                this.mimeParts.addPart(part);
            } else if (localName == "messageEntry") {
                if ("request".equalsIgnoreCase(this.type)) {
                    MessageEntry messageEntryRequest = this.createMessageEntry(this.id, this.conversationID, this.type, this.timestamp, this.senderHostAndPort.toString(), this.receiverHostAndPort.toString(), this.messageContent == null ? "" : this.messageContent.toString(), this.httpHeaders.toString(), this.mimeParts, this.entryElementLocation);
                    this.messageEntryList.add(messageEntryRequest);
                } else if ("response".equalsIgnoreCase(this.type)) {
                    MessageEntry messageEntryRequest;
                    MessageEntry messageEntryResponse = this.createMessageEntry(this.id, this.conversationID, this.type, this.timestamp, this.senderHostAndPort.toString(), this.receiverHostAndPort.toString(), this.messageContent == null ? "" : this.messageContent.toString(), this.httpHeaders.toString(), this.mimeParts, this.entryElementLocation);
                    if (!(this.logEntryHandler == null || (messageEntryRequest = this.findRelatedRequest(messageEntryResponse)) == null || LogReaderImpl.this.isMessageEncrypted(messageEntryRequest.getMessage()) || LogReaderImpl.this.isMessageEncrypted(messageEntryResponse.getMessage()) || LogReaderImpl.this.omitRequest(messageEntryRequest))) {
                        EntryImpl entry = new EntryImpl();
                        entry.setEntryType(EntryType.getEntryType("requestMessage"));
                        entry.setReferenceID(messageEntryRequest.getId());
                        entry.setEntryDetail(messageEntryRequest);
                        EntryContext requestTargetContext = new EntryContext(entry, messageEntryRequest, messageEntryResponse);
                        this.processLogEntry(requestTargetContext);
                        entry = new EntryImpl();
                        entry.setEntryType(EntryType.getEntryType("responseMessage"));
                        entry.setReferenceID(messageEntryResponse.getId());
                        entry.setEntryDetail(messageEntryResponse);
                        EntryContext responseTargetContext = new EntryContext(entry, messageEntryRequest, messageEntryResponse);
                        this.processLogEntry(responseTargetContext);
                    }
                }
            }
            this.currentElement = null;
        }

        public void endDocument() {
            int i = 0;
            while (i < this.messageEntryList.size()) {
                MessageEntry logEntry = (MessageEntry)this.messageEntryList.get(i);
                if (!LogReaderImpl.this.omitRequest(logEntry)) {
                    EntryImpl entry = new EntryImpl();
                    entry.setEntryType(EntryType.getEntryType("requestMessage"));
                    entry.setReferenceID(logEntry.getId());
                    entry.setEntryDetail(logEntry);
                    EntryContext requestTargetContext = new EntryContext(entry, logEntry, null);
                    this.processLogEntry(requestTargetContext);
                }
                ++i;
            }
        }

        public void processLogEntry(EntryContext entryContext) {
            try {
                this.logEntryHandler.processLogEntry(entryContext);
            }
            catch (Exception e) {
                LogReaderImpl.this.wsiException = new WSIException("An error occurred while validating the message logEntry: " + entryContext.getMessageEntry().getId(), e);
            }
        }

        private void processArtifactReference(ArtifactReference artifactReference) {
            try {
                this.logEntryHandler.processArtifactReference(artifactReference);
            }
            catch (Exception e) {
                LogReaderImpl.this.wsiException = new WSIException("An error occurred while processing the artifact reference: " + artifactReference.toString(), e);
            }
        }

        public MessageEntry findRelatedRequest(MessageEntry logEntryResponse) {
            if (logEntryResponse != null) {
                int entry = this.messageEntryList.size() - 1;
                while (entry >= 0) {
                    MessageEntry logEntry = (MessageEntry)this.messageEntryList.get(entry);
                    if (!logEntryResponse.equals(logEntry) && logEntryResponse.getConversationId().equals(logEntry.getConversationId())) {
                        if (logEntry.getType().equals("request")) {
                            this.messageEntryList.remove(entry);
                            return logEntry;
                        }
                        return null;
                    }
                    --entry;
                }
            }
            return null;
        }

        private MessageEntry createMessageEntry(String id, String conversationId, String type, String timestamp, String senderIPPort, String receiverIPPort, String messageContent, String httpHeaders, MimeParts mimeParts, ElementLocation elementLocation) {
            MessageEntryImpl messageEntry = new MessageEntryImpl();
            messageEntry.setId(id);
            messageEntry.setConversationId(this.conversationID);
            messageEntry.setType(type);
            messageEntry.setTimestamp(timestamp);
            messageEntry.setSenderHostAndPort(senderIPPort);
            messageEntry.setReceiverHostAndPort(receiverIPPort);
            messageEntry.setHTTPHeaders(httpHeaders);
            messageEntry.setBOM(this.bom);
            messageEntry.setElementLocation(elementLocation);
            String encoding = null;
            if (mimeParts == null) {
                encoding = Utils.getXMLEncoding(messageContent);
                messageEntry.setMessage(messageContent);
                messageEntry.setMimeContent(false);
            } else {
                messageEntry.setMimeParts(mimeParts);
                MimePart root = Utils.findRootPart(httpHeaders, mimeParts.getParts());
                if (root != null) {
                    encoding = Utils.getXMLEncoding(root.getContent());
                    mimeParts.setRootPart(root);
                }
                messageEntry.setMimeContent(true);
            }
            if (encoding == null || encoding.equals("")) {
                encoding = "UTF-8";
            }
            messageEntry.setEncoding(encoding);
            return messageEntry;
        }
    }
}

