/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs;

import java.util.List;
import org.eclipse.ebam.designers.exception.DatabaseConnectionException;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdsDetailComposite;
import org.eclipse.ebam.emf.SbiDomainTransactions;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.ebam.model.entities.SbiThreshold;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdDetailTabItem
extends CTabItem {
    private ThresholdsDetailComposite thresholdsDetailComposite;
    private Text nameText;
    private Text codeText;
    private Text descrText;
    private Combo typeCombo;
    public static final int tabIndex = 0;
    Button buttonSave = null;
    private static Logger logger = LoggerFactory.getLogger(ThresholdDetailTabItem.class);

    public ThresholdDetailTabItem(CTabFolder parent, int style, ThresholdsDetailComposite alComposite) {
        super(parent, style);
        this.thresholdsDetailComposite = alComposite;
    }

    public void drawComp(CTabFolder folder) throws DatabaseConnectionException {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        detailComposite.setLayout((Layout)gridLayout);
        this.buttonSave = new Button(detailComposite, 8);
        this.buttonSave.setToolTipText("Save threshold details");
        GridData grid = new GridData(128);
        grid.horizontalSpan = 3;
        this.buttonSave.setLayoutData((Object)grid);
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSave.setImage(saveImage);
        this.buttonSave.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ThresholdDetailTabItem.this.thresholdsDetailComposite.saveButtonPush();
                    ThresholdDetailTabItem.this.thresholdsDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.EMPTY);
                    ThresholdDetailTabItem.this.thresholdsDetailComposite.getStatusLabel().redraw();
                    ThresholdDetailTabItem.this.buttonSave.setEnabled(false);
                }
                catch (DatabaseConnectionException databaseConnectionException) {
                    logger.error("database connection exception");
                    MessageDialog.openError((Shell)ThresholdDetailTabItem.this.buttonSave.getShell(), (String)"Error", (String)"Error in removing threshold");
                }
            }
        });
        this.buttonSave.setEnabled(false);
        Label codeLabel = new Label(detailComposite, 0);
        codeLabel.setText("Code: ");
        GridData gCode = new GridData(32);
        codeLabel.setLayoutData((Object)gCode);
        this.codeText = new Text(detailComposite, 2048);
        GridData gCodeText = new GridData(768);
        gCodeText.horizontalSpan = 2;
        this.codeText.setLayoutData((Object)gCodeText);
        Label nameLabel = new Label(detailComposite, 0);
        nameLabel.setText("Name ");
        GridData gName = new GridData(32);
        nameLabel.setLayoutData((Object)gName);
        this.nameText = new Text(detailComposite, 2048);
        GridData gNameText = new GridData(768);
        gNameText.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gNameText);
        Label descrLabel = new Label(detailComposite, 0);
        descrLabel.setText("Description ");
        GridData gDescr = new GridData(32);
        descrLabel.setLayoutData((Object)gDescr);
        this.descrText = new Text(detailComposite, 2048);
        GridData gDescrText = new GridData(768);
        gDescrText.horizontalSpan = 2;
        this.descrText.setLayoutData((Object)gDescrText);
        Label typeLabel = new Label(detailComposite, 0);
        typeLabel.setText("Threshold Type: ");
        GridData gType = new GridData(32);
        typeLabel.setLayoutData((Object)gType);
        this.typeCombo = new Combo(detailComposite, 0);
        try {
            List domains = new SbiDomainTransactions().getDomainByDomainCd("THRESHOLD_TYPE");
            int i = 0;
            while (i < domains.size()) {
                SbiDomain domain = (SbiDomain)domains.get(i);
                this.typeCombo.add(domain.getValueCd());
                ++i;
            }
            if (this.typeCombo.getItems().length > 0) {
                this.typeCombo.select(0);
            }
            this.typeCombo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    String type = ThresholdDetailTabItem.this.typeCombo.getText();
                    ThresholdDetailTabItem.this.thresholdsDetailComposite.getThresholdValueTabItem().getFunctions().fillValueDetailForType(type);
                }
            });
        }
        catch (Exception e) {
            logger.error("error in retrieving domain", (Throwable)e);
            throw new DatabaseConnectionException(e, "error in retrieving domain");
        }
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues() {
        this.nameText.setText("");
        this.codeText.setText("");
        this.descrText.setText("");
        this.typeCombo.setEnabled(true);
        if (this.typeCombo.getItemCount() > 0) {
            this.typeCombo.select(0);
        }
    }

    public void fillThresholdValues(SbiThreshold sbiThreshold) throws DatabaseConnectionException {
        logger.debug("IN");
        String name = sbiThreshold.getName() != null ? sbiThreshold.getName() : "";
        this.nameText.setText(name);
        String descr = sbiThreshold.getDescription() != null ? sbiThreshold.getDescription() : "";
        this.descrText.setText(descr);
        String code = sbiThreshold.getCode() != null ? sbiThreshold.getCode() : "";
        this.codeText.setText(code);
        this.typeCombo.setEnabled(false);
        try {
            SbiDomain domain = sbiThreshold.getSbiDomain();
            String[] domains = this.typeCombo.getItems();
            int i = 0;
            while (i < domains.length) {
                String lab = domains[i];
                if (lab.equalsIgnoreCase(domain.getValueCd())) {
                    this.typeCombo.select(i);
                    this.thresholdsDetailComposite.getThresholdValueTabItem().getFunctions().fillValueDetailForType(lab);
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("Error in filling with details of  selected threshold the detail tab ", (Throwable)e);
            throw new DatabaseConnectionException(e, "Error in filling with details of selected threshold the detail tab");
        }
        logger.debug("OUT");
    }

    public void recoverSavingInformations(SbiThreshold sbiThreshold) throws DatabaseConnectionException {
        logger.debug("IN");
        String name = this.nameText.getText();
        String descr = this.descrText.getText();
        String code = this.codeText.getText();
        int indexSel = this.typeCombo.getSelectionIndex();
        String valueCdDomain = this.typeCombo.getItem(indexSel);
        SbiDomain sbiDomain = null;
        try {
            sbiDomain = new SbiDomainTransactions().getSbiDomainByCodeAndDomainCd(valueCdDomain, "THRESHOLD_TYPE");
        }
        catch (Exception e) {
            logger.error("Error in recovering domain informations", (Throwable)e);
            throw new DatabaseConnectionException(e, "Error in recovering domain informations");
        }
        sbiThreshold.setName(name);
        sbiThreshold.setDescription(descr);
        sbiThreshold.setCode(code);
        sbiThreshold.setSbiDomain(sbiDomain);
    }

    public ThresholdsDetailComposite getThresholdsDetailComposite() {
        return this.thresholdsDetailComposite;
    }

    public void setThresholdsDetailComposite(ThresholdsDetailComposite thresholdsDetailComposite) {
        this.thresholdsDetailComposite = thresholdsDetailComposite;
    }

    public Text getNameText() {
        return this.nameText;
    }

    public void setNameText(Text nameText) {
        this.nameText = nameText;
    }

    public Text getDescrText() {
        return this.descrText;
    }

    public void setDescrText(Text descrText) {
        this.descrText = descrText;
    }

    public Text getCodeText() {
        return this.codeText;
    }

    public void setCodeText(Text codeText) {
        this.codeText = codeText;
    }

    public Combo getTypeCombo() {
        return this.typeCombo;
    }

    public void setTypeCombo(Combo typeCombo) {
        this.typeCombo = typeCombo;
    }

    public Button getButtonSave() {
        return this.buttonSave;
    }

    public void setButtonSave(Button buttonSave) {
        this.buttonSave = buttonSave;
    }
}

