/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.thresholdwidgets;

import java.util.List;
import java.util.Set;
import org.eclipse.ebam.designers.exception.DatabaseConnectionException;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmsDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdWizardPage;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdsDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs.ThresholdDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs.ThresholdValueTabItem;
import org.eclipse.ebam.emf.SbiThresholdTransactions;
import org.eclipse.ebam.emf.SbiThresholdValueTransactions;
import org.eclipse.ebam.model.entities.SbiThreshold;
import org.eclipse.ebam.model.entities.SbiThresholdValue;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdsListComposite
extends Composite {
    private ThresholdWizardPage thresholdWizardPage = null;
    private Table thresholdsTable = null;
    public static final int CODE = 0;
    public static final int NAME = 1;
    public static final int TYPE = 2;
    Button buttonAdd = null;
    Button buttonErase = null;
    private static Logger logger = LoggerFactory.getLogger(ThresholdsListComposite.class);

    public ThresholdsListComposite(Composite parent, int style, ThresholdWizardPage page) {
        super(parent, style);
        this.thresholdWizardPage = page;
    }

    public void drawComp() {
        logger.debug("in");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        try {
            this.setLayout((Layout)gridLayout);
            Label label = new Label((Composite)this, 0);
            label.setText("Thresholds List: ");
            label.setForeground(new Color((Device)this.getDisplay(), new RGB(0, 0, 255)));
            label.setLayoutData((Object)new GridData(32));
            Label empty = new Label((Composite)this, 0);
            empty.setText("");
            empty.setLayoutData((Object)new GridData(128));
            this.buttonAdd = new Button((Composite)this, 8);
            this.buttonAdd.setToolTipText("Add a threshold");
            this.buttonAdd.setLayoutData((Object)new GridData(32));
            Image addImage = ImageDescriptors.getAddIcon().createImage();
            this.buttonAdd.setImage(addImage);
            this.buttonAdd.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ThresholdsListComposite.this.getThresholdWizardPage().getDetailComposite().getStatusLabel().setText(ThresholdsDetailComposite.INSERTING);
                    ThresholdsListComposite.this.buttonAddSelection();
                }
            });
            this.buttonErase = new Button((Composite)this, 8);
            this.buttonErase.setToolTipText("Erase selected threshold");
            this.buttonErase.setLayoutData((Object)new GridData(128));
            Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
            this.buttonErase.setImage(eraseImage);
            this.buttonErase.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        ThresholdsListComposite.this.eraseButtonPush();
                        ThresholdsListComposite.this.getThresholdWizardPage().getDetailComposite().getStatusLabel().setText(AlarmsDetailComposite.EMPTY);
                    }
                    catch (DatabaseConnectionException databaseConnectionException) {
                        logger.error("Error in removing threshold, probably associated to an alarm");
                        MessageDialog.openError((Shell)ThresholdsListComposite.this.thresholdsTable.getShell(), (String)"Error", (String)"Cannot remove threshold, probably associated to an existing alarm");
                    }
                }
            });
            this.buttonErase.setEnabled(false);
            List<SbiThreshold> thresholdsList = this.retrieveThresholds();
            this.thresholdsTable = new Table((Composite)this, 68100);
            this.thresholdsTable.setLinesVisible(true);
            this.thresholdsTable.setHeaderVisible(true);
            GridData g = new GridData(1808);
            g.horizontalSpan = 2;
            this.thresholdsTable.setLayoutData((Object)g);
            String[] titles = new String[]{"           Code           ", "                 Name                   ", "     Type       "};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.thresholdsTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            i = 0;
            while (i < thresholdsList.size()) {
                SbiThreshold sbiThreshold = thresholdsList.get(i);
                TableItem item = new TableItem(this.thresholdsTable, 0);
                String codeVal = "";
                if (sbiThreshold.getCode() != null) {
                    codeVal = sbiThreshold.getCode();
                }
                item.setText(0, codeVal);
                String nameVal = "";
                if (sbiThreshold.getName() != null) {
                    nameVal = sbiThreshold.getName();
                }
                item.setText(1, nameVal);
                item.setText(2, sbiThreshold.getSbiDomain().getValueNm());
                item.setData((Object)sbiThreshold.getThresholdId());
                ++i;
            }
            i = 0;
            while (i < titles.length) {
                this.thresholdsTable.getColumn(i).pack();
                ++i;
            }
            this.thresholdsTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        ThresholdsListComposite.this.thresholdSelection();
                        ThresholdsListComposite.this.getThresholdWizardPage().getDetailComposite().getStatusLabel().setText(ThresholdsDetailComposite.MODIFYING);
                    }
                    catch (Exception exception) {
                        logger.error("database connection exception");
                        MessageDialog.openError((Shell)ThresholdsListComposite.this.thresholdsTable.getShell(), (String)"Error", (String)"Error in preparing page for selected Threshold");
                    }
                }
            });
        }
        catch (DatabaseConnectionException databaseConnectionException) {}
        this.thresholdsTable.redraw();
        logger.debug("OUT");
    }

    private void thresholdSelection() throws Exception {
        logger.debug("IN");
        int indexSelected = this.thresholdsTable.getSelectionIndex();
        TableItem tableItem = this.thresholdsTable.getItem(indexSelected);
        Integer id = (Integer)tableItem.getData();
        SbiThreshold sbiThreshold = new SbiThresholdTransactions().getSbiThresholdById(id);
        if (sbiThreshold == null) {
            logger.error("could not find threshold with id " + id);
            MessageDialog.openError((Shell)this.thresholdsTable.getShell(), (String)"Error", (String)("Could not find threshold with id " + id));
        }
        logger.debug("fill detail page with selected threshold id " + id);
        CTabFolder tabFolder = this.getThresholdWizardPage().getDetailComposite().getTabFolder();
        ThresholdDetailTabItem thresholdDetailTabItem = (ThresholdDetailTabItem)tabFolder.getItem(0);
        thresholdDetailTabItem.fillThresholdValues(sbiThreshold);
        ThresholdValueTabItem thresholdValueTabItem = (ThresholdValueTabItem)tabFolder.getItem(1);
        thresholdValueTabItem.fillThresholdValues(sbiThreshold);
        this.setPageForThresSelection(tabFolder);
        logger.debug("OUT");
    }

    public void setPageForThresSelection(CTabFolder folder) {
        logger.debug("IN");
        folder.setEnabled(true);
        this.buttonErase.setEnabled(true);
        folder.setSelection(0);
        this.getThresholdWizardPage().getDetailComposite().enableSaveButton(true);
        ThresholdValueTabItem thresholdValueTabItem = (ThresholdValueTabItem)folder.getItem(1);
        thresholdValueTabItem.enableItems();
        logger.debug("OUT");
    }

    private void buttonAddSelection() {
        logger.debug("IN");
        CTabFolder tabFolder = this.getThresholdWizardPage().getDetailComposite().getTabFolder();
        ThresholdDetailTabItem thresholdDetailTabItem = (ThresholdDetailTabItem)tabFolder.getItem(0);
        thresholdDetailTabItem.fillEmptyValues();
        ThresholdValueTabItem thresholdValueTabItem = (ThresholdValueTabItem)tabFolder.getItem(1);
        thresholdValueTabItem.fillEmptyValues();
        this.setPageForAddButton(tabFolder);
    }

    public void setPageForAddButton(CTabFolder folder) {
        logger.debug("IN");
        this.thresholdsTable.setSelection(-1);
        this.buttonErase.setEnabled(false);
        folder.setEnabled(true);
        folder.setSelection(0);
        ThresholdValueTabItem thresholdValueTabItem = (ThresholdValueTabItem)folder.getItem(1);
        thresholdValueTabItem.disableItems();
        this.getThresholdWizardPage().getDetailComposite().enableSaveButton(true);
        this.getThresholdWizardPage().getDetailComposite().getStatusLabel().setText(ThresholdsDetailComposite.INSERTING);
        logger.debug("OUT");
    }

    private List<SbiThreshold> retrieveThresholds() throws DatabaseConnectionException {
        List thresholds = null;
        try {
            thresholds = new SbiThresholdTransactions().getSbiThresholdList();
        }
        catch (Exception e) {
            logger.error("error in retrieving thresholds list", (Throwable)e);
            throw new DatabaseConnectionException(e, "error in retrieving thresholds list");
        }
        return thresholds;
    }

    private void eraseButtonPush() throws DatabaseConnectionException {
        logger.debug("IN");
        int indexSelected = this.thresholdsTable.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = this.thresholdsTable.getItem(indexSelected);
            Integer id = (Integer)tableItem.getData();
            SbiThreshold sbiThreshold = null;
            try {
                sbiThreshold = new SbiThresholdTransactions().getSbiThresholdById(id);
                Set values = sbiThreshold.getSbiThresholdValues();
                for (SbiThresholdValue sbiThresholdValue : values) {
                    new SbiThresholdValueTransactions().deleteSbiThresholdValue(sbiThresholdValue);
                }
                sbiThreshold.setSbiThresholdValues(null);
                new SbiThresholdTransactions().deleteSbiThreshold(sbiThreshold);
            }
            catch (Exception e) {
                logger.error("Cannot erase threshold; check it is not associated to an alarm", (Throwable)e);
                throw new DatabaseConnectionException(e, "Cannot erase threshold; check it is not associated to an alarm");
            }
            this.thresholdsTable.remove(indexSelected);
            this.thresholdsTable.setSelection(-1);
            ThresholdsDetailComposite alDetailComposite = this.getThresholdWizardPage().getDetailComposite();
            CTabFolder tabFolder = alDetailComposite.getTabFolder();
            ThresholdDetailTabItem thresholdDetailTabItem = (ThresholdDetailTabItem)tabFolder.getItem(0);
            thresholdDetailTabItem.fillEmptyValues();
            ThresholdValueTabItem thresholdValueTabItem = (ThresholdValueTabItem)tabFolder.getItem(1);
            thresholdValueTabItem.fillEmptyValues();
            this.getThresholdWizardPage().getDetailComposite().enableSaveButton(false);
            this.setPageForEraseButton(tabFolder);
        }
        logger.debug("OUT");
    }

    public void setPageForEraseButton(CTabFolder folder) {
        logger.debug("IN");
        this.thresholdsTable.setSelection(-1);
        this.buttonErase.setEnabled(false);
        this.thresholdsTable.redraw();
        folder.setEnabled(false);
        folder.setSelection(0);
        ThresholdValueTabItem thresholdValueTabItem = (ThresholdValueTabItem)folder.getItem(1);
        thresholdValueTabItem.disableItems();
        this.getThresholdWizardPage().getDetailComposite().enableSaveButton(false);
        logger.debug("OUT");
    }

    public ThresholdWizardPage getThresholdWizardPage() {
        return this.thresholdWizardPage;
    }

    public void setThresholdWizardPage(ThresholdWizardPage thresholdWizardPage) {
        this.thresholdWizardPage = thresholdWizardPage;
    }

    public Table getThresholdsTable() {
        return this.thresholdsTable;
    }

    public void setThresholdsTable(Table thresholdsTable) {
        this.thresholdsTable = thresholdsTable;
    }
}

