/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs;

import java.util.HashMap;
import java.util.List;
import org.eclipse.ebam.designers.exception.DatabaseConnectionException;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmsDetailComposite;
import org.eclipse.ebam.emf.SbiThresholdTransactions;
import org.eclipse.ebam.emf.SbiThresholdValueTransactions;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiThreshold;
import org.eclipse.ebam.model.entities.SbiThresholdValue;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmThValueTabItem
extends CTabItem {
    AlarmsDetailComposite alarmsDetailComposite;
    public static final int tabIndex = 1;
    Label thresLabel = null;
    Combo thresCombo = null;
    Label thresValueLabel = null;
    Combo thresValueCombo = null;
    HashMap<String, SbiThreshold> thresholdsMap = new HashMap();
    HashMap<String, SbiThresholdValue> thresholdValuesMap = new HashMap();
    HashMap<String, Integer> thresholdsIndexMap = new HashMap();
    HashMap<String, Integer> thresholdValuesIndexMap = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(AlarmThValueTabItem.class);

    public AlarmThValueTabItem(CTabFolder parent, int style, AlarmsDetailComposite alarmsDetailComposite) {
        super(parent, style);
        this.alarmsDetailComposite = alarmsDetailComposite;
    }

    public void drawComp(CTabFolder folder) throws DatabaseConnectionException {
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        detailComposite.setLayout((Layout)gridLayout);
        this.thresLabel = new Label(detailComposite, 0);
        this.thresLabel.setText("Threshold: ");
        GridData gThresLabel = new GridData(32);
        this.thresLabel.setLayoutData((Object)gThresLabel);
        this.thresCombo = new Combo(detailComposite, 76);
        GridData gThres = new GridData(256);
        this.thresCombo.setLayoutData((Object)gThres);
        this.thresValueLabel = new Label(detailComposite, 0);
        this.thresValueLabel.setText("Threshold Value: ");
        GridData gThresValueLabel = new GridData(32);
        this.thresValueLabel.setLayoutData((Object)gThresValueLabel);
        this.thresValueCombo = new Combo(detailComposite, 76);
        GridData gThresValue = new GridData(256);
        this.thresValueCombo.setLayoutData((Object)gThresValue);
        List<SbiThreshold> thresholdsList = this.retrieveThresholds();
        int i = 0;
        this.thresCombo.add("", i);
        ++i;
        for (SbiThreshold sbiThreshold : thresholdsList) {
            this.thresCombo.add(sbiThreshold.getCode(), i);
            this.thresholdsMap.put(sbiThreshold.getCode(), sbiThreshold);
            this.thresholdsIndexMap.put(sbiThreshold.getCode(), i);
            ++i;
        }
        this.thresCombo.select(i);
        this.thresCombo.redraw();
        this.thresCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String code = AlarmThValueTabItem.this.thresCombo.getText();
                AlarmThValueTabItem.this.thresValueCombo.removeAll();
                SbiThreshold sbiThres = AlarmThValueTabItem.this.thresholdsMap.get(code);
                AlarmThValueTabItem.this.fillThresholdValuesCombo(sbiThres);
            }
        });
        this.setControl((Control)detailComposite);
        this.thresValueCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String code = AlarmThValueTabItem.this.thresValueCombo.getText();
                code.equalsIgnoreCase("");
            }
        });
    }

    void fillThresholdValuesCombo(SbiThreshold sbiThreshold) {
        this.thresholdValuesMap = new HashMap();
        this.thresholdValuesIndexMap = new HashMap();
        List<SbiThresholdValue> thValues = this.retrieveThresholdValues(sbiThreshold.getThresholdId());
        int i = 0;
        this.thresValueCombo.add("", i);
        ++i;
        for (SbiThresholdValue sbiThresholdValue : thValues) {
            this.thresValueCombo.add(sbiThresholdValue.getLabel(), i);
            this.thresholdValuesMap.put(sbiThresholdValue.getLabel(), sbiThresholdValue);
            this.thresholdValuesIndexMap.put(sbiThresholdValue.getLabel(), i);
            ++i;
        }
        this.thresValueCombo.setEnabled(true);
    }

    public void fillAlarmValues(SbiAlarm sbiAlarm) throws Exception {
        logger.debug("IN");
        SbiThresholdValue sbiThValue = sbiAlarm.getSbiThresholdValue();
        if (sbiThValue == null) {
            this.thresCombo.select(0);
            this.thresCombo.setEnabled(true);
            this.thresValueCombo.select(0);
            this.thresValueCombo.setEnabled(false);
            return;
        }
        SbiThresholdTransactions sbiThresholdTransactions = new SbiThresholdTransactions();
        try {
            SbiThreshold sbiThreshold = sbiThresholdTransactions.getSbiThresholdById(Integer.valueOf(sbiThValue.getSbiThreshold().getThresholdId()));
            int indexT = this.thresholdsIndexMap.get(sbiThreshold.getCode());
            this.thresCombo.select(indexT);
            this.fillThresholdValuesCombo(sbiThreshold);
            if (sbiThValue != null) {
                int indexV = this.thresholdValuesIndexMap.get(sbiThValue.getLabel());
                this.thresValueCombo.select(indexV);
                this.thresCombo.setEnabled(true);
                this.thresValueCombo.setEnabled(true);
            }
        }
        catch (Exception exception) {
            logger.error("Error in retrieving the threshold value for alarm " + sbiAlarm.getLabel());
            throw new Exception("error in filling alarms form");
        }
        logger.debug("OUT");
    }

    public void recoverSavingInformations(SbiAlarm sbiAlarm) {
        logger.debug("in");
        int index = this.thresValueCombo.getSelectionIndex();
        if (index == -1) {
            logger.debug("save alarm with no threshold value ");
            sbiAlarm.setSbiThresholdValue(null);
        } else {
            String code = this.thresValueCombo.getItem(index);
            if (code.equalsIgnoreCase("")) {
                logger.debug("save alarm with no threshold value ");
                sbiAlarm.setSbiThresholdValue(null);
            } else {
                SbiThresholdValue sbiThValue = this.thresholdValuesMap.get(code);
                if (sbiThValue != null) {
                    logger.debug("save alarm association with threshold value with label " + sbiThValue.getLabel());
                    sbiAlarm.setSbiThresholdValue(sbiThValue);
                }
            }
        }
        logger.debug("out");
    }

    private List<SbiThreshold> retrieveThresholds() throws DatabaseConnectionException {
        List thresholds = null;
        try {
            thresholds = new SbiThresholdTransactions().getSbiThresholdList();
        }
        catch (Exception e) {
            logger.error("error in retrieving thresholds list", (Throwable)e);
            throw new DatabaseConnectionException(e, "error in retrieving thresholds list");
        }
        return thresholds;
    }

    private List<SbiThresholdValue> retrieveThresholdValues(Integer thresholdId) {
        List thresholdValues = null;
        try {
            thresholdValues = new SbiThresholdValueTransactions().getSbiThresholdValueList(thresholdId);
        }
        catch (Exception e) {
            logger.error("error in retrieving threshold values list", (Throwable)e);
        }
        return thresholdValues;
    }

    public void disableFields() {
        this.thresCombo.setEnabled(false);
        this.thresValueCombo.setEnabled(false);
    }

    public void enableFields() {
        this.thresCombo.setEnabled(true);
        this.thresValueCombo.setEnabled(true);
    }

    public void fillEmptyValues() {
        this.thresCombo.select(0);
        this.thresValueCombo.select(0);
        this.thresValueCombo.removeAll();
        this.thresValueCombo.redraw();
    }
}

