/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.logging.Level;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.util.DocumentUtil;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.ebam.emf.utilities.ConnectionUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportView
extends ViewPart {
    public static final String ID = "org.eclipse.ebam.designers.views.ReportView";
    private static Logger logger = LoggerFactory.getLogger(ReportView.class);
    Browser browser = null;
    Composite parent = null;
    String tempReportPath = null;

    public void createPartControl(Composite _parent) {
        this.parent = _parent;
    }

    public void setFocus() {
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public void executeReportOnBrowser(String eclipsePath, String[] avalaibleReports, String tempPath) {
        logger.debug("IN");
        if (this.parent == null) {
            return;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.parent.getShell(), (ILabelProvider)new LabelProvider());
        dialog.setElements((Object[])avalaibleReports);
        dialog.setTitle("Which report to execute?");
        if (dialog.open() != 0) {
            logger.debug("User cancel execution request");
            return;
        }
        Object[] result = dialog.getResult();
        if (result.length == 0 || result.length > 1) {
            logger.debug("User did not choose a report cancel execution request");
            return;
        }
        String reportName = result[0].toString();
        logger.debug("User chose report " + reportName);
        eclipsePath = String.valueOf(eclipsePath) + reportName;
        logger.debug("Will be open report at path " + eclipsePath);
        try {
            this.browser = new Browser(this.parent, 0);
            IReportEngine engine = null;
            EngineConfig config = new EngineConfig();
            config.setLogConfig(null, Level.FINE);
            Platform.startup((PlatformConfig)config);
            IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            engine = factory.createReportEngine(config);
            engine.changeLogLevel(Level.WARNING);
            IReportRunnable design = null;
            design = engine.openReportDesign(eclipsePath);
            logger.debug("report opened");
            ReportDesignHandle designHandle = (ReportDesignHandle)design.getDesignHandle();
            designHandle.getElementFactory();
            SlotHandle slot = designHandle.getDataSources();
            if (slot.get(0) != null) {
                logger.debug("substituting the first data source");
                DesignElementHandle dse = slot.get(0);
                OdaDataSourceHandle dataSource = (OdaDataSourceHandle)dse;
                if (dataSource.getExtensionID().equals("org.eclipse.birt.report.data.oda.jdbc")) {
                    this.setConnectionHandle(dataSource);
                } else {
                    logger.error("Found not jdbc data source, cannot be substituted from xml");
                    MessageDialog.openWarning((Shell)this.parent.getShell(), (String)"Not a Jdbc DataSource", (String)"Not a jdbc data source inside the report, in the execution will be kept the original data source ");
                }
            }
            Random r = new Random();
            String token = Long.toString(Math.abs(r.nextLong()), 36);
            this.tempReportPath = String.valueOf(tempPath) + token + ".rptdesign";
            logger.debug("create temp file " + this.tempReportPath);
            FileOutputStream out = new FileOutputStream(this.tempReportPath);
            DocumentUtil.serialize((ReportDesignHandle)designHandle, (OutputStream)out);
            out.flush();
            ((OutputStream)out).close();
            logger.debug("open browser with report");
            WebViewer.display((String)this.tempReportPath, (String)"html", (Browser)this.browser, (String)"run");
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.parent.getShell(), (String)"Error", (String)"Generic error in executng the report");
        }
        this.parent.layout();
        this.parent.redraw();
    }

    public void dispose() {
        File tempFile = new File(this.tempReportPath);
        if (tempFile.exists()) {
            logger.debug("delete temp file " + this.tempReportPath);
            tempFile.delete();
        }
        if (this.browser != null) {
            WebViewer.cancel((Browser)this.browser);
            WebViewer.stopAll();
            this.browser = null;
        }
        super.dispose();
    }

    public void setConnectionHandle(OdaDataSourceHandle dataSource) {
        try {
            ConnectionUtilities utilities = new ConnectionUtilities();
            utilities.getConnectionData();
            logger.debug("Found connection  driver =" + utilities.getDriver() + " url =" + utilities.getUrl() + " user = " + utilities.getUser());
            if (utilities.getDriver() != null) {
                dataSource.setProperty("odaDriverClass", (Object)utilities.getDriver());
            }
            if (utilities.getUrl() != null) {
                dataSource.setProperty("odaURL", (Object)utilities.getUrl());
            }
            if (utilities.getUser() != null) {
                dataSource.setProperty("odaUser", (Object)utilities.getUser());
            }
            if (utilities.getPassword() != null) {
                dataSource.setProperty("odaPassword", (Object)utilities.getPassword());
            }
        }
        catch (Exception exception) {
            logger.error("some error occurred in recovering connection, only found data have been substituted");
        }
    }
}

