/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.preferences;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.equinox.internal.provisional.security.ui.X500PrincipalHelper;
import org.eclipse.equinox.internal.provisional.security.ui.X509CertificateViewDialog;
import org.eclipse.equinox.internal.security.ui.Activator;
import org.eclipse.equinox.internal.security.ui.ConfirmationDialog;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.equinox.internal.security.ui.wizard.CertificateImportWizard;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CertificatesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int VIEW_ISSUE_TO_COLUMN_INDEX = 0;
    private static final int VIEW_ISSUE_BY_COLUMN_INDEX = 1;
    private static final int VIEW_PROVIDER_COLUMN_INDEX = 2;
    TrustEngine[] activeTrustEngines;
    TableViewer tableViewer;
    Table tableCert;
    CertRowEntry currentSelection;
    Button removeBtn;
    Button viewButton;

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        this.initTrustEngines();
        Composite page = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        page.setLayout((Layout)layout);
        Label titleLabel = new Label(page, 0);
        titleLabel.setText(SecurityUIMsg.CERTPAGE_LABEL_TITLE);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        titleLabel.setLayoutData((Object)data);
        Link link = new Link(page, 0);
        link.setText(SecurityUIMsg.CERTPAGE_LABEL_LINK);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        link.setLayoutData((Object)data);
        Label tableLabel = new Label(page, 0);
        tableLabel.setText(SecurityUIMsg.CERTPAGE_TABLE_LABEL);
        data = new FormData();
        data.top = new FormAttachment((Control)titleLabel, 10);
        data.left = new FormAttachment(0, 0);
        tableLabel.setLayoutData((Object)data);
        Composite tableArea = new Composite(page, 0);
        FormLayout tableLayout = new FormLayout();
        tableArea.setLayout((Layout)tableLayout);
        Composite buttonArea = new Composite(page, 0);
        FormLayout buttonLayout = new FormLayout();
        buttonArea.setLayout((Layout)buttonLayout);
        data = new FormData();
        data.top = new FormAttachment((Control)tableLabel, 5);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        buttonArea.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)tableLabel, 5);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)buttonArea, 0);
        tableArea.setLayoutData((Object)data);
        this.tableViewer = new TableViewer(tableArea, 67588);
        this.tableCert = (Table)this.tableViewer.getControl();
        this.tableCert.setHeaderVisible(true);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.height = 10 * this.tableCert.getItemHeight();
        this.tableCert.setLayoutData((Object)data);
        TableColumn column1 = new TableColumn(this.tableCert, 0);
        column1.setText(SecurityUIMsg.CERTPAGE_TABLE_HEADER_ISSUEDTO);
        column1.setWidth(200);
        column1.addListener(13, (Listener)new CertTableSorter(0, this.getCertificates()));
        TableColumn column2 = new TableColumn(this.tableCert, 0);
        column2.setText(SecurityUIMsg.CERTPAGE_TABLE_HEADER_ISSUEDBY);
        column2.setWidth(200);
        column2.addListener(13, (Listener)new CertTableSorter(1, this.getCertificates()));
        TableColumn column3 = new TableColumn(this.tableCert, 0);
        column3.setText(SecurityUIMsg.CERTPAGE_TABLE_HEADER_PROVIDER);
        column3.setWidth(200);
        column3.addListener(13, (Listener)new CertTableSorter(2, this.getCertificates()));
        Button button1 = new Button(buttonArea, 8);
        button1.setText(SecurityUIMsg.CERTPAGE_BUTTON_IMPORT);
        button1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CertificatesPage.this.openImportWizard();
            }
        });
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, 0);
        data.width = 100;
        data.height = 25;
        button1.setLayoutData((Object)data);
        Button button2 = new Button(buttonArea, 8);
        button2.setText(SecurityUIMsg.CERTPAGE_BUTTON_EXPORT);
        data = new FormData();
        data.top = new FormAttachment((Control)button1, 5);
        data.left = new FormAttachment(0, 5);
        data.width = 100;
        data.height = 25;
        button2.setLayoutData((Object)data);
        this.viewButton = new Button(buttonArea, 8);
        this.viewButton.setText(SecurityUIMsg.CERTPAGE_BUTTON_VIEW);
        this.viewButton.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment((Control)button2, 5);
        data.left = new FormAttachment(0, 5);
        data.width = 100;
        data.height = 25;
        this.viewButton.setLayoutData((Object)data);
        this.viewButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                X509CertificateViewDialog certViewer = new X509CertificateViewDialog(CertificatesPage.this.tableViewer.getTable().getShell(), (X509Certificate)CertificatesPage.this.currentSelection.cert);
                certViewer.open();
            }
        });
        this.removeBtn = new Button(buttonArea, 8);
        this.removeBtn.setEnabled(false);
        this.removeBtn.setText(SecurityUIMsg.CERTPAGE_BUTTON_REMOVE);
        data = new FormData();
        data.top = new FormAttachment((Control)this.viewButton, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, 0);
        data.width = 100;
        data.height = 25;
        this.removeBtn.setLayoutData((Object)data);
        this.removeBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CertificatesPage.this.removeSelected();
            }
        });
        this.initTrustEngines();
        this.tableViewer.setContentProvider((IContentProvider)new SystemCertificatesContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SystemCertificatesLabelProvider(this.activeTrustEngines));
        this.tableViewer.setInput((Object)this.getCertificates());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    CertificatesPage.this.viewButton.setEnabled(true);
                    CertificatesPage.this.currentSelection = (CertRowEntry)((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (CertificatesPage.this.currentSelection != null && !CertificatesPage.this.activeTrustEngines[CertificatesPage.this.currentSelection.trustEngineIndex].isReadOnly()) {
                        CertificatesPage.this.removeBtn.setEnabled(true);
                    }
                }
            }
        });
        return page;
    }

    protected void openImportWizard() {
        CertificateImportWizard wizard = new CertificateImportWizard();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            this.tableViewer.setInput((Object)this.getCertificates());
        }
    }

    void removeSelected() {
        try {
            ConfirmationDialog confirmationDilaog = new ConfirmationDialog(this.tableViewer.getTable().getShell(), this.currentSelection.cert);
            if (confirmationDilaog.open() == 100) {
                this.activeTrustEngines[this.currentSelection.trustEngineIndex].removeTrustAnchor(this.currentSelection.cert);
                this.tableViewer.setInput((Object)this.getCertificates());
                this.removeBtn.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CertRowEntry[] getCertificates() {
        ArrayList<CertRowEntry> certs = new ArrayList<CertRowEntry>();
        try {
            int i = 0;
            while (i < this.activeTrustEngines.length) {
                String[] aliases = this.activeTrustEngines[i].getAliases();
                int j = 0;
                while (j < aliases.length) {
                    CertRowEntry certRowEntry = new CertRowEntry(this.activeTrustEngines[i].getTrustAnchor(aliases[j]), i);
                    certs.add(certRowEntry);
                    ++j;
                }
                ++i;
            }
            return certs.toArray(new CertRowEntry[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initTrustEngines() {
        if (this.activeTrustEngines == null) {
            this.activeTrustEngines = Activator.getTrustEngines();
        }
    }

    static String getSubjectCommonName(Certificate cert) {
        if (cert instanceof X509Certificate) {
            X500PrincipalHelper cnHelper = new X500PrincipalHelper(((X509Certificate)cert).getSubjectX500Principal());
            return cnHelper.getCN() != null ? cnHelper.getCN() : cnHelper.getOU();
        }
        return SecurityUIMsg.CERTPAGE_ERROR_UNKNOWN_FORMAT;
    }

    static String getIssuerOrg(Certificate cert) {
        if (cert instanceof X509Certificate) {
            X500PrincipalHelper cnHelper = new X500PrincipalHelper(((X509Certificate)cert).getIssuerX500Principal());
            String retOrg = cnHelper.getO() != null ? cnHelper.getO() : cnHelper.getOU();
            return retOrg;
        }
        return SecurityUIMsg.CERTPAGE_ERROR_UNKNOWN_FORMAT;
    }

    private class CertRowEntry {
        public Certificate cert;
        public int trustEngineIndex;

        public CertRowEntry(Certificate cert, int trustIndex) {
            this.cert = cert;
            this.trustEngineIndex = trustIndex;
        }
    }

    private class CertTableSorter
    implements Listener {
        final int columnSelected;
        private final CertRowEntry[] certRowEntry;

        CertTableSorter(int columnSelected, CertRowEntry[] certRowEntry) {
            this.columnSelected = columnSelected;
            this.certRowEntry = certRowEntry;
        }

        public void handleEvent(Event e) {
            TableColumn sortColumn = CertificatesPage.this.tableCert.getSortColumn();
            TableColumn currentColumn = (TableColumn)e.widget;
            int dir = CertificatesPage.this.tableCert.getSortDirection();
            if (sortColumn == currentColumn) {
                dir = dir == 128 ? 1024 : 128;
            } else {
                CertificatesPage.this.tableCert.setSortColumn(currentColumn);
                dir = 128;
            }
            int direction = dir;
            Arrays.sort(this.certRowEntry, new Comparator(this, direction){
                final /* synthetic */ CertTableSorter this$1;
                private final /* synthetic */ int val$direction;
                {
                    this.this$1 = certTableSorter;
                    this.val$direction = n;
                }

                public int compare(Object arg0, Object arg1) {
                    if (this.this$1.columnSelected == 0) {
                        String issueTo1 = CertificatesPage.getSubjectCommonName(((CertRowEntry)arg0).cert);
                        String issueTo2 = CertificatesPage.getSubjectCommonName(((CertRowEntry)arg1).cert);
                        if (this.val$direction == 128) {
                            return issueTo1.compareTo(issueTo2);
                        }
                        return issueTo2.compareTo(issueTo1);
                    }
                    if (this.this$1.columnSelected == 1) {
                        String issueOrg1 = CertificatesPage.getIssuerOrg(((CertRowEntry)arg0).cert);
                        String issueOrg2 = CertificatesPage.getIssuerOrg(((CertRowEntry)arg1).cert);
                        if (this.val$direction == 128) {
                            return issueOrg1.compareTo(issueOrg2);
                        }
                        return issueOrg2.compareTo(issueOrg1);
                    }
                    String provider1 = CertTableSorter.access$0((CertTableSorter)this.this$1).activeTrustEngines[((CertRowEntry)arg0).trustEngineIndex].getName();
                    String provider2 = CertTableSorter.access$0((CertTableSorter)this.this$1).activeTrustEngines[((CertRowEntry)arg1).trustEngineIndex].getName();
                    if (this.val$direction == 128) {
                        return provider1.compareTo(provider2);
                    }
                    return provider2.compareTo(provider1);
                }
            });
            CertificatesPage.this.tableCert.setSortDirection(dir);
            CertificatesPage.this.tableCert.clearAll();
            CertificatesPage.this.tableViewer.setInput((Object)this.certRowEntry);
        }

        static /* synthetic */ CertificatesPage access$0(CertTableSorter certTableSorter) {
            return certTableSorter.CertificatesPage.this;
        }
    }

    class SystemCertificatesContentProvider
    implements IStructuredContentProvider {
        SystemCertificatesContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CertRowEntry[]) {
                return (Object[])inputElement;
            }
            throw new IllegalArgumentException();
        }

        public void dispose() {
        }
    }

    class SystemCertificatesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TrustEngine[] tEngines;

        public SystemCertificatesLabelProvider(TrustEngine[] engines) {
            this.tEngines = engines;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String label = null;
            CertRowEntry certRowEntry = (CertRowEntry)element;
            switch (columnIndex) {
                case 0: {
                    label = CertificatesPage.getSubjectCommonName(certRowEntry.cert);
                    break;
                }
                case 1: {
                    label = CertificatesPage.getIssuerOrg(certRowEntry.cert);
                    break;
                }
                case 2: {
                    label = this.tEngines[certRowEntry.trustEngineIndex].getName();
                    break;
                }
            }
            return label;
        }
    }
}

