/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.internal;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.editors.properties.quickedittabsections.QuickEditTabSections;
import org.eclipse.jst.pagedesigner.properties.DesignerPropertyTool;
import org.eclipse.jst.pagedesigner.properties.WPETabbedPropertySheetPage;
import org.eclipse.jst.pagedesigner.properties.internal.NullQuickEditTabGroupDescriptor;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditTabSectionsDescriptor;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditTabSectionsManager;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QuickEditTabManager {
    private QuickEditTabSectionsManager _groupsManager;
    private QuickEditTabSections _quickEditTabSections;
    private Entity _tagEntity;
    private QName _lastTagID;
    private QuickEditTabSectionsDescriptor _lastQuickEditTabGroup;
    private QuickEditTabSectionsDescriptor _nullQuickEditTabGroup;
    private Element _lastElement;

    private QuickEditTabSectionsManager getRegistry() {
        return this._groupsManager;
    }

    public static synchronized QuickEditTabManager acquireInstance(WPETabbedPropertySheetPage page) {
        IProject project = QuickEditTabManager.getProject(page);
        QuickEditTabManager instance = new QuickEditTabManager();
        instance._groupsManager = QuickEditTabSectionsManager.acquireInstance(project);
        return instance;
    }

    public synchronized void releaseInstance() {
        this._groupsManager.releaseInstance();
    }

    private QuickEditTabManager() {
    }

    private static IProject getProject(WPETabbedPropertySheetPage page) {
        IProject proj = null;
        IDocument doc = ((HTMLEditor)page.getEditor()).getDocument();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(doc, 0);
        if (context != null) {
            proj = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context).getProject();
        }
        return proj;
    }

    public boolean selectionChanged(IWorkbenchPart part, ISelection selection) {
        boolean hasChanged = false;
        QuickEditTabSections qets = this.getQuickTabSectionsMetaData(part, selection);
        if (qets == null) {
            hasChanged = this._quickEditTabSections != null;
            this._quickEditTabSections = qets;
            this._lastQuickEditTabGroup = this.getNullQuickEditTab();
            this._lastTagID = null;
        } else {
            QName tagId = this.getTagId();
            if (this._lastTagID == null || !this._lastTagID.equals(tagId)) {
                this._quickEditTabSections = qets;
                QuickEditTabSectionsDescriptor group = this.getRegistry().getQuickEditTabSectionsFor(tagId);
                if (group == null && (group = this.createQuickEditTabGroup(tagId, this._quickEditTabSections)) != null) {
                    group.calculateSections();
                    this.getRegistry().addQuickEditTabGroupDescriptor(group);
                }
                this._lastQuickEditTabGroup = group;
                this._lastTagID = tagId;
            }
        }
        return hasChanged;
    }

    public QuickEditTabSectionsDescriptor getCurrentTabGroupDescriptor() {
        return this._lastQuickEditTabGroup;
    }

    private QuickEditTabSections getQuickTabSectionsMetaData(IWorkbenchPart part, ISelection selection) {
        Element node = DesignerPropertyTool.getElement(part, selection);
        if (node == null) {
            return null;
        }
        if (this._lastElement != node) {
            Trait pds;
            this._lastElement = node;
            this._quickEditTabSections = null;
            this._tagEntity = this.getTagEntity(part, selection, node);
            if (this._tagEntity != null && (pds = TaglibDomainMetaDataQueryHelper.getTrait((Entity)this._tagEntity, (String)"quick-edit-tab")) != null) {
                this._quickEditTabSections = (QuickEditTabSections)pds.getValue();
            }
        }
        return this._quickEditTabSections;
    }

    private QuickEditTabSectionsDescriptor createQuickEditTabGroup(QName tagId, QuickEditTabSections tabSections) {
        return new QuickEditTabSectionsDescriptor(this._tagEntity, tagId, tabSections);
    }

    private QName getTagId() {
        return TaglibDomainMetaDataQueryHelper.getQNameForTagEntity((Entity)this._tagEntity);
    }

    public void dispose() {
        this._lastQuickEditTabGroup = null;
        this._lastElement = null;
        this._lastTagID = null;
        this._nullQuickEditTabGroup = null;
        this._quickEditTabSections = null;
        this._groupsManager = null;
    }

    private Entity getTagEntity(IWorkbenchPart part, ISelection selection, Element node) {
        HTMLEditor ed = null;
        if (part instanceof HTMLEditor) {
            ed = (HTMLEditor)part;
        }
        if (ed == null) {
            return null;
        }
        if (ed.getEditorInput() instanceof FileEditorInput) {
            ITaglibContextResolver resolver;
            FileEditorInput input = (FileEditorInput)ed.getEditorInput();
            IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(ed.getDocument(), (Node)node);
            if (context != null && (resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context)) != null) {
                ITaglibDomainMetaDataModelContext mdContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)input.getFile().getProject(), (String)resolver.getTagURIForNodeName((Node)node));
                return TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)mdContext, (String)node.getLocalName());
            }
        }
        return null;
    }

    private QuickEditTabSectionsDescriptor getNullQuickEditTab() {
        if (this._nullQuickEditTabGroup == null) {
            this._nullQuickEditTabGroup = new NullQuickEditTabGroupDescriptor();
            this._nullQuickEditTabGroup.calculateSections();
        }
        return this._nullQuickEditTabGroup;
    }

    public QuickEditTabSectionsManager getQuickEditTabSectionsManager() {
        return this._groupsManager;
    }
}

