/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi.equinox;

import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.osgi.CompositeClassLoader;
import org.eclipse.persistence.internal.jpa.deployment.osgi.equinox.EquinoxWeaver;
import org.eclipse.persistence.jpa.equinox.weaving.IWeaver;
import org.eclipse.persistence.jpa.osgi.Activator;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class EquinoxInitializer
extends JPAInitializer {
    public EquinoxInitializer(ClassLoader bundleClassloader, Map m, PersistenceInitializationHelper helper) {
        this.initializationClassloader = bundleClassloader;
    }

    public void checkWeaving(Map properties) {
        String weaving = EntityManagerFactoryProvider.getConfigPropertyAsString((String)"eclipselink.weaving", (Map)properties, null);
        if (weaving == null) {
            weaving = "false";
            properties.put("eclipselink.weaving", weaving);
        }
        if (weaving != null && (weaving.equalsIgnoreCase("false") || weaving.equalsIgnoreCase("static"))) {
            this.shouldCreateInternalLoader = false;
        }
    }

    protected ClassLoader createTempLoader(Collection classNames) {
        return this.createTempLoader(classNames, true);
    }

    protected ClassLoader createTempLoader(Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
        if (!this.shouldCreateInternalLoader) {
            return this.initializationClassloader;
        }
        if (this.initializationClassloader instanceof CompositeClassLoader) {
            CompositeClassLoader compositeLoader = (CompositeClassLoader)this.initializationClassloader;
            ClassLoader firstLoader = (ClassLoader)compositeLoader.getClassLoaders().get(0);
            if (firstLoader instanceof DefaultClassLoader) {
                DefaultClassLoader baseClassLoader = (DefaultClassLoader)firstLoader;
                ClassLoaderDelegate delegate = baseClassLoader.getDelegate();
                ProtectionDomain domain = baseClassLoader.getDomain();
                ClasspathManager classpathManager = baseClassLoader.getClasspathManager();
                ClasspathEntry[] entries = classpathManager.getHostClasspathEntries();
                String[] classpath = new String[entries.length];
                for (int i = 0; i < entries.length; ++i) {
                    BundleFile bundleFile = entries[i].getBundleFile();
                    classpath[i] = bundleFile instanceof ZipBundleFile ? "." : bundleFile.getBaseFile().getAbsolutePath();
                }
                BaseData bundledata = classpathManager.getBaseData();
                TempEquinoxEntityLoader tempLoader = new TempEquinoxEntityLoader((ClassLoader)baseClassLoader, delegate, domain, bundledata, classpath, classNames, true);
                AbstractSessionLog.getLog().log(2, "cmp_init_tempLoader_created", (Object)tempLoader);
                AbstractSessionLog.getLog().log(2, "cmp_init_shouldOverrideLoadClassForCollectionMembers", (Object)shouldOverrideLoadClassForCollectionMembers);
                return tempLoader;
            }
            return compositeLoader;
        }
        return this.initializationClassloader;
    }

    public void registerTransformer(ClassTransformer transformer, PersistenceUnitInfo persistenceUnitInfo) {
        if (transformer != null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_register_transformer", (Object)persistenceUnitInfo.getPersistenceUnitName());
            EquinoxWeaver weavingService = new EquinoxWeaver(transformer);
            Activator.getContext().registerService(IWeaver.class.getName(), (Object)weavingService, new Hashtable());
            AbstractSessionLog.getLog().log(2, "Registering Weaving Service");
        } else if (transformer == null) {
            AbstractSessionLog.getLog().log(2, "cmp_init_transformer_is_null");
        }
    }

    private class TempEquinoxEntityLoader
    extends DefaultClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        public TempEquinoxEntityLoader(ClassLoader parent, ClassLoaderDelegate delegate, ProtectionDomain domain, BaseData bundledata, String[] classpath) {
            super(parent, delegate, domain, bundledata, classpath);
            this.shouldOverrideLoadClassForCollectionMembers = true;
            this.initialize();
        }

        public TempEquinoxEntityLoader(ClassLoader parent, ClassLoaderDelegate delegate, ProtectionDomain domain, BaseData bundledata, String[] classpath, Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
            this(parent, delegate, domain, bundledata, classpath);
            this.classNames = classNames;
            this.shouldOverrideLoadClassForCollectionMembers = shouldOverrideLoadClassForCollectionMembers;
        }

        protected boolean shouldOverrideLoadClass(String name) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(name);
            }
            return !name.startsWith("java.") && !name.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(name));
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(name)) {
                Class c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findLocalClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

