/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.Calendar;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationBase;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationPlotImpl;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public final class ChartReportItemPresentationAxisImpl
extends ChartReportItemPresentationBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelObject(ExtendedItemHandle eih) {
        this.modelHandle = (ExtendedItemHandle)eih.getElementProperty("hostChart");
        IReportItem item = this.getReportItem(this.modelHandle);
        if (item == null) {
            return;
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
        IReportItem iReportItem = item;
        synchronized (iReportItem) {
            if (this.cm != null) {
                this.cm = this.cm.copyInstance();
            }
        }
        this.setChartModelObject(item);
    }

    protected Bounds computeBounds() throws ChartException {
        Bounds originalBounds = this.cm.getBlock().getBounds();
        Bounds bounds = originalBounds.copyInstance();
        if (this.cm instanceof ChartWithAxes) {
            try {
                ChartWithAxes chart = (ChartWithAxes)this.cm;
                AggregationCellHandle xtabCell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.modelHandle);
                if (chart.isTransposed()) {
                    bounds.setHeight(0.0);
                    double dWidth = ChartReportItemPresentationPlotImpl.getColumnCellWidth(xtabCell.getCrosstab(), this.dpi);
                    if (!ChartUtil.mathEqual((double)dWidth, (double)0.0) && !ChartUtil.mathEqual((double)dWidth, (double)ChartCubeUtil.DEFAULT_COLUMN_WIDTH.getMeasure())) {
                        bounds.setWidth(dWidth);
                    } else if (!bounds.isSetWidth() || ChartUtil.mathEqual((double)bounds.getWidth(), (double)0.0)) {
                        bounds.setWidth(ChartCubeUtil.DEFAULT_COLUMN_WIDTH.getMeasure());
                    }
                } else {
                    bounds.setWidth(0.0);
                    double dHeight = ChartReportItemPresentationPlotImpl.getRowCellHeight(xtabCell.getCrosstab(), this.dpi);
                    if (!ChartUtil.mathEqual((double)dHeight, (double)0.0) && !ChartUtil.mathEqual((double)dHeight, (double)ChartCubeUtil.DEFAULT_ROW_HEIGHT.getMeasure())) {
                        bounds.setHeight(dHeight);
                    } else if (!bounds.isSetHeight() || ChartUtil.mathEqual((double)bounds.getHeight(), (double)0.0)) {
                        bounds.setHeight(ChartCubeUtil.DEFAULT_ROW_HEIGHT.getMeasure());
                    }
                }
            }
            catch (BirtException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)e);
            }
        }
        return bounds;
    }

    protected void updateChartModel() {
        super.updateChartModel();
        ChartCubeUtil.updateModelToRenderAxis(this.cm, this.rtc.isRightToLeft());
    }

    protected IDataRowExpressionEvaluator createEvaluator(IBaseResultSet set) throws ChartException {
        ChartWithAxes cwa;
        Axis yAxis;
        if (this.rtc.getSharedScale() == null || !this.rtc.getSharedScale().isShared()) {
            return super.createEvaluator(set);
        }
        final boolean bDatetypeAxis = this.cm instanceof ChartWithAxes ? (yAxis = (cwa = (ChartWithAxes)this.cm).getOrthogonalAxes(cwa.getBaseAxes()[0], true)[0]).getType() == AxisType.DATE_TIME_LITERAL : false;
        return new IDataRowExpressionEvaluator(){
            private int count = 1;

            public void close() {
            }

            public Object evaluate(String expression) {
                return bDatetypeAxis ? Calendar.getInstance() : Integer.valueOf(1);
            }

            public Object evaluateGlobal(String expression) {
                return this.evaluate(expression);
            }

            public boolean first() {
                return true;
            }

            public boolean next() {
                return this.count-- > 0;
            }
        };
    }
}

