/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.ChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.ElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.FilterTransform;
import org.eclipse.debug.internal.ui.viewers.model.IMementoManager;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProviderTarget;
import org.eclipse.debug.internal.ui.viewers.model.ModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.ViewerUpdateMonitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStateUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

abstract class ModelContentProvider
implements IContentProvider,
IModelChangedListener {
    private ITreeModelContentProviderTarget fViewer;
    private int fModelDeltaMask = -1;
    private Map fTreeModelProxies = new HashMap();
    private Map fModelProxies = new HashMap();
    private FilterTransform fTransform = new FilterTransform();
    private ListenerList fModelListeners = new ListenerList();
    private ListenerList fUpdateListeners = new ListenerList();
    private ListenerList fStateUpdateListeners = new ListenerList();
    private Map fRequestsInProgress = new HashMap();
    private Map fWaitingRequests = new HashMap();
    private Map fViewerStates = Collections.synchronizedMap(new LRUMap(20));
    private ModelDelta fPendingState = null;
    private boolean fInStateRestore = false;
    private Map fCompareRequestsInProgress = new LinkedHashMap();
    private Set fPendingStateSaves = new HashSet();
    private Object fQueuedRestore = null;
    private static final String ELEMENT_REMOVED = "ELEMENT_REMOVED";
    static final int UPDATE_SEQUENCE_BEGINS = 0;
    static final int UPDATE_SEQUENCE_COMPLETE = 1;
    static final int UPDATE_BEGINS = 2;
    static final int UPDATE_COMPLETE = 3;
    static final int STATE_SAVE_SEQUENCE_BEGINS = 4;
    static final int STATE_SAVE_SEQUENCE_COMPLETE = 5;
    static final int STATE_RESTORE_SEQUENCE_BEGINS = 6;
    static final int STATE_RESTORE_SEQUENCE_COMPLETE = 7;
    protected static final TreePath EMPTY_TREE_PATH = new TreePath(new Object[0]);
    public static String DEBUG_PRESENTATION_ID = null;
    public static boolean DEBUG_CONTENT_PROVIDER = false;
    public static boolean DEBUG_UPDATE_SEQUENCE = false;
    public static boolean DEBUG_STATE_SAVE_RESTORE = false;
    public static boolean DEBUG_DELTAS = false;

    static {
        DEBUG_PRESENTATION_ID = Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/presentationId");
        if (!DebugUIPlugin.DEBUG || "".equals(DEBUG_PRESENTATION_ID)) {
            DEBUG_PRESENTATION_ID = null;
        }
        DEBUG_CONTENT_PROVIDER = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/contentProvider"));
        DEBUG_UPDATE_SEQUENCE = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/updateSequence"));
        DEBUG_STATE_SAVE_RESTORE = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/stateSaveRestore"));
        DEBUG_DELTAS = DebugUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.debug.ui/debug/viewers/deltas"));
    }

    ModelContentProvider() {
    }

    public static boolean DEBUG_TEST_PRESENTATION_ID(IPresentationContext context) {
        if (context == null) {
            return true;
        }
        return DEBUG_PRESENTATION_ID == null || DEBUG_PRESENTATION_ID.equals(context.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.fRequestsInProgress;
        synchronized (object) {
            Iterator iterator = this.fRequestsInProgress.values().iterator();
            while (iterator.hasNext()) {
                List requests = (List)iterator.next();
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ((IRequest)reqIter.next()).cancel();
                }
            }
            this.fWaitingRequests.clear();
        }
        object = this;
        synchronized (object) {
            Iterator itr = this.fPendingStateSaves.iterator();
            while (itr.hasNext()) {
                ((IMementoManager)itr.next()).cancel();
            }
            this.fModelListeners.clear();
            this.fUpdateListeners.clear();
            this.fStateUpdateListeners.clear();
            this.disposeAllModelProxies();
            this.fViewer = null;
        }
    }

    public synchronized boolean isDisposed() {
        return this.fViewer == null;
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (ITreeModelContentProviderTarget)viewer;
        if (oldInput != null) {
            Iterator itr = this.fCompareRequestsInProgress.values().iterator();
            while (itr.hasNext()) {
                ((ElementCompareRequest)itr.next()).cancel();
                itr.remove();
            }
            this.saveViewerState(oldInput);
        }
        if (newInput != oldInput) {
            this.cancelSubtreeUpdates(TreePath.EMPTY);
            this.disposeAllModelProxies();
            this.cancelSubtreeUpdates(TreePath.EMPTY);
            this.fTransform.clear();
            if (newInput != null) {
                this.installModelProxy(newInput, TreePath.EMPTY);
                this.restoreViewerState(newInput);
            }
        }
    }

    protected synchronized void restoreViewerState(Object input) {
        this.fPendingState = null;
        if (this.isSavingState()) {
            this.fQueuedRestore = input;
        } else {
            this.startRestoreViewerState(input);
        }
    }

    private synchronized void startRestoreViewerState(final Object input) {
        this.fPendingState = null;
        final IElementMementoProvider defaultProvider = ViewerAdapterService.getMementoProvider(input);
        if (defaultProvider != null) {
            final ModelDelta delta = new ModelDelta(input, 0);
            XMLMemento inputMemento = XMLMemento.createWriteRoot((String)"VIEWER_INPUT_MEMENTO");
            IMementoManager manager = new IMementoManager(){
                private IElementMementoRequest fRequest;

                public void requestComplete(IElementMementoRequest request) {
                    ModelContentProvider.this.notifyStateUpdate(input, 3, request);
                    if (!request.isCanceled() && (request.getStatus() == null || request.getStatus().isOK())) {
                        XMLMemento keyMemento = (XMLMemento)delta.getElement();
                        StringWriter writer = new StringWriter();
                        try {
                            keyMemento.save((Writer)writer);
                            String keyMementoString = writer.toString();
                            ModelDelta stateDelta = (ModelDelta)ModelContentProvider.this.fViewerStates.get(keyMementoString);
                            if (stateDelta != null) {
                                if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                                    System.out.println("STATE RESTORE INPUT COMARE ENDED : " + this.fRequest + " - MATCHING STATE FOUND");
                                }
                                UIJob job = new UIJob(this, "restore state", input, keyMementoString){
                                    final /* synthetic */ 1 this$1;
                                    private final /* synthetic */ Object val$input;
                                    private final /* synthetic */ String val$keyMementoString;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$input = object;
                                        this.val$keyMementoString = string;
                                    }

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (!1.access$0(this.this$1).isDisposed() && this.val$input.equals(1.access$0(this.this$1).getViewer().getInput())) {
                                            ModelDelta stateDelta2 = (ModelDelta)ModelContentProvider.access$0(1.access$0(this.this$1)).remove(this.val$keyMementoString);
                                            if (stateDelta2 != null) {
                                                if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(1.access$0(this.this$1).getPresentationContext())) {
                                                    System.out.println("STATE RESTORE BEGINS");
                                                    System.out.println("\tRESTORE: " + stateDelta2.toString());
                                                    1.access$0(this.this$1).notifyStateUpdate(this.val$input, 6, null);
                                                }
                                                stateDelta2.setElement(this.val$input);
                                                ModelContentProvider.access$1(1.access$0(this.this$1), stateDelta2);
                                                1.access$0(this.this$1).doInitialRestore(ModelContentProvider.access$2(1.access$0(this.this$1)));
                                            }
                                        } else if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(1.access$0(this.this$1).getPresentationContext())) {
                                            System.out.println("STATE RESTORE CANCELED.");
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.setSystem(true);
                                job.schedule();
                            } else if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                                System.out.println("STATE RESTORE INPUT COMARE ENDED : " + this.fRequest + " - NO MATCHING STATE");
                            }
                        }
                        catch (IOException e) {
                            DebugUIPlugin.log(e);
                        }
                    } else {
                        ModelContentProvider.this.notifyStateUpdate(input, 6, null);
                    }
                }

                public void processReqeusts() {
                    ModelContentProvider.this.notifyStateUpdate(input, 6, null);
                    if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                        System.out.println("STATE RESTORE INPUT COMARE BEGIN : " + this.fRequest);
                    }
                    ModelContentProvider.this.notifyStateUpdate(input, 2, this.fRequest);
                    defaultProvider.encodeElements(new IElementMementoRequest[]{this.fRequest});
                }

                public void addRequest(IElementMementoRequest req) {
                    this.fRequest = req;
                }

                public void cancel() {
                }

                static /* synthetic */ ModelContentProvider access$0(1 var0) {
                    return var0.ModelContentProvider.this;
                }
            };
            manager.addRequest(new ElementMementoRequest(this, this.getViewer().getInput(), manager, this.getPresentationContext(), delta.getElement(), this.getViewerTreePath(delta), (IMemento)inputMemento, delta));
            manager.processReqeusts();
        } else if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("STATE RESTORE: No input memento provider");
        }
    }

    protected abstract void doInitialRestore(ModelDelta var1);

    abstract void restorePendingStateNode(ModelDelta var1, boolean var2, boolean var3, boolean var4);

    public void cancelRestore(final TreePath path, int flags) {
        int mask;
        if (this.fPendingState == null) {
            return;
        }
        if (this.fInStateRestore) {
            return;
        }
        if ((flags & 0x1200000) != 0) {
            mask = flags & 0x1200000;
            this.fPendingState.accept(new IModelDeltaVisitor(){

                public boolean visit(IModelDelta delta, int depth) {
                    int deltaFlags = delta.getFlags();
                    int newFlags = deltaFlags & ~mask;
                    if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext()) && deltaFlags != newFlags) {
                        System.out.println("\tCANCEL: " + delta.getElement() + "(" + Integer.toHexString(deltaFlags & mask) + ")");
                    }
                    ((ModelDelta)delta).setFlags(newFlags);
                    return true;
                }
            });
        }
        if ((flags & 0xFEDFFFFF) != 0) {
            mask = flags & 0xFEDFFFFF;
            this.fPendingState.accept(new IModelDeltaVisitor(){

                public boolean visit(IModelDelta delta, int depth) {
                    if (depth == path.getSegmentCount()) {
                        TreePath deltaPath = ModelContentProvider.this.getViewerTreePath(delta);
                        if (deltaPath.equals((Object)path)) {
                            int deltaFlags = delta.getFlags();
                            int newFlags = deltaFlags & ~mask;
                            if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext()) && deltaFlags != newFlags) {
                                System.out.println("\tCANCEL: " + delta.getElement() + "(" + Integer.toHexString(deltaFlags & mask) + ")");
                            }
                            ((ModelDelta)delta).setFlags(newFlags);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    protected void appendToPendingStateDelta(final TreePath path) {
        ModelDelta appendDeltaRoot;
        if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("STATE APPEND BEGIN: " + path.getLastSegment());
        }
        ModelDelta delta = appendDeltaRoot = new ModelDelta(this.getViewer().getInput(), 0);
        int i = 0;
        while (i < path.getSegmentCount()) {
            delta = delta.addNode(path.getSegment(i), 0);
            ++i;
        }
        if (!this.fViewer.saveElementState(path, delta, 0x2300000)) {
            if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("STATE APPEND CANCEL: Element " + path.getLastSegment() + " not found.");
            }
            return;
        }
        delta.accept(new IModelDeltaVisitor(){

            public boolean visit(IModelDelta d, int depth) {
                if ((d.getFlags() & 0x100000) != 0) {
                    ((ModelDelta)d).setFlags(d.getFlags() | 0x400);
                }
                return true;
            }
        });
        if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("\tAPPEND DELTA: " + appendDeltaRoot);
        }
        if (this.fPendingState != null) {
            if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("\tAPPEND OUTSTANDING RESTORE: " + this.fPendingState);
            }
            if (path.getSegmentCount() > 0) {
                this.fPendingState.accept(new IModelDeltaVisitor(){

                    public boolean visit(IModelDelta pendingDeltaNode, int depth) {
                        TreePath pendingDeltaPath = ModelContentProvider.this.getViewerTreePath(pendingDeltaNode);
                        if (path.startsWith(pendingDeltaPath, null)) {
                            ModelDelta appendDelta = ModelContentProvider.this.findDeltaForPath(appendDeltaRoot, pendingDeltaPath);
                            appendDelta.setFlags(pendingDeltaNode.getFlags());
                            appendDelta.setChildCount(pendingDeltaNode.getChildCount());
                            appendDelta.setIndex(pendingDeltaNode.getIndex());
                            return true;
                        }
                        return false;
                    }
                });
            }
            this.fPendingState.accept(new IModelDeltaVisitor(){

                public boolean visit(IModelDelta pendingDeltaNode, int depth) {
                    if (pendingDeltaNode.getParentDelta() == null) {
                        return true;
                    }
                    ModelDelta saveDeltaNode = ModelContentProvider.this.findSubDeltaParent(appendDeltaRoot, pendingDeltaNode);
                    if (saveDeltaNode != null && !ModelContentProvider.this.isDeltaInParent(pendingDeltaNode, saveDeltaNode) && pendingDeltaNode.getFlags() != 0) {
                        saveDeltaNode.setChildCount(pendingDeltaNode.getParentDelta().getChildCount());
                        ModelContentProvider.this.copyIntoDelta(pendingDeltaNode, saveDeltaNode);
                    } else if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                        System.out.println("\tSKIPPED: " + pendingDeltaNode.getElement());
                    }
                    if (pendingDeltaNode.getElement() instanceof IMemento) {
                        return false;
                    }
                    return pendingDeltaNode.getChildCount() > 0;
                }
            });
        }
        if (appendDeltaRoot.getChildDeltas().length > 0) {
            if (this.fPendingState == null) {
                this.notifyStateUpdate(appendDeltaRoot.getElement(), 6, null);
            }
            this.fPendingState = appendDeltaRoot;
            if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("STATE APPEND COMPLETE " + this.fPendingState);
            }
        } else if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("STATE APPEND CANCELED: No Data");
        }
    }

    protected synchronized void restorePendingStateOnUpdate(final TreePath path, final int modelIndex, final boolean knowsHasChildren, final boolean knowsChildCount, final boolean checkChildrenRealized) {
        if (this.fPendingState == null) {
            return;
        }
        IModelDeltaVisitor visitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                Object potentialMatch;
                Object element = delta.getElement();
                Object object = potentialMatch = depth != 0 ? path.getSegment(depth - 1) : ModelContentProvider.this.getViewer().getInput();
                if (depth == path.getSegmentCount()) {
                    if (element instanceof IMemento) {
                        IElementMementoProvider provider = ViewerAdapterService.getMementoProvider(potentialMatch);
                        if (provider == null) {
                            provider = ViewerAdapterService.getMementoProvider(ModelContentProvider.this.getViewer().getInput());
                        }
                        if (provider != null) {
                            CompareRequestKey key = new CompareRequestKey(path, delta);
                            ElementCompareRequest existingRequest = (ElementCompareRequest)ModelContentProvider.this.fCompareRequestsInProgress.get(key);
                            if (existingRequest != null) {
                                existingRequest.setKnowsHasChildren(knowsHasChildren);
                                existingRequest.setKnowsChildCount(knowsChildCount);
                                existingRequest.setCheckChildrenRealized(checkChildrenRealized);
                            } else {
                                ElementCompareRequest compareRequest = new ElementCompareRequest(ModelContentProvider.this, ModelContentProvider.this.getViewer().getInput(), potentialMatch, path, (IMemento)element, (ModelDelta)delta, modelIndex, knowsHasChildren, knowsChildCount, checkChildrenRealized);
                                ModelContentProvider.this.fCompareRequestsInProgress.put(key, compareRequest);
                                if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                                    System.out.println("\tSTATE BEGIN: " + compareRequest);
                                }
                                ModelContentProvider.this.notifyStateUpdate(element, 2, compareRequest);
                                provider.compareElements(new IElementCompareRequest[]{compareRequest});
                            }
                        }
                    } else if (element.equals(potentialMatch)) {
                        ModelContentProvider.this.restorePendingStateNode((ModelDelta)delta, knowsHasChildren, knowsChildCount, checkChildrenRealized);
                    }
                    return false;
                }
                return element.equals(potentialMatch);
            }
        };
        try {
            this.fInStateRestore = true;
            this.fPendingState.accept(visitor);
        }
        finally {
            this.fInStateRestore = false;
        }
        this.checkIfRestoreComplete();
    }

    void compareFinished(ElementCompareRequest request, ModelDelta delta) {
        this.notifyStateUpdate(request.getViewerInput(), 3, request);
        if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("\tSTATE END: " + request + " = " + false);
        }
        this.fCompareRequestsInProgress.remove(new CompareRequestKey(request.getElementPath(), delta));
        if (!request.isCanceled()) {
            if (request.isEqual()) {
                delta.setElement(request.getElement());
                this.restorePendingStateNode(delta, request.knowsHasChildren(), request.knowChildCount(), request.checkChildrenRealized());
            } else if (request.getModelIndex() != -1 && (delta.getFlags() & 0x1000000) != 0 && delta.getIndex() == request.getModelIndex()) {
                delta.setFlags(delta.getFlags() & 0xFEFFFFFF);
            }
        }
        this.checkIfRestoreComplete();
    }

    protected void saveViewerState(Object input) {
        IElementMementoProvider stateProvider = ViewerAdapterService.getMementoProvider(input);
        if (stateProvider != null) {
            if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("STATE SAVE BEGIN: " + input);
            }
            final ModelDelta saveDeltaRoot = new ModelDelta(input, 0);
            this.buildViewerState(saveDeltaRoot);
            if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("\tSAVE DELTA FROM VIEW:\n" + saveDeltaRoot);
            }
            if (this.fPendingState != null) {
                if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                    System.out.println("\tSAVE OUTSTANDING RESTORE: " + this.fPendingState);
                }
                IModelDeltaVisitor pendingStateVisitor = new IModelDeltaVisitor(){

                    public boolean visit(IModelDelta pendingDeltaNode, int depth) {
                        if (pendingDeltaNode.getParentDelta() == null) {
                            return true;
                        }
                        ModelDelta saveDeltaNode = ModelContentProvider.this.findSubDeltaParent(saveDeltaRoot, pendingDeltaNode);
                        if (saveDeltaNode != null && !ModelContentProvider.this.isDeltaInParent(pendingDeltaNode, saveDeltaNode) && pendingDeltaNode.getFlags() != 0) {
                            if ((pendingDeltaNode.getFlags() & 0x1000000) != 0) {
                                ModelContentProvider.this.clearRevealFlag(saveDeltaRoot);
                            }
                            saveDeltaNode.setChildCount(pendingDeltaNode.getParentDelta().getChildCount());
                            ModelContentProvider.this.copyIntoDelta(pendingDeltaNode, saveDeltaNode);
                        } else if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                            System.out.println("\tSKIPPED: " + pendingDeltaNode.getElement());
                        }
                        if (pendingDeltaNode.getElement() instanceof IMemento) {
                            return false;
                        }
                        return pendingDeltaNode.getChildCount() > 0;
                    }
                };
                this.fPendingState.accept(pendingStateVisitor);
            }
            if (saveDeltaRoot.getChildDeltas().length > 0) {
                this.encodeDelta(saveDeltaRoot, stateProvider);
            } else if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("STATE SAVE CANCELED, NO DATA");
            }
        }
    }

    private void clearRevealFlag(ModelDelta saveRootDelta) {
        IModelDeltaVisitor clearDeltaVisitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                if ((delta.getFlags() & 0x1000000) != 0) {
                    ((ModelDelta)delta).setFlags(delta.getFlags() & 0xFEFFFFFF);
                }
                return true;
            }
        };
        saveRootDelta.accept(clearDeltaVisitor);
    }

    private ModelDelta findSubDeltaParent(ModelDelta destinationDeltaRoot, IModelDelta subDelta) {
        LinkedList<IModelDelta> deltaPath = new LinkedList<IModelDelta>();
        IModelDelta delta = subDelta;
        while (delta.getParentDelta() != null) {
            delta = delta.getParentDelta();
            deltaPath.addFirst(delta);
        }
        Iterator itr = deltaPath.iterator();
        itr.next();
        ModelDelta saveDelta = destinationDeltaRoot;
        block1: while (itr.hasNext()) {
            IModelDelta itrDelta = (IModelDelta)itr.next();
            int i = 0;
            while (i < saveDelta.getChildDeltas().length) {
                if (this.deltasEqual(saveDelta.getChildDeltas()[i], itrDelta)) {
                    saveDelta = (ModelDelta)saveDelta.getChildDeltas()[i];
                    continue block1;
                }
                ++i;
            }
            return null;
        }
        return saveDelta;
    }

    private ModelDelta findDeltaForPath(ModelDelta root, TreePath path) {
        ModelDelta delta = root;
        int i = 0;
        while (i < path.getSegmentCount()) {
            if ((delta = delta.getChildDelta(path.getSegment(i))) == null) {
                return null;
            }
            ++i;
        }
        return delta;
    }

    private boolean deltasEqual(IModelDelta d1, IModelDelta d2) {
        return d1.getElement().equals(d2.getElement()) && d1.getIndex() == d2.getIndex();
    }

    private boolean isDeltaInParent(IModelDelta delta, ModelDelta destParent) {
        int i = 0;
        while (i < destParent.getChildDeltas().length) {
            if (this.deltasEqual(destParent.getChildDeltas()[i], delta)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void copyIntoDelta(IModelDelta delta, ModelDelta destParent) {
        ModelDelta newDelta = destParent.addNode(delta.getElement(), delta.getIndex(), delta.getFlags(), delta.getChildCount());
        int i = 0;
        while (i < delta.getChildDeltas().length) {
            this.copyIntoDelta(delta.getChildDeltas()[i], newDelta);
            ++i;
        }
    }

    protected void encodeDelta(final ModelDelta rootDelta, final IElementMementoProvider defaultProvider) {
        final Object input = rootDelta.getElement();
        final XMLMemento inputMemento = XMLMemento.createWriteRoot((String)"VIEWER_INPUT_MEMENTO");
        final XMLMemento childrenMemento = XMLMemento.createWriteRoot((String)"CHILDREN_MEMENTO");
        final IMementoManager manager = new IMementoManager(){
            private List fRequests = new ArrayList();
            private boolean fCanceled = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void requestComplete(IElementMementoRequest request) {
                ModelContentProvider.this.notifyStateUpdate(input, 3, request);
                if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                    System.out.println("\tSTATE END: " + request);
                }
                if (!request.isCanceled() && (request.getStatus() == null || request.getStatus().isOK())) {
                    boolean requestsComplted = false;
                    11 var3_3 = this;
                    synchronized (var3_3) {
                        if (!this.fCanceled) {
                            this.fRequests.remove(request);
                            requestsComplted = this.fRequests.isEmpty();
                        }
                    }
                    if (requestsComplted) {
                        XMLMemento keyMemento = (XMLMemento)rootDelta.getElement();
                        StringWriter writer = new StringWriter();
                        try {
                            keyMemento.save((Writer)writer);
                            ModelContentProvider.this.fViewerStates.put(writer.toString(), rootDelta);
                        }
                        catch (IOException e) {
                            DebugUIPlugin.log(e);
                        }
                        if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                            System.out.println("STATE SAVE COMPLETED: " + rootDelta);
                        }
                        ModelContentProvider.this.stateSaveComplete(input, this);
                    }
                } else {
                    this.cancel();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                11 var1_1 = this;
                synchronized (var1_1) {
                    if (this.fCanceled) {
                        return;
                    }
                    this.fCanceled = true;
                    Iterator iterator = this.fRequests.iterator();
                    while (iterator.hasNext()) {
                        IElementMementoRequest req = (IElementMementoRequest)iterator.next();
                        req.cancel();
                    }
                    this.fRequests.clear();
                    if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                        System.out.println("STATE SAVE ABORTED: " + rootDelta.getElement());
                    }
                }
                ModelContentProvider.this.stateSaveComplete(input, this);
            }

            public synchronized void processReqeusts() {
                ArrayList<IElementMementoRequest> reqs;
                IElementMementoProvider provider;
                HashMap<IElementMementoProvider, ArrayList<IElementMementoRequest>> providers = new HashMap<IElementMementoProvider, ArrayList<IElementMementoRequest>>();
                Iterator<Object> iterator = this.fRequests.iterator();
                while (iterator.hasNext()) {
                    IElementMementoRequest request = (IElementMementoRequest)iterator.next();
                    ModelContentProvider.this.notifyStateUpdate(input, 2, request);
                    provider = ViewerAdapterService.getMementoProvider(request.getElement());
                    if (provider == null) {
                        provider = defaultProvider;
                    }
                    if ((reqs = (List)providers.get(provider)) == null) {
                        reqs = new ArrayList<IElementMementoRequest>();
                        providers.put(provider, reqs);
                    }
                    reqs.add(request);
                }
                iterator = providers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    provider = (IElementMementoProvider)entry.getKey();
                    reqs = (ArrayList<IElementMementoRequest>)entry.getValue();
                    provider.encodeElements(reqs.toArray(new IElementMementoRequest[reqs.size()]));
                }
            }

            public synchronized void addRequest(IElementMementoRequest request) {
                this.fRequests.add(request);
            }
        };
        IModelDeltaVisitor visitor = new IModelDeltaVisitor(){

            public boolean visit(IModelDelta delta, int depth) {
                if ((delta.getFlags() | 0x100000) != 0) {
                    ((ModelDelta)delta).setFlags(delta.getFlags() | 0x400);
                }
                if (delta.getParentDelta() == null) {
                    manager.addRequest(new ElementMementoRequest(ModelContentProvider.this, input, manager, ModelContentProvider.this.getPresentationContext(), delta.getElement(), ModelContentProvider.this.getViewerTreePath(delta), (IMemento)inputMemento, (ModelDelta)delta));
                } else if (!(delta.getElement() instanceof XMLMemento)) {
                    manager.addRequest(new ElementMementoRequest(ModelContentProvider.this, input, manager, ModelContentProvider.this.getPresentationContext(), delta.getElement(), ModelContentProvider.this.getViewerTreePath(delta), childrenMemento.createChild("CHILD_ELEMENT"), (ModelDelta)delta));
                }
                return true;
            }
        };
        rootDelta.accept(visitor);
        this.stateSaveStarted(input, manager);
        manager.processReqeusts();
    }

    private synchronized void stateSaveStarted(Object input, IMementoManager manager) {
        this.notifyStateUpdate(input, 4, null);
        this.fPendingStateSaves.add(manager);
    }

    private synchronized void stateSaveComplete(Object input, IMementoManager manager) {
        this.notifyStateUpdate(input, 5, null);
        this.fPendingStateSaves.remove(manager);
        if (this.fQueuedRestore != null) {
            Object temp = this.fQueuedRestore;
            this.fQueuedRestore = null;
            this.restoreViewerState(temp);
        }
    }

    private synchronized boolean isSavingState() {
        return !this.fPendingStateSaves.isEmpty();
    }

    protected abstract void buildViewerState(ModelDelta var1);

    protected synchronized void disposeModelProxy(TreePath path) {
        IModelProxy proxy = (IModelProxy)this.fTreeModelProxies.remove(path);
        if (proxy != null) {
            proxy.dispose();
        }
        if ((proxy = (IModelProxy)this.fModelProxies.remove(path.getLastSegment())) != null) {
            proxy.dispose();
        }
    }

    protected synchronized void disposeAllModelProxies() {
        IModelProxy proxy;
        Iterator updatePolicies = this.fModelProxies.values().iterator();
        while (updatePolicies.hasNext()) {
            proxy = (IModelProxy)updatePolicies.next();
            proxy.dispose();
        }
        this.fModelProxies.clear();
        updatePolicies = this.fTreeModelProxies.values().iterator();
        while (updatePolicies.hasNext()) {
            proxy = (IModelProxy)updatePolicies.next();
            proxy.dispose();
        }
        this.fTreeModelProxies.clear();
    }

    protected synchronized IModelProxy[] getModelProxies() {
        IModelProxy[] proxies = new IModelProxy[this.fTreeModelProxies.size() + this.fModelProxies.size()];
        this.fTreeModelProxies.values().toArray(proxies);
        System.arraycopy(this.fModelProxies.values().toArray(), 0, proxies, this.fModelProxies.size(), this.fModelProxies.size());
        return proxies;
    }

    protected synchronized IModelProxy getElementProxy(TreePath path) {
        while (path != null) {
            IModelProxy proxy = (IModelProxy)this.fTreeModelProxies.get(path);
            if (proxy != null) {
                return proxy;
            }
            Object element = path.getSegmentCount() == 0 ? this.getViewer().getInput() : path.getLastSegment();
            proxy = (IModelProxy)this.fModelProxies.get(element);
            if (proxy != null) {
                return proxy;
            }
            path = path.getParentPath();
        }
        return null;
    }

    protected synchronized void installModelProxy(Object input, TreePath path) {
        if (!this.fTreeModelProxies.containsKey(path) && !this.fModelProxies.containsKey(path.getLastSegment())) {
            IModelProxyFactory modelProxyFactory;
            Object element = path.getSegmentCount() != 0 ? path.getLastSegment() : input;
            IModelProxy proxy = null;
            IModelProxyFactory2 modelProxyFactory2 = ViewerAdapterService.getModelProxyFactory2(element);
            if (modelProxyFactory2 != null && (proxy = modelProxyFactory2.createTreeModelProxy(input, path, this.getPresentationContext())) != null) {
                this.fTreeModelProxies.put(path, proxy);
            }
            if (proxy == null && (modelProxyFactory = ViewerAdapterService.getModelProxyFactory(element)) != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
                this.fModelProxies.put(element, proxy);
            }
            if (proxy != null) {
                final IModelProxy finalProxy = proxy;
                Job job = new Job("Model Proxy installed notification job"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        if (!monitor.isCanceled()) {
                            IPresentationContext context = null;
                            Viewer viewer = null;
                            ModelContentProvider modelContentProvider = ModelContentProvider.this;
                            synchronized (modelContentProvider) {
                                if (!ModelContentProvider.this.isDisposed()) {
                                    context = ModelContentProvider.this.getPresentationContext();
                                    viewer = (Viewer)ModelContentProvider.this.getViewer();
                                }
                            }
                            if (context != null && !finalProxy.isDisposed()) {
                                finalProxy.init(context);
                                finalProxy.addModelChangedListener(ModelContentProvider.this);
                                finalProxy.installed(viewer);
                            }
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean shouldRun() {
                        return !ModelContentProvider.this.isDisposed();
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    protected abstract IPresentationContext getPresentationContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelChanged(final IModelDelta delta, final IModelProxy proxy) {
        Display display = null;
        ModelContentProvider modelContentProvider = this;
        synchronized (modelContentProvider) {
            if (this.fViewer != null && !proxy.isDisposed()) {
                display = this.fViewer.getDisplay();
            }
        }
        if (display != null) {
            if (Thread.currentThread().equals(display.getThread())) {
                this.doModelChanged(delta, proxy);
            } else {
                WorkbenchJob job = new WorkbenchJob(this.fViewer.getDisplay(), "process model delta"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ModelContentProvider.this.doModelChanged(delta, proxy);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    private void doModelChanged(IModelDelta delta, IModelProxy proxy) {
        if (!proxy.isDisposed()) {
            if (DEBUG_DELTAS && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.debug("RECEIVED DELTA: " + delta.toString());
            }
            this.updateModel(delta, this.getModelDeltaMask());
            Object[] listeners = this.fModelListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IModelChangedListener)listeners[i]).modelChanged(delta, proxy);
                ++i;
            }
        }
    }

    public void setModelDeltaMask(int mask) {
        this.fModelDeltaMask = mask;
    }

    public int getModelDeltaMask() {
        return this.fModelDeltaMask;
    }

    public void updateModel(IModelDelta delta, int mask) {
        IModelDelta[] deltaArray = new IModelDelta[]{delta};
        this.updateNodes(deltaArray, mask & 0x800002);
        this.updateNodes(deltaArray, mask & 0xC00C1B & 0xFF7FFFFD);
        this.updateNodes(deltaArray, mask & 0x7300000);
    }

    protected void updateNodes(IModelDelta[] nodes, int mask) {
        int i = 0;
        while (i < nodes.length) {
            IModelDelta node = nodes[i];
            int flags = node.getFlags() & mask;
            if ((flags & 1) != 0) {
                this.handleAdd(node);
            }
            if ((flags & 2) != 0) {
                this.handleRemove(node);
            }
            if ((flags & 0x400) != 0) {
                this.handleContent(node);
            }
            if ((flags & 0x800) != 0) {
                this.handleState(node);
            }
            if ((flags & 0x10) != 0) {
                this.handleInsert(node);
            }
            if ((flags & 8) != 0) {
                this.handleReplace(node);
            }
            if ((flags & 0x400000) != 0) {
                this.handleInstall(node);
            }
            if ((flags & 0x800000) != 0) {
                this.handleUninstall(node);
            }
            if ((flags & 0x100000) != 0) {
                this.handleExpand(node);
            }
            if ((flags & 0x2000000) != 0) {
                this.handleCollapse(node);
            }
            if ((flags & 0x200000) != 0) {
                this.handleSelect(node);
            }
            if ((flags & 0x1000000) != 0) {
                this.handleReveal(node);
            }
            this.updateNodes(node.getChildDeltas(), mask);
            ++i;
        }
    }

    protected abstract void handleState(IModelDelta var1);

    protected abstract void handleSelect(IModelDelta var1);

    protected abstract void handleExpand(IModelDelta var1);

    protected abstract void handleCollapse(IModelDelta var1);

    protected abstract void handleContent(IModelDelta var1);

    protected abstract void handleRemove(IModelDelta var1);

    protected abstract void handleAdd(IModelDelta var1);

    protected abstract void handleInsert(IModelDelta var1);

    protected abstract void handleReplace(IModelDelta var1);

    protected abstract void handleReveal(IModelDelta var1);

    protected void handleInstall(IModelDelta delta) {
        this.installModelProxy(this.getViewer().getInput(), this.getFullTreePath(delta));
    }

    protected void handleUninstall(IModelDelta delta) {
        this.disposeModelProxy(this.getFullTreePath(delta));
    }

    protected TreePath getFullTreePath(IModelDelta node) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (node.getParentDelta() != null) {
            list.add(0, node.getElement());
            node = node.getParentDelta();
        }
        return new TreePath(list.toArray());
    }

    protected TreePath getViewerTreePath(IModelDelta node) {
        ArrayList<Object> list = new ArrayList<Object>();
        IModelDelta parentDelta = node.getParentDelta();
        while (parentDelta != null) {
            list.add(0, node.getElement());
            node = parentDelta;
            parentDelta = node.getParentDelta();
        }
        return new TreePath(list.toArray());
    }

    protected ITreeModelContentProviderTarget getViewer() {
        return this.fViewer;
    }

    public int viewToModelIndex(TreePath parentPath, int index) {
        return this.fTransform.viewToModelIndex(parentPath, index);
    }

    public int viewToModelCount(TreePath parentPath, int count) {
        return this.fTransform.viewToModelCount(parentPath, count);
    }

    public int modelToViewIndex(TreePath parentPath, int index) {
        return this.fTransform.modelToViewIndex(parentPath, index);
    }

    public int modelToViewChildCount(TreePath parentPath, int count) {
        return this.fTransform.modelToViewCount(parentPath, count);
    }

    protected boolean addFilteredIndex(TreePath parentPath, int index, Object element) {
        return this.fTransform.addFilteredIndex(parentPath, index, element);
    }

    protected void removeElementFromFilters(TreePath parentPath, int index) {
        this.fTransform.removeElementFromFilters(parentPath, index);
    }

    protected boolean removeElementFromFilters(TreePath parentPath, Object element) {
        return this.fTransform.removeElementFromFilters(parentPath, element);
    }

    protected void setModelChildCount(TreePath parentPath, int childCount) {
        this.fTransform.setModelChildCount(parentPath, childCount);
    }

    public boolean shouldFilter(Object parentElementOrTreePath, Object element) {
        ViewerFilter[] filters = this.fViewer.getFilters();
        if (filters.length > 0) {
            int j = 0;
            while (j < filters.length) {
                if (!filters[j].select((Viewer)this.fViewer, parentElementOrTreePath, element)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    protected boolean isFiltered(TreePath parentPath, int index) {
        return this.fTransform.isFiltered(parentPath, index);
    }

    public void unmapPath(TreePath path) {
        this.fTransform.clear(path);
        this.cancelSubtreeUpdates(path);
    }

    protected int[] getFilteredChildren(TreePath parent) {
        return this.fTransform.getFilteredChildren(parent);
    }

    protected void clearFilteredChild(TreePath parent, int modelIndex) {
        this.fTransform.clear(parent, modelIndex);
    }

    protected void clearFilters(TreePath parent) {
        this.fTransform.clear(parent);
    }

    protected synchronized void checkIfRestoreComplete() {
        if (this.fPendingState == null) {
            return;
        }
        class CheckState
        implements IModelDeltaVisitor {
            private boolean complete;
            final /* synthetic */ ModelContentProvider this$0;

            CheckState(ModelContentProvider modelContentProvider) {
                this.this$0 = modelContentProvider;
                this.complete = true;
            }

            public boolean visit(IModelDelta delta, int depth) {
                int flags = delta.getFlags() & 0xFFFFFBFF;
                if (flags != 0) {
                    TreePath deltaPath;
                    IModelDelta parentDelta = delta.getParentDelta();
                    if (!(parentDelta == null || parentDelta.getFlags() != 0 || this.areElementUpdatesPending(deltaPath = this.this$0.getViewerTreePath(delta)) || delta.getElement() instanceof IMemento && this.areMementoUpdatesPending(delta))) {
                        this.removeDelta(delta);
                        return false;
                    }
                    if (flags != 0x1000000 || delta.getElement() instanceof IMemento) {
                        this.complete = false;
                        return false;
                    }
                }
                return true;
            }

            public boolean isComplete() {
                return this.complete;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean areElementUpdatesPending(TreePath path) {
                Map map = ModelContentProvider.access$11(this.this$0);
                synchronized (map) {
                    ViewerUpdateMonitor update;
                    int i;
                    TreePath parentPath = path.getParentPath();
                    List requests = (List)ModelContentProvider.access$12(this.this$0).get(path);
                    if (requests != null) {
                        i = 0;
                        while (i < requests.size()) {
                            update = (ViewerUpdateMonitor)requests.get(i);
                            if (update instanceof ChildrenUpdate) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    if ((requests = (List)ModelContentProvider.access$12(this.this$0).get(parentPath)) != null) {
                        i = 0;
                        while (i < requests.size()) {
                            update = (ViewerUpdateMonitor)requests.get(i);
                            if (update.containsUpdate(path)) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    if ((requests = (List)ModelContentProvider.access$11(this.this$0).get(path)) != null) {
                        i = 0;
                        while (i < requests.size()) {
                            update = (ViewerUpdateMonitor)requests.get(i);
                            if (update instanceof ChildrenUpdate) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    if ((requests = (List)ModelContentProvider.access$11(this.this$0).get(parentPath)) == null) return false;
                    i = 0;
                    while (true) {
                        if (i >= requests.size()) {
                            return false;
                        }
                        update = (ViewerUpdateMonitor)requests.get(i);
                        if (update.getElement().equals(path.getLastSegment())) {
                            return true;
                        }
                        ++i;
                    }
                }
            }

            private boolean areMementoUpdatesPending(IModelDelta delta) {
                Iterator<K> itr = ModelContentProvider.access$7(this.this$0).keySet().iterator();
                while (itr.hasNext()) {
                    CompareRequestKey key = (CompareRequestKey)itr.next();
                    if (!delta.getElement().equals(key.fDelta.getElement())) continue;
                    return true;
                }
                return false;
            }

            private void removeDelta(IModelDelta delta) {
                if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.this$0.getPresentationContext())) {
                    System.out.println("\tRESTORE REMOVED: " + delta.getElement());
                }
                delta.accept(new IModelDeltaVisitor(this){
                    final /* synthetic */ CheckState this$1;
                    {
                        this.this$1 = checkState;
                    }

                    public boolean visit(IModelDelta _visitorDelta, int depth) {
                        ModelDelta visitorDelta = (ModelDelta)_visitorDelta;
                        visitorDelta.setElement("ELEMENT_REMOVED");
                        visitorDelta.setFlags(0);
                        return true;
                    }
                });
            }
        }
        CheckState state = new CheckState(this);
        this.fPendingState.accept(state);
        if (state.isComplete()) {
            if (DEBUG_STATE_SAVE_RESTORE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("STATE RESTORE COMPELTE: " + this.fPendingState);
            }
            this.notifyStateUpdate(this.fPendingState.getElement(), 7, null);
            this.fPendingState = null;
        }
    }

    public void addViewerUpdateListener(IViewerUpdateListener listener) {
        this.fUpdateListeners.add((Object)listener);
    }

    public void removeViewerUpdateListener(IViewerUpdateListener listener) {
        this.fUpdateListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStarted(ViewerUpdateMonitor update) {
        boolean begin = false;
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            begin = this.fRequestsInProgress.isEmpty();
            ArrayList<ViewerUpdateMonitor> requests = (ArrayList<ViewerUpdateMonitor>)this.fRequestsInProgress.get(update.getSchedulingPath());
            if (requests == null) {
                requests = new ArrayList<ViewerUpdateMonitor>();
                this.fRequestsInProgress.put(update.getSchedulingPath(), requests);
            }
            requests.add(update);
        }
        if (begin) {
            if (DEBUG_UPDATE_SEQUENCE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                System.out.println("MODEL SEQUENCE BEGINS");
            }
            this.notifyUpdate(0, null);
        }
        if (DEBUG_UPDATE_SEQUENCE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("\tBEGIN - " + update);
        }
        this.notifyUpdate(2, update);
    }

    void updateComplete(final ViewerUpdateMonitor update) {
        this.notifyUpdate(3, update);
        if (DEBUG_UPDATE_SEQUENCE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            System.out.println("\tEND - " + update);
        }
        new UIJob("Update complete"){
            {
                this.setSystem(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean end = false;
                Map map = ModelContentProvider.this.fRequestsInProgress;
                synchronized (map) {
                    List requests = (List)ModelContentProvider.this.fRequestsInProgress.get(update.getSchedulingPath());
                    if (requests != null) {
                        requests.remove(update);
                        ModelContentProvider.this.trigger(update);
                        if (requests.isEmpty()) {
                            ModelContentProvider.this.fRequestsInProgress.remove(update.getSchedulingPath());
                        }
                    }
                    end = ModelContentProvider.this.fRequestsInProgress.isEmpty();
                }
                if (end) {
                    if (DEBUG_UPDATE_SEQUENCE && ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(ModelContentProvider.this.getPresentationContext())) {
                        System.out.println("MODEL SEQUENCE ENDS");
                    }
                    ModelContentProvider.this.notifyUpdate(1, null);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void notifyUpdate(final int type, final IViewerUpdate update) {
        if (!this.fUpdateListeners.isEmpty()) {
            Object[] listeners = this.fUpdateListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IViewerUpdateListener listener = (IViewerUpdateListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 0: {
                                listener.viewerUpdatesBegin();
                                break;
                            }
                            case 1: {
                                listener.viewerUpdatesComplete();
                                break;
                            }
                            case 2: {
                                listener.updateStarted(update);
                                break;
                            }
                            case 3: {
                                listener.updateComplete(update);
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }
    }

    public void addStateUpdateListener(IStateUpdateListener listener) {
        this.fStateUpdateListeners.add((Object)listener);
    }

    public void removeStateUpdateListener(IStateUpdateListener listener) {
        this.fStateUpdateListeners.remove((Object)listener);
    }

    protected void notifyStateUpdate(final Object input, final int type, final IViewerUpdate update) {
        if (!this.fStateUpdateListeners.isEmpty()) {
            Object[] listeners = this.fStateUpdateListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IStateUpdateListener listener = (IStateUpdateListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 4: {
                                listener.stateSaveUpdatesBegin(input);
                                break;
                            }
                            case 5: {
                                listener.stateSaveUpdatesComplete(input);
                                break;
                            }
                            case 6: {
                                listener.stateRestoreUpdatesBegin(input);
                                break;
                            }
                            case 7: {
                                listener.stateRestoreUpdatesComplete(input);
                                break;
                            }
                            case 2: {
                                listener.stateUpdateStarted(input, update);
                                break;
                            }
                            case 3: {
                                listener.stateUpdateComplete(input, update);
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSubtreeUpdates(TreePath path) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            TreePath entryPath;
            Iterator iterator = this.fRequestsInProgress.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                entryPath = (TreePath)entry.getKey();
                if (!entryPath.startsWith(path, null)) continue;
                List requests = (List)entry.getValue();
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ((IRequest)reqIter.next()).cancel();
                }
            }
            ArrayList<TreePath> purge = new ArrayList<TreePath>();
            iterator = this.fWaitingRequests.keySet().iterator();
            while (iterator.hasNext()) {
                entryPath = (TreePath)iterator.next();
                if (!entryPath.startsWith(path, null)) continue;
                purge.add(entryPath);
            }
            iterator = purge.iterator();
            while (iterator.hasNext()) {
                this.fWaitingRequests.remove(iterator.next());
            }
        }
        Iterator itr = this.fCompareRequestsInProgress.keySet().iterator();
        while (itr.hasNext()) {
            CompareRequestKey key = (CompareRequestKey)itr.next();
            if (!key.fPath.startsWith(path, null)) continue;
            ElementCompareRequest compareRequest = (ElementCompareRequest)this.fCompareRequestsInProgress.get(key);
            compareRequest.cancel();
            itr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(ViewerUpdateMonitor update) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            TreePath schedulingPath = update.getSchedulingPath();
            ArrayList<ViewerUpdateMonitor> requests = (ArrayList<ViewerUpdateMonitor>)this.fWaitingRequests.get(schedulingPath);
            if (requests == null) {
                TreePath parentPath = schedulingPath;
                while (this.fRequestsInProgress.get(parentPath) == null) {
                    if ((parentPath = parentPath.getParentPath()) != null) continue;
                    update.start();
                    return;
                }
            } else {
                Iterator reqIter = requests.iterator();
                while (reqIter.hasNext()) {
                    ViewerUpdateMonitor waiting = (ViewerUpdateMonitor)reqIter.next();
                    if (!waiting.coalesce(update)) continue;
                    return;
                }
                requests.add(update);
                return;
            }
            requests = new ArrayList<ViewerUpdateMonitor>();
            requests.add(update);
            this.fWaitingRequests.put(schedulingPath, requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean getElementChildrenRealized(TreePath path) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            List requests = (List)this.fWaitingRequests.get(path);
            if (requests != null) {
                int i = 0;
                while (i < requests.size()) {
                    if (requests.get(i) instanceof ChildrenUpdate) {
                        return false;
                    }
                    ++i;
                }
            }
            if ((requests = (List)this.fRequestsInProgress.get(path)) == null) return this.getViewer().getElementChildrenRealized(path);
            int numChildrenUpdateRequests = 0;
            int i = 0;
            while (true) {
                if (i >= requests.size()) {
                    return this.getViewer().getElementChildrenRealized(path);
                }
                if (requests.get(i) instanceof ChildrenUpdate && ++numChildrenUpdateRequests > 1) {
                    return false;
                }
                ++i;
            }
        }
    }

    void trigger(ViewerUpdateMonitor request) {
        if (this.fWaitingRequests.isEmpty()) {
            return;
        }
        TreePath schedulingPath = request.getSchedulingPath();
        List waiting = (List)this.fWaitingRequests.get(schedulingPath);
        if (waiting == null) {
            int length = Integer.MAX_VALUE;
            Iterator entries = this.fWaitingRequests.entrySet().iterator();
            Map.Entry candidate = null;
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                TreePath key = (TreePath)entry.getKey();
                if (key.getSegmentCount() >= length) continue;
                candidate = entry;
                length = key.getSegmentCount();
            }
            if (candidate != null) {
                this.startHighestPriorityRequest((TreePath)candidate.getKey(), (List)candidate.getValue());
            }
        } else {
            this.startHighestPriorityRequest(schedulingPath, waiting);
        }
    }

    private void startHighestPriorityRequest(TreePath key, List waiting) {
        int priority = 4;
        ViewerUpdateMonitor next = null;
        Iterator requests = waiting.iterator();
        while (requests.hasNext()) {
            ViewerUpdateMonitor vu = (ViewerUpdateMonitor)requests.next();
            if (vu.getPriority() >= priority) continue;
            next = vu;
            priority = next.getPriority();
        }
        if (next != null) {
            waiting.remove(next);
            if (waiting.isEmpty()) {
                this.fWaitingRequests.remove(key);
            }
            next.start();
        }
    }

    public void addModelChangedListener(IModelChangedListener listener) {
        this.fModelListeners.add((Object)listener);
    }

    public void removeModelChangedListener(IModelChangedListener listener) {
        this.fModelListeners.remove((Object)listener);
    }

    protected Object getElement(TreePath path) {
        if (path.getSegmentCount() > 0) {
            return path.getLastSegment();
        }
        return this.getViewer().getInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescheduleUpdates(TreePath parentPath, int modelIndex) {
        Map map = this.fRequestsInProgress;
        synchronized (map) {
            IChildrenUpdate childrenUpdate;
            IViewerUpdate update;
            Iterator iterator;
            List requests = (List)this.fRequestsInProgress.get(parentPath);
            ArrayList<IChildrenUpdate> reCreate = null;
            if (requests != null) {
                iterator = requests.iterator();
                while (iterator.hasNext()) {
                    update = (IViewerUpdate)iterator.next();
                    if (!(update instanceof IChildrenUpdate) || (childrenUpdate = (IChildrenUpdate)update).getOffset() <= modelIndex) continue;
                    childrenUpdate.cancel();
                    if (reCreate == null) {
                        reCreate = new ArrayList<IChildrenUpdate>();
                    }
                    reCreate.add(childrenUpdate);
                    if (!DEBUG_CONTENT_PROVIDER || !ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) continue;
                    System.out.println("canceled update in progress handling REMOVE: " + childrenUpdate);
                }
            }
            if ((requests = (List)this.fWaitingRequests.get(parentPath)) != null) {
                iterator = requests.iterator();
                while (iterator.hasNext()) {
                    update = (IViewerUpdate)iterator.next();
                    if (!(update instanceof IChildrenUpdate) || (childrenUpdate = (IChildrenUpdate)update).getOffset() <= modelIndex) continue;
                    ((ChildrenUpdate)childrenUpdate).setOffset(childrenUpdate.getOffset() - 1);
                    if (!DEBUG_CONTENT_PROVIDER || !ModelContentProvider.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) continue;
                    System.out.println("modified waiting update handling REMOVE: " + childrenUpdate);
                }
            }
            if (reCreate != null) {
                iterator = reCreate.iterator();
                while (iterator.hasNext()) {
                    IChildrenUpdate childrenUpdate2 = (IChildrenUpdate)iterator.next();
                    int start = childrenUpdate2.getOffset() - 1;
                    int end = start + childrenUpdate2.getLength();
                    int i = start;
                    while (i < end) {
                        ((TreeModelContentProvider)this).doUpdateElement(parentPath, i);
                        ++i;
                    }
                }
            }
        }
    }

    static /* synthetic */ void access$1(ModelContentProvider modelContentProvider, ModelDelta modelDelta) {
        modelContentProvider.fPendingState = modelDelta;
    }

    static /* synthetic */ ModelDelta access$2(ModelContentProvider modelContentProvider) {
        return modelContentProvider.fPendingState;
    }

    static /* synthetic */ Map access$12(ModelContentProvider modelContentProvider) {
        return modelContentProvider.fWaitingRequests;
    }

    private static class CompareRequestKey {
        TreePath fPath;
        IModelDelta fDelta;

        CompareRequestKey(TreePath path, IModelDelta delta) {
            this.fPath = path;
            this.fDelta = delta;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CompareRequestKey) {
                CompareRequestKey key = (CompareRequestKey)obj;
                return key.fDelta.equals(this.fDelta) && key.fPath.equals((Object)this.fPath);
            }
            return false;
        }

        public int hashCode() {
            return this.fDelta.hashCode() + this.fPath.hashCode();
        }
    }

    class LRUMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private int fMaxSize;

        LRUMap(int maxSize) {
            this.fMaxSize = maxSize;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.fMaxSize;
        }
    }
}

