/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.AbstractNotification;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.ui.ITaskListNotificationProvider;
import org.eclipse.mylyn.internal.tasks.ui.notifications.Messages;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDataDiff;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotification;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListNotifier
implements ITaskDataManagerListener,
ITaskListNotificationProvider {
    private final TaskDataManager taskDataManager;
    private final List<TaskListNotification> notificationQueue = new ArrayList<TaskListNotification>();
    private final RepositoryModel repositoryModel;
    public boolean enabled;

    public TaskListNotifier(RepositoryModel repositoryModel, TaskDataManager taskDataManager) {
        this.repositoryModel = repositoryModel;
        this.taskDataManager = taskDataManager;
        this.taskDataManager.addListener((ITaskDataManagerListener)this);
    }

    public TaskListNotification getNotification(ITask task, Object token) {
        TaskDataDiff diff;
        if (task.getSynchronizationState() == ITask.SynchronizationState.INCOMING_NEW) {
            TaskListNotification notification = new TaskListNotification(task, token);
            notification.setDescription(Messages.TaskListNotifier_New_unread_task);
            return notification;
        }
        if (task.getSynchronizationState() == ITask.SynchronizationState.INCOMING && (diff = this.getDiff(task)) != null) {
            TaskListNotification notification = new TaskListNotification(task, token);
            notification.setDescription(diff.toString(60, true));
            return notification;
        }
        return null;
    }

    public TaskDataDiff getDiff(ITask task) {
        try {
            TaskDataState workingCopy = this.taskDataManager.getTaskDataState(task);
            if (workingCopy != null) {
                TaskDataDiff diff = new TaskDataDiff(this.repositoryModel, workingCopy.getRepositoryData(), workingCopy.getLastReadData());
                return diff;
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to get task data for task: \"" + task + "\"", (Throwable)e));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskDataUpdated(TaskDataManagerEvent event) {
        TaskListNotification notification;
        AbstractRepositoryConnectorUi connectorUi;
        List<TaskListNotification> list = this.notificationQueue;
        synchronized (list) {
            if (!this.enabled) {
                return;
            }
        }
        if (event.getToken() != null && event.getTaskDataChanged() && !(connectorUi = TasksUi.getRepositoryConnectorUi(event.getTaskData().getConnectorKind())).hasCustomNotifications() && (notification = this.getNotification(event.getTask(), event.getToken())) != null) {
            List<TaskListNotification> list2 = this.notificationQueue;
            synchronized (list2) {
                if (this.enabled) {
                    this.notificationQueue.add(notification);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AbstractNotification> getNotifications() {
        List<TaskListNotification> list = this.notificationQueue;
        synchronized (list) {
            if (this.notificationQueue.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<AbstractNotification> result = new HashSet<AbstractNotification>(this.notificationQueue);
            this.notificationQueue.clear();
            return result;
        }
    }

    public void editsDiscarded(TaskDataManagerEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        List<TaskListNotification> list = this.notificationQueue;
        synchronized (list) {
            if (!enabled) {
                this.notificationQueue.clear();
            }
            this.enabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        List<TaskListNotification> list = this.notificationQueue;
        synchronized (list) {
            return this.enabled;
        }
    }
}

