/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

public class MacVMSearch {
    private static final String JVM_VERSION_LOC = "/System/Library/Frameworks/JavaVM.framework/Versions/";
    private static final String CURRENT_JVM = "CurrentJDK";
    private static final String JVM_ROOT = "Home";

    public VMStandin[] search(IProgressMonitor monitor) {
        File versionDir;
        ArrayList<VMStandin> vms = new ArrayList<VMStandin>();
        IVMInstallType macVMType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.launching.macosx.MacOSXType");
        if (macVMType != null && (versionDir = new File(JVM_VERSION_LOC)).exists() && versionDir.isDirectory()) {
            File currentJDK = new File(versionDir, CURRENT_JVM);
            try {
                currentJDK = currentJDK.getCanonicalFile();
            }
            catch (IOException iOException) {}
            File[] versions = versionDir.listFiles();
            SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JREMessages.MacVMSearch_0, (int)versions.length);
            try {
                int i = 0;
                while (i < versions.length) {
                    String version = versions[i].getName();
                    File home = new File(versions[i], JVM_ROOT);
                    if (home.exists()) {
                        boolean isDefault = currentJDK.equals(versions[i]);
                        if (!CURRENT_JVM.equals(version)) {
                            String arguments;
                            VMStandin vm = new VMStandin(macVMType, version);
                            vm.setInstallLocation(home);
                            String format = isDefault ? JREMessages.MacVMSearch_1 : JREMessages.MacVMSearch_2;
                            vm.setName(MessageFormat.format(format, version));
                            vm.setLibraryLocations(macVMType.getDefaultLibraryLocations(home));
                            URL doc = ((AbstractVMInstallType)macVMType).getDefaultJavadocLocation(home);
                            if (doc != null) {
                                vm.setJavadocLocation(doc);
                            }
                            if ((arguments = ((AbstractVMInstallType)macVMType).getDefaultVMArguments(home)) != null) {
                                vm.setVMArgs(arguments);
                            }
                            vms.add(vm);
                        }
                    }
                    if (localmonitor.isCanceled()) {
                        break;
                    }
                    localmonitor.worked(1);
                    ++i;
                }
            }
            finally {
                if (localmonitor != null) {
                    localmonitor.done();
                }
            }
        }
        return vms.toArray(new VMStandin[vms.size()]);
    }
}

