/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.jaxb.core.schemagen;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import org.eclipse.jpt.eclipselink.jaxb.core.schemagen.JptSchemaOutputResolver;
import org.eclipse.jpt.eclipselink.jaxb.core.schemagen.internal.JptEclipseLinkJaxbCoreMessages;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

public class Main {
    private String[] sourceClassNames;
    private String targetSchemaName;
    private boolean isDebugMode;
    public static String NO_FACTORY_CLASS = "doesnt contain ObjectFactory.class";
    public static String CANNOT_BE_CAST_TO_JAXBCONTEXT = "cannot be cast to org.eclipse.persistence.jaxb.JAXBContext";

    public static void main(String[] args) {
        new Main().execute(args);
    }

    private Main() {
    }

    protected void execute(String[] args) {
        this.initializeWith(args);
        this.generate();
    }

    private void initializeWith(String[] args) {
        this.sourceClassNames = this.getSourceClassNames(args);
        this.targetSchemaName = this.getTargetSchemaName(args);
        this.isDebugMode = this.getDebugMode(args);
    }

    private void generate() {
        JAXBContext jaxbContext = this.buildJaxbContext();
        if (jaxbContext != null) {
            this.generateSchema(jaxbContext);
        }
        String result = jaxbContext != null ? this.bind("SCHEMA_GENERATED", this.targetSchemaName) : this.bind("SCHEMA_NOT_CREATED", this.targetSchemaName);
        System.out.println(result);
    }

    private JAXBContext buildJaxbContext() {
        System.out.println(this.getString("LOADING_CLASSES"));
        JAXBContext jaxbContext = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class[] sourceClasses = this.buildSourceClasses(this.sourceClassNames, loader);
            jaxbContext = (JAXBContext)JAXBContextFactory.createContext((Class[])sourceClasses, Collections.emptyMap());
        }
        catch (JAXBException ex) {
            this.handleJaxbException(ex);
        }
        catch (ClassCastException ex) {
            this.handleClassCastException(ex);
        }
        return jaxbContext;
    }

    private void generateSchema(JAXBContext jaxbContext) {
        System.out.println(this.getString("GENERATING_SCHEMA"));
        System.out.flush();
        JptSchemaOutputResolver schemaOutputResolver = new JptSchemaOutputResolver(this.targetSchemaName);
        try {
            jaxbContext.generateSchema((SchemaOutputResolver)schemaOutputResolver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Class[] buildSourceClasses(String[] classNames, ClassLoader loader) {
        ArrayList sourceClasses = new ArrayList(classNames.length);
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            try {
                sourceClasses.add(loader.loadClass(className));
                System.out.println(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(this.bind("NOT_FOUND", className));
            }
            ++n2;
        }
        System.out.flush();
        return sourceClasses.toArray(new Class[0]);
    }

    private void handleJaxbException(JAXBException ex) {
        String message = ex.getMessage();
        Throwable linkedEx = ex.getLinkedException();
        if (message != null && message.indexOf(NO_FACTORY_CLASS) > -1) {
            System.err.println(message);
        } else if (linkedEx != null && linkedEx instanceof ClassNotFoundException) {
            String errorMessage = this.bind("CONTEXT_FACTORY_NOT_FOUND", linkedEx.getMessage());
            System.err.println(errorMessage);
        } else {
            ex.printStackTrace();
        }
    }

    private void handleClassCastException(ClassCastException ex) {
        String message = ex.getMessage();
        if (message != null && message.indexOf(CANNOT_BE_CAST_TO_JAXBCONTEXT) > -1) {
            System.err.println(this.getString("PROPERTIES_FILE_NOT_FOUND"));
        } else {
            ex.printStackTrace();
        }
    }

    private String getString(String key) {
        return JptEclipseLinkJaxbCoreMessages.getString(key);
    }

    private String bind(String key, Object argument) {
        return MessageFormat.format(this.getString(key), argument);
    }

    private String[] getSourceClassNames(String[] args) {
        return this.getAllArgumentValues("-c", args);
    }

    private String getTargetSchemaName(String[] args) {
        return this.getArgumentValue("-s", args);
    }

    private boolean getDebugMode(String[] args) {
        return this.argumentExists("-debug", args);
    }

    private String getArgumentValue(String argName, String[] args) {
        int i = 0;
        while (i < args.length) {
            int j;
            String arg = args[i];
            if (arg.toLowerCase().equals(argName) && (j = i + 1) < args.length) {
                return args[j];
            }
            ++i;
        }
        return null;
    }

    private String[] getAllArgumentValues(String argName, String[] args) {
        ArrayList<String> argValues = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            int j;
            String arg = args[i];
            if (arg.toLowerCase().equals(argName) && (j = i + 1) < args.length) {
                argValues.add(args[j]);
                ++i;
            }
            ++i;
        }
        return argValues.toArray(new String[0]);
    }

    private boolean argumentExists(String argName, String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.toLowerCase().equals(argName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

